/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid0;

import io.odilon.error.OdilonObjectNotFoundException;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.virtualFileSystem.ObjectPath;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.SimpleDrive;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.raid0.RAIDZeroDriver;
import io.odilon.virtualFileSystem.raid0.RAIDZeroTransactionObjectHandler;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FileUtils;

@ThreadSafe
public class RAIDZeroUpdateObjectHandler
extends RAIDZeroTransactionObjectHandler {
    private static Logger logger = Logger.getLogger((String)RAIDZeroUpdateObjectHandler.class.getName());

    protected RAIDZeroUpdateObjectHandler(RAIDZeroDriver rAIDZeroDriver, ServerBucket serverBucket, String string) {
        super(rAIDZeroDriver, serverBucket, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void update(InputStream inputStream, String string, String string2, Optional<List<String>> optional) {
        boolean bl = false;
        boolean bl2 = false;
        VirtualFileSystemOperation virtualFileSystemOperation = null;
        int n = -1;
        this.objectWriteLock();
        try {
            this.bucketReadLock();
            try (InputStream inputStream2 = inputStream;){
                this.checkExistsBucket();
                this.checkExistObject();
                ObjectMetadata objectMetadata = this.getMetadata();
                n = objectMetadata.getVersion();
                this.backup(objectMetadata.getVersion());
                virtualFileSystemOperation = this.updateObject(objectMetadata.getVersion());
                this.save(inputStream, string, string2, objectMetadata.getVersion() + 1, optional);
                bl2 = virtualFileSystemOperation.commit();
            }
            catch (OdilonObjectNotFoundException odilonObjectNotFoundException) {
                try {
                    bl = true;
                    throw odilonObjectNotFoundException;
                    catch (InternalCriticalException internalCriticalException) {
                        bl = true;
                        throw internalCriticalException;
                    }
                    catch (Exception exception) {
                        bl = true;
                        throw new InternalCriticalException(exception, this.info());
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (!bl2) {
                            try {
                                this.rollback(virtualFileSystemOperation);
                                throw throwable;
                            }
                            catch (Exception exception) {
                                if (!bl) {
                                    throw new InternalCriticalException(exception, this.info());
                                }
                                logger.error((Throwable)exception, new String[]{this.info(), "---- not thrown ----"});
                                throw throwable;
                            }
                        }
                        try {
                            if (this.isVersionControl()) throw throwable;
                            if (n < 0) throw throwable;
                            FileUtils.deleteQuietly((File)this.getObjectPath().metadataFileVersionPath(n).toFile());
                            FileUtils.deleteQuietly((File)this.getObjectPath().dataFileVersionPath(n).toFile());
                            throw throwable;
                        }
                        catch (Exception exception) {
                            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                            throw throwable;
                        }
                    }
                    finally {
                        this.bucketReadUnLock();
                    }
                }
            }
            try {
                if (!bl2) {
                    try {
                        this.rollback(virtualFileSystemOperation);
                        return;
                    }
                    catch (Exception exception) {
                        if (!bl) {
                            throw new InternalCriticalException(exception, this.info());
                        }
                        logger.error((Throwable)exception, new String[]{this.info(), "---- not thrown ----"});
                        return;
                    }
                }
                try {
                    if (this.isVersionControl()) return;
                    if (n < 0) return;
                    FileUtils.deleteQuietly((File)this.getObjectPath().metadataFileVersionPath(n).toFile());
                    FileUtils.deleteQuietly((File)this.getObjectPath().dataFileVersionPath(n).toFile());
                    return;
                }
                catch (Exception exception) {
                    logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                    return;
                }
            }
            finally {
                this.bucketReadUnLock();
            }
        }
        finally {
            this.objectWriteUnLock();
        }
    }

    private void save(InputStream inputStream, String string, String string2, int n, Optional<List<String>> optional) {
        long l = this.saveData(this.getBucket(), this.getObjectName(), inputStream, string);
        this.saveMetadata(this.getBucket(), this.getObjectName(), string, l, string2, n, optional);
    }

    private void backup(int n) {
        Drive drive = this.getWriteDrive(this.getBucket(), this.getObjectName());
        try {
            ObjectPath objectPath = this.getObjectPath();
            File file = objectPath.dataFilePath().toFile();
            ((SimpleDrive)drive).putObjectDataVersionFile(this.getBucket().getId(), this.getObjectName(), n, file);
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, this.info());
        }
        try {
            drive.putObjectMetadataVersionFile(this.getBucket(), this.getObjectName(), n, drive.getObjectMetadataFile(this.getBucket(), this.getObjectName()));
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, this.info());
        }
    }

    private VirtualFileSystemOperation updateObject(int n) {
        return this.updateObject(this.getBucket(), this.getObjectName(), n);
    }
}

