/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.odilon.errors.InternalCriticalException;
import io.odilon.virtualFileSystem.model.BucketIterator;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.IODriver;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.raid1.RAIDOneDriver;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class RAIDOneBucketIterator
extends BucketIterator
implements Closeable {
    @JsonProperty(value="drive")
    private final Drive drive;
    @JsonIgnore
    private Iterator<Path> it;
    @JsonIgnore
    private Stream<Path> stream;

    public RAIDOneBucketIterator(RAIDOneDriver rAIDOneDriver, ServerBucket serverBucket, Optional<Long> optional, Optional<String> optional2) {
        super((IODriver)rAIDOneDriver, serverBucket);
        optional2.ifPresent(string -> this.setPrefix(string.toLowerCase().trim()));
        optional.ifPresent(l -> this.setOffset(l));
        this.drive = (Drive)this.getDriver().getDrivesEnabled().get(Double.valueOf(Math.abs(Math.random() * 10000.0)).intValue() % this.getDriver().getDrivesEnabled().size());
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.getStream() != null) {
            this.getStream().close();
        }
    }

    protected void init() {
        Path path2 = new File(this.getDrive().getBucketMetadataDirPath(this.getBucket())).toPath();
        try {
            this.stream = Files.walk(path2, 1, new FileVisitOption[0]).skip(1L).filter(path -> Files.isDirectory(path, new LinkOption[0])).filter(path -> this.getPrefix() == null || path.getFileName().toString().toLowerCase().startsWith(this.getPrefix())).filter(path -> this.isValidState(path));
        }
        catch (IOException iOException) {
            throw new InternalCriticalException((Exception)iOException);
        }
        this.it = this.stream.iterator();
        this.skipOffset();
        this.setInitiated(true);
    }

    protected boolean fetch() {
        this.setRelativeIndex(0);
        this.setBuffer(new ArrayList());
        boolean bl = true;
        while (bl && this.getBuffer().size() < this.defaultBufferSize()) {
            if (this.getIt().hasNext()) {
                this.getBuffer().add((Path)this.getIt().next());
                continue;
            }
            bl = false;
        }
        return !this.getBuffer().isEmpty();
    }

    private void skipOffset() {
        if (this.getOffset() == 0L) {
            return;
        }
        boolean bl = true;
        int n = 0;
        while (bl && (long)n < this.getOffset() && this.getIt().hasNext()) {
            this.getIt().next();
            ++n;
        }
    }

    private Drive getDrive() {
        return this.drive;
    }

    private Iterator<Path> getIt() {
        return this.it;
    }

    private Stream<Path> getStream() {
        return this.stream;
    }
}

