/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid1;

import io.odilon.encryption.EncryptedResult;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.model.ObjectStatus;
import io.odilon.util.OdilonFileUtils;
import io.odilon.virtualFileSystem.ObjectPath;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.raid1.RAIDOneDriver;
import io.odilon.virtualFileSystem.raid1.RAIDOneTransactionObjectHandler;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class RAIDOneCreateObjectHandler
extends RAIDOneTransactionObjectHandler {
    private static Logger logger = Logger.getLogger((String)RAIDOneCreateObjectHandler.class.getName());

    protected RAIDOneCreateObjectHandler(RAIDOneDriver rAIDOneDriver, ServerBucket serverBucket, String string) {
        super(rAIDOneDriver, serverBucket, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void create(InputStream inputStream, String string, String string2, Optional<List<String>> optional) {
        VirtualFileSystemOperation virtualFileSystemOperation = null;
        boolean bl = false;
        boolean bl2 = false;
        this.objectWriteLock();
        try {
            this.bucketReadLock();
            try (InputStream inputStream2 = inputStream;){
                this.checkExistsBucket();
                this.checkNotExistObject();
                virtualFileSystemOperation = this.createObject();
                long l = this.saveData(inputStream, string);
                this.saveMetadata(string, l, string2, optional);
                bl = virtualFileSystemOperation.commit();
            }
            catch (InternalCriticalException internalCriticalException) {
                try {
                    bl2 = true;
                    throw internalCriticalException;
                    catch (Exception exception) {
                        bl = false;
                        bl2 = true;
                        throw new InternalCriticalException(exception, this.info());
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (bl) throw throwable;
                        try {
                            this.rollback(virtualFileSystemOperation);
                            throw throwable;
                        }
                        catch (Exception exception) {
                            if (!bl2) {
                                throw new InternalCriticalException(exception, this.info(string));
                            }
                            logger.error((Throwable)exception, new String[]{this.info(string), "---- not thrown ----"});
                            throw throwable;
                        }
                    }
                    finally {
                        this.bucketReadUnLock();
                    }
                }
            }
            try {
                if (bl) return;
                try {
                    this.rollback(virtualFileSystemOperation);
                    return;
                }
                catch (Exception exception) {
                    if (!bl2) {
                        throw new InternalCriticalException(exception, this.info(string));
                    }
                    logger.error((Throwable)exception, new String[]{this.info(string), "---- not thrown ----"});
                    return;
                }
            }
            finally {
                this.bucketReadUnLock();
            }
        }
        finally {
            this.objectWriteUnLock();
        }
    }

    /*
     * Loose catch block
     */
    private long saveData(InputStream inputStream, String string) {
        long l;
        Object object;
        InputStream inputStream2;
        boolean bl;
        BufferedOutputStream[] bufferedOutputStreamArray;
        int n;
        block64: {
            block63: {
                Object object2;
                n = this.getDriver().getDrivesAll().size();
                long l2 = 0L;
                byte[] byArray = new byte[8192];
                bufferedOutputStreamArray = new BufferedOutputStream[n];
                bl = false;
                if (this.isEncrypt()) {
                    long l3;
                    Object object3;
                    InputStream inputStream3;
                    block62: {
                        block61: {
                            Object object4;
                            EncryptedResult encryptedResult = this.getEncryptionService().encryptStream(inputStream);
                            inputStream3 = encryptedResult.getInputStream();
                            int n2 = 0;
                            for (Drive drive : this.getDriver().getDrivesAll()) {
                                object4 = new ObjectPath(drive, this.getBucket().getId(), this.getObjectName());
                                object3 = object4.dataFilePath().toString();
                                bufferedOutputStreamArray[n2++] = new BufferedOutputStream(new FileOutputStream((String)object3), 8192);
                            }
                            int n3 = 0;
                            if (this.getDriver().getDrivesAll().size() < 2) {
                                while ((n3 = inputStream3.read(byArray, 0, byArray.length)) >= 0) {
                                    for (int i = 0; i < n; ++i) {
                                        bufferedOutputStreamArray[i].write(byArray, 0, n3);
                                    }
                                }
                            } else {
                                int n4 = this.getDriver().getDrivesAll().size();
                                object4 = this.getVirtualFileSystemService().getExecutorService();
                                while ((n3 = inputStream3.read(byArray, 0, byArray.length)) >= 0) {
                                    object3 = new ArrayList(n4);
                                    int n5 = 0;
                                    while (n5 < n) {
                                        int n6 = n5++;
                                        int n7 = n3;
                                        object3.add(() -> {
                                            try {
                                                bufferedOutputStreamArray[n6].write(byArray, 0, n7);
                                                return true;
                                            }
                                            catch (Exception exception) {
                                                logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                                                return false;
                                            }
                                        });
                                    }
                                    try {
                                        List list = object4.invokeAll(object3, 15L, TimeUnit.MINUTES);
                                        Iterator iterator = list.iterator();
                                        while (iterator.hasNext()) {
                                            if (((Boolean)iterator.next().get()).booleanValue()) continue;
                                            throw new InternalCriticalException(this.info(string));
                                        }
                                    }
                                    catch (InterruptedException | ExecutionException exception) {
                                        throw new InternalCriticalException(exception, this.info(string));
                                    }
                                }
                            }
                            l3 = l2 = encryptedResult.getCountingStream().getCount();
                            if (inputStream3 == null) break block61;
                            inputStream3.close();
                        }
                        object3 = null;
                        if (bufferedOutputStreamArray == null) break block62;
                        try {
                            for (int i = 0; i < n; ++i) {
                                if (bufferedOutputStreamArray[i] == null) continue;
                                bufferedOutputStreamArray[i].close();
                            }
                        }
                        catch (IOException iOException) {
                            logger.error((Throwable)iOException, new String[]{this.info(string) + (bl ? "---- not thrown ----" : "")});
                            object3 = iOException;
                        }
                    }
                    if (!bl && object3 != null) {
                        throw new InternalCriticalException((Exception)object3);
                    }
                    return l3;
                    {
                        catch (Throwable throwable) {
                            try {
                                try {
                                    if (inputStream3 != null) {
                                        try {
                                            inputStream3.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (InternalCriticalException internalCriticalException) {
                                    bl = true;
                                    throw internalCriticalException;
                                }
                                catch (Exception exception) {
                                    bl = true;
                                    throw new InternalCriticalException(exception, this.info(string));
                                }
                            }
                            catch (Throwable throwable3) {
                                IOException iOException = null;
                                if (bufferedOutputStreamArray != null) {
                                    try {
                                        for (int i = 0; i < n; ++i) {
                                            if (bufferedOutputStreamArray[i] == null) continue;
                                            bufferedOutputStreamArray[i].close();
                                        }
                                    }
                                    catch (IOException iOException2) {
                                        logger.error((Throwable)iOException2, new String[]{this.info(string) + (bl ? "---- not thrown ----" : "")});
                                        iOException = iOException2;
                                    }
                                }
                                if (!bl && iOException != null) {
                                    throw new InternalCriticalException(iOException);
                                }
                                throw throwable3;
                            }
                        }
                    }
                }
                inputStream2 = inputStream;
                int n8 = 0;
                for (Drive drive : this.getDriver().getDrivesAll()) {
                    object2 = new ObjectPath(drive, this.getBucket().getId(), this.getObjectName());
                    object = object2.dataFilePath().toString();
                    bufferedOutputStreamArray[n8++] = new BufferedOutputStream(new FileOutputStream((String)object), 8192);
                }
                int n9 = 0;
                if (this.getDriver().getDrivesAll().size() < 2) {
                    while ((n9 = inputStream2.read(byArray, 0, byArray.length)) >= 0) {
                        for (int i = 0; i < n; ++i) {
                            bufferedOutputStreamArray[i].write(byArray, 0, n9);
                            l2 += (long)n9;
                        }
                    }
                } else {
                    int n10 = this.getDriver().getDrivesAll().size();
                    object2 = this.getVirtualFileSystemService().getExecutorService();
                    while ((n9 = inputStream2.read(byArray, 0, byArray.length)) >= 0) {
                        l2 += (long)n9;
                        object = new ArrayList(n10);
                        int n11 = 0;
                        while (n11 < n) {
                            int n12 = n11++;
                            int n13 = n9;
                            object.add(() -> {
                                try {
                                    bufferedOutputStreamArray[n6].write(byArray, 0, n7);
                                    return true;
                                }
                                catch (Exception exception) {
                                    logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                                    return false;
                                }
                            });
                        }
                        try {
                            List list = object2.invokeAll(object, 15L, TimeUnit.MINUTES);
                            Iterator iterator = list.iterator();
                            while (iterator.hasNext()) {
                                if (((Boolean)iterator.next().get()).booleanValue()) continue;
                                throw new InternalCriticalException(this.info(string));
                            }
                        }
                        catch (InterruptedException | ExecutionException exception) {
                            throw new InternalCriticalException(exception, this.info(string));
                        }
                    }
                }
                l = l2;
                if (inputStream2 == null) break block63;
                inputStream2.close();
            }
            object = null;
            if (bufferedOutputStreamArray == null) break block64;
            try {
                for (int i = 0; i < n; ++i) {
                    if (bufferedOutputStreamArray[i] == null) continue;
                    bufferedOutputStreamArray[i].close();
                }
            }
            catch (IOException iOException) {
                logger.error((Throwable)iOException, new String[]{this.info(string) + (bl ? "---- not thrown ----" : "")});
                object = iOException;
            }
        }
        if (!bl && object != null) {
            throw new InternalCriticalException((Exception)object);
        }
        return l;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (inputStream2 != null) {
                            try {
                                inputStream2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        }
                        throw throwable;
                    }
                    catch (InternalCriticalException internalCriticalException) {
                        bl = true;
                        throw internalCriticalException;
                    }
                    catch (Exception exception) {
                        bl = true;
                        throw new InternalCriticalException(exception, this.info(string));
                    }
                }
                catch (Throwable throwable5) {
                    IOException iOException = null;
                    if (bufferedOutputStreamArray != null) {
                        try {
                            for (int i = 0; i < n; ++i) {
                                if (bufferedOutputStreamArray[i] == null) continue;
                                bufferedOutputStreamArray[i].close();
                            }
                        }
                        catch (IOException iOException3) {
                            logger.error((Throwable)iOException3, new String[]{this.info(string) + (bl ? "---- not thrown ----" : "")});
                            iOException = iOException3;
                        }
                    }
                    if (!bl && iOException != null) {
                        throw new InternalCriticalException(iOException);
                    }
                    throw throwable5;
                }
            }
        }
    }

    private void saveMetadata(String string, long l, String string2, Optional<List<String>> optional) {
        String string3 = null;
        String string4 = null;
        OffsetDateTime offsetDateTime = OffsetDateTime.now();
        ArrayList<ObjectMetadata> arrayList = new ArrayList<ObjectMetadata>();
        for (Drive drive : this.getDriver().getDrivesAll()) {
            ObjectPath objectPath = new ObjectPath(drive, this.getBucket(), this.getObjectName());
            File file = objectPath.dataFilePath().toFile();
            try {
                String string5 = OdilonFileUtils.calculateSHA256String((File)file);
                if (string3 == null) {
                    string3 = string5;
                    string4 = drive.getName();
                } else if (!string5.equals(string3)) {
                    throw new InternalCriticalException("SHA 256 are not equal for -> d:" + string4 + " ->" + string3 + " vs d:" + drive.getName() + " -> " + string5);
                }
                ObjectMetadata objectMetadata = new ObjectMetadata(this.getBucket().getId(), this.getObjectName());
                objectMetadata.setFileName(string);
                objectMetadata.setAppVersion("1.15");
                objectMetadata.setContentType(string2);
                objectMetadata.setCreationDate(offsetDateTime);
                objectMetadata.setVersion(0);
                objectMetadata.setVersioncreationDate(offsetDateTime);
                objectMetadata.setSourceLength(l);
                objectMetadata.setLength(file.length());
                objectMetadata.setEtag(string5);
                objectMetadata.setEncrypt(this.getVirtualFileSystemService().isEncrypt());
                objectMetadata.setSha256(string5);
                objectMetadata.setIntegrityCheck(offsetDateTime);
                objectMetadata.setStatus(ObjectStatus.ENABLED);
                objectMetadata.setDrive(drive.getName());
                objectMetadata.setRaid(String.valueOf(this.getRedundancyLevel().getCode()).trim());
                objectMetadata.setRaidDrives(this.getDriver().getTotalDisks());
                if (optional.isPresent()) {
                    objectMetadata.setCustomTags(optional.get());
                }
                arrayList.add(objectMetadata);
            }
            catch (Exception exception) {
                throw new InternalCriticalException(exception, this.info(string));
            }
        }
        this.saveRAIDOneObjectMetadataToDisk(this.getDriver().getDrivesAll(), arrayList, true);
    }

    private VirtualFileSystemOperation createObject() {
        return this.createObject(this.getBucket(), this.getObjectName());
    }
}

