/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid1;

import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.scheduler.AfterDeleteObjectServiceRequest;
import io.odilon.scheduler.ServiceRequest;
import io.odilon.virtualFileSystem.ObjectPath;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.raid1.RAIDOneDriver;
import io.odilon.virtualFileSystem.raid1.RAIDOneTransactionObjectHandler;
import java.io.File;
import java.io.IOException;
import java.time.OffsetDateTime;
import org.apache.commons.io.FileUtils;

public class RAIDOneDeleteObjectAllPreviousVersionsHandler
extends RAIDOneTransactionObjectHandler {
    private static Logger logger = Logger.getLogger((String)RAIDOneDeleteObjectAllPreviousVersionsHandler.class.getName());

    public RAIDOneDeleteObjectAllPreviousVersionsHandler(RAIDOneDriver rAIDOneDriver, ServerBucket serverBucket, String string) {
        super(rAIDOneDriver, serverBucket, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void delete() {
        ObjectMetadata objectMetadata;
        boolean bl;
        VirtualFileSystemOperation virtualFileSystemOperation;
        block38: {
            virtualFileSystemOperation = null;
            bl = false;
            boolean bl2 = false;
            objectMetadata = null;
            this.objectWriteLock();
            try {
                block37: {
                    this.bucketReadLock();
                    this.checkExistsBucket();
                    this.checkExistObject();
                    objectMetadata = this.getMetadata();
                    if (objectMetadata.getVersion() != 0) break block37;
                    try {
                        if (bl) {
                            this.postObjectPreviousVersionDeleteAllCommit(objectMetadata.getVersion());
                            return;
                        }
                        try {
                            this.rollback(virtualFileSystemOperation);
                            return;
                        }
                        catch (Exception exception) {
                            if (!bl2) {
                                throw new InternalCriticalException(exception, this.info());
                            }
                            logger.error((Throwable)exception, new String[]{this.info(), "---- not thrown ----"});
                            return;
                        }
                    }
                    finally {
                        this.bucketReadUnLock();
                    }
                }
                this.backupMetadata();
                virtualFileSystemOperation = this.deleteObjectPreviousVersions(objectMetadata.getVersion());
                for (int i = 0; i < objectMetadata.getVersion(); ++i) {
                    for (Drive drive2 : this.getDriver().getDrivesAll()) {
                        FileUtils.deleteQuietly((File)drive2.getObjectMetadataVersionFile(this.getBucket(), this.getObjectName(), i));
                    }
                }
                objectMetadata.addSystemTag("delete versions");
                objectMetadata.lastModified = OffsetDateTime.now();
                for (Drive drive : this.getDriver().getDrivesAll()) {
                    Drive drive2;
                    drive2 = drive.getObjectMetadata(this.getBucket(), this.getObjectName());
                    objectMetadata.drive = drive.getName();
                    drive.saveObjectMetadata((ObjectMetadata)drive2);
                }
                bl = virtualFileSystemOperation.commit();
                try {
                    if (bl) {
                        this.postObjectPreviousVersionDeleteAllCommit(objectMetadata.getVersion());
                        break block38;
                    } else {
                        try {
                            this.rollback(virtualFileSystemOperation);
                        }
                        catch (Exception exception) {
                            if (!bl2) {
                                throw new InternalCriticalException(exception, this.info());
                            }
                            logger.error((Throwable)exception, new String[]{this.info(), "---- not thrown ----"});
                        }
                    }
                    break block38;
                }
                finally {
                    this.bucketReadUnLock();
                }
                catch (InternalCriticalException internalCriticalException) {
                    try {
                        bl2 = true;
                        throw internalCriticalException;
                        catch (Exception exception) {
                            bl2 = true;
                            throw new InternalCriticalException(exception, this.info());
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (bl) {
                                this.postObjectPreviousVersionDeleteAllCommit(objectMetadata.getVersion());
                                throw throwable;
                            }
                            try {
                                this.rollback(virtualFileSystemOperation);
                                throw throwable;
                            }
                            catch (Exception exception) {
                                if (!bl2) {
                                    throw new InternalCriticalException(exception, this.info());
                                }
                                logger.error((Throwable)exception, new String[]{this.info(), "---- not thrown ----"});
                                throw throwable;
                            }
                        }
                        finally {
                            this.bucketReadUnLock();
                        }
                    }
                }
            }
            finally {
                this.objectWriteUnLock();
            }
        }
        if (!bl) return;
        try {
            this.getSchedulerService().enqueue((ServiceRequest)this.getVirtualFileSystemService().getApplicationContext().getBean(AfterDeleteObjectServiceRequest.class, new Object[]{virtualFileSystemOperation.getOperationCode(), objectMetadata, objectMetadata.getVersion()}));
            return;
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
        }
    }

    private void backupMetadata() {
        try {
            for (Drive drive : this.getDriver().getDrivesAll()) {
                String string = drive.getObjectMetadataDirPath(this.getBucket(), this.getObjectName());
                String string2 = drive.getBucketWorkDirPath(this.getBucket()) + File.separator + this.getObjectName();
                File file = new File(string);
                if (!file.exists()) continue;
                FileUtils.copyDirectory((File)file, (File)new File(string2));
            }
        }
        catch (IOException iOException) {
            throw new InternalCriticalException((Exception)iOException, this.info());
        }
    }

    private void postObjectPreviousVersionDeleteAllCommit(int n) {
        try {
            for (int i = 0; i < n; ++i) {
                for (Drive drive : this.getDriver().getDrivesAll()) {
                    ObjectPath objectPath = new ObjectPath(drive, this.getBucket(), this.getObjectName());
                    FileUtils.deleteQuietly((File)objectPath.dataFileVersionPath(i).toFile());
                }
            }
            for (Drive drive : this.getDriver().getDrivesAll()) {
                FileUtils.deleteQuietly((File)new File(drive.getBucketWorkDirPath(this.getBucket()) + File.separator + this.getObjectName()));
            }
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
        }
    }

    private VirtualFileSystemOperation deleteObjectPreviousVersions(int n) {
        return this.getJournalService().deleteObjectPreviousVersions(this.getBucket(), this.getObjectName(), n);
    }
}

