/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid1;

import io.odilon.error.OdilonObjectNotFoundException;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.scheduler.AfterDeleteObjectServiceRequest;
import io.odilon.scheduler.ServiceRequest;
import io.odilon.virtualFileSystem.ObjectPath;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.SimpleDrive;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.raid1.RAIDOneDriver;
import io.odilon.virtualFileSystem.raid1.RAIDOneTransactionObjectHandler;
import java.io.File;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FileUtils;

@ThreadSafe
public class RAIDOneDeleteObjectHandler
extends RAIDOneTransactionObjectHandler {
    private static Logger logger = Logger.getLogger((String)RAIDOneDeleteObjectHandler.class.getName());

    protected RAIDOneDeleteObjectHandler(RAIDOneDriver rAIDOneDriver, ServerBucket serverBucket, String string) {
        super(rAIDOneDriver, serverBucket, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void delete() {
        ObjectMetadata objectMetadata;
        int n;
        boolean bl;
        VirtualFileSystemOperation virtualFileSystemOperation;
        block29: {
            virtualFileSystemOperation = null;
            bl = false;
            boolean bl2 = false;
            n = -1;
            objectMetadata = null;
            this.objectWriteLock();
            try {
                this.bucketReadLock();
                this.checkExistsBucket();
                this.checkExistObject();
                objectMetadata = this.getDriver().getReadDrive(this.getBucket(), this.getObjectName()).getObjectMetadata(this.getBucket(), this.getObjectName());
                n = objectMetadata.getVersion();
                this.backupMetadata(objectMetadata, this.getBucket());
                virtualFileSystemOperation = this.deleteObject(n);
                for (Drive drive : this.getDriver().getDrivesAll()) {
                    ((SimpleDrive)drive).deleteObjectMetadata(this.getBucket(), this.getObjectName());
                }
                bl = virtualFileSystemOperation.commit();
                try {
                    if (!bl) {
                        try {
                            this.rollback(virtualFileSystemOperation);
                        }
                        catch (Exception exception) {
                            if (!bl2) {
                                throw new InternalCriticalException(exception, this.opInfo(virtualFileSystemOperation));
                            }
                            logger.error((Throwable)exception, new String[]{this.opInfo(virtualFileSystemOperation), "---- not thrown ----"});
                        }
                        break block29;
                    } else {
                        this.postObjectDeleteCommit(n);
                    }
                    break block29;
                }
                catch (Exception exception) {
                    logger.error((Throwable)exception, new String[]{this.opInfo(virtualFileSystemOperation), "---- not thrown ----"});
                    break block29;
                }
                finally {
                    this.bucketReadUnLock();
                }
                catch (OdilonObjectNotFoundException odilonObjectNotFoundException) {
                    try {
                        bl2 = true;
                        throw odilonObjectNotFoundException;
                        catch (InternalCriticalException internalCriticalException) {
                            bl2 = true;
                            throw internalCriticalException;
                        }
                        catch (Exception exception) {
                            bl2 = true;
                            throw new InternalCriticalException(exception, this.opInfo(virtualFileSystemOperation));
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (!bl) {
                                try {
                                    this.rollback(virtualFileSystemOperation);
                                    throw throwable;
                                }
                                catch (Exception exception) {
                                    if (!bl2) {
                                        throw new InternalCriticalException(exception, this.opInfo(virtualFileSystemOperation));
                                    }
                                    logger.error((Throwable)exception, new String[]{this.opInfo(virtualFileSystemOperation), "---- not thrown ----"});
                                    throw throwable;
                                }
                            }
                            this.postObjectDeleteCommit(n);
                            throw throwable;
                        }
                        catch (Exception exception) {
                            logger.error((Throwable)exception, new String[]{this.opInfo(virtualFileSystemOperation), "---- not thrown ----"});
                            throw throwable;
                        }
                        finally {
                            this.bucketReadUnLock();
                        }
                    }
                }
            }
            finally {
                this.objectWriteUnLock();
            }
        }
        if (!bl) return;
        this.onAfterCommit(virtualFileSystemOperation, objectMetadata, n);
    }

    private VirtualFileSystemOperation deleteObject(int n) {
        return this.deleteObject(this.getBucket(), this.getObjectName(), n);
    }

    private void postObjectDeleteCommit(int n) {
        try {
            Object object;
            for (int i = 0; i <= n; ++i) {
                for (Drive drive2 : this.getDriver().getDrivesAll()) {
                    object = new ObjectPath(drive2, this.getBucket(), this.getObjectName());
                    FileUtils.deleteQuietly((File)object.dataFileVersionPath(i).toFile());
                }
            }
            for (Drive drive : this.getDriver().getDrivesAll()) {
                Drive drive2;
                drive2 = new ObjectPath(drive, this.getBucket(), this.getObjectName());
                object = drive2.dataFilePath().toFile();
                FileUtils.deleteQuietly((File)object);
            }
            for (Drive drive : this.getDriver().getDrivesAll()) {
                FileUtils.deleteQuietly((File)new File(drive.getBucketWorkDirPath(this.getBucket()) + File.separator + this.getObjectName()));
            }
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
        }
    }

    private void backupMetadata(ObjectMetadata objectMetadata, ServerBucket serverBucket) {
        try {
            for (Drive drive : this.getDriver().getDrivesAll()) {
                String string = drive.getObjectMetadataDirPath(serverBucket, objectMetadata.objectName);
                String string2 = drive.getBucketWorkDirPath(serverBucket) + File.separator + objectMetadata.objectName;
                File file = new File(string);
                if (!file.exists()) continue;
                FileUtils.copyDirectory((File)file, (File)new File(string2));
            }
        }
        catch (IOException iOException) {
            throw new InternalCriticalException((Exception)iOException, this.objectInfo(objectMetadata));
        }
    }

    private void onAfterCommit(VirtualFileSystemOperation virtualFileSystemOperation, ObjectMetadata objectMetadata, int n) {
        try {
            this.getVirtualFileSystemService().getSchedulerService().enqueue((ServiceRequest)this.getVirtualFileSystemService().getApplicationContext().getBean(AfterDeleteObjectServiceRequest.class, new Object[]{virtualFileSystemOperation.getOperationCode(), objectMetadata, n}));
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
        }
    }
}

