/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.io.Files;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.OdilonServerInfo;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.DriveStatus;
import io.odilon.virtualFileSystem.model.IODriveSetup;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.raid1.RAIDOneDriveSync;
import io.odilon.virtualFileSystem.raid1.RAIDOneDriver;
import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class RAIDOneDriveSetup
implements IODriveSetup,
ApplicationContextAware {
    private static Logger logger = Logger.getLogger((String)RAIDOneDriveSetup.class.getName());
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    @JsonIgnore
    private AtomicLong checkOk = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong counter = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong copied = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong totalBytes = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong errors = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong cleaned = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong notAvailable = new AtomicLong(0L);
    @JsonIgnore
    private RAIDOneDriver driver;
    @JsonIgnore
    private ApplicationContext applicationContext;

    public RAIDOneDriveSetup(RAIDOneDriver rAIDOneDriver) {
        this.driver = rAIDOneDriver;
    }

    public boolean setup() {
        String string;
        startuplogger.info("This process is non blocking for RAID 1");
        startuplogger.info("It will start a background process that will replicate all objects in the new drive/s.");
        OdilonServerInfo odilonServerInfo = this.getDriver().getServerInfo();
        File file = ((Drive)this.getDriver().getDrivesEnabled().get(0)).getSysFile("key.enc");
        try {
            string = this.getDriver().getObjectMapper().writeValueAsString((Object)odilonServerInfo);
        }
        catch (JsonProcessingException jsonProcessingException) {
            startuplogger.error((Throwable)jsonProcessingException, new String[]{"---- not thrown ----"});
            return false;
        }
        try {
            startuplogger.info("1. Copying -> odilon.json");
            this.getDriver().getDrivesAll().forEach(drive -> {
                File file = drive.getSysFile("odilon.json");
                if (!(drive.getDriveInfo().getStatus() != DriveStatus.NOTSYNC || file != null && file.exists())) {
                    try {
                        drive.putSysFile("odilon.json", string);
                    }
                    catch (Exception exception) {
                        startuplogger.error((Throwable)exception, new String[]{"Drive -> " + drive.getName()});
                        throw new InternalCriticalException(exception, "Drive -> " + drive.getName());
                    }
                }
            });
            if (file != null && file.exists()) {
                startuplogger.info("2. Copying -> key.enc");
                this.getDriver().getDrivesAll().forEach(drive -> {
                    File file2 = drive.getSysFile("key.enc");
                    if (!(drive.getDriveInfo().getStatus() != DriveStatus.NOTSYNC || file2 != null && file2.exists())) {
                        try {
                            Files.copy((File)file, (File)file2);
                        }
                        catch (Exception exception) {
                            throw new InternalCriticalException(exception, "Drive -> " + drive.getName());
                        }
                    }
                });
            } else {
                startuplogger.info("2. Copying -> key.enc | file not exist. skipping");
            }
        }
        catch (Exception exception) {
            startuplogger.error((Throwable)exception, new String[]{"---- not thrown ----"});
            startuplogger.error(new String[]{"The process can not be completed due to errors"});
            return false;
        }
        this.createBuckets();
        if (this.errors.get() > 0L || this.notAvailable.get() > 0L) {
            startuplogger.error(new String[]{"The process can not be completed due to errors"});
            return false;
        }
        startuplogger.info("4. Starting Async process -> " + RAIDOneDriveSync.class.getName());
        RAIDOneDriveSync rAIDOneDriveSync = (RAIDOneDriveSync)this.getApplicationContext().getBean(RAIDOneDriveSync.class, new Object[]{this.getDriver()});
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        startuplogger.info("done");
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    private RAIDOneDriver getDriver() {
        return this.driver;
    }

    private void createBuckets() {
        List list = this.getDriver().getVirtualFileSystemService().listAllBuckets();
        startuplogger.info("3. Creating " + String.valueOf(list.size()) + " Buckets");
        for (ServerBucket serverBucket : list) {
            for (Drive drive : this.getDriver().getDrivesAll()) {
                if (drive.getDriveInfo().getStatus() != DriveStatus.NOTSYNC) continue;
                try {
                    if (drive.existsBucketById(serverBucket.getId())) continue;
                    drive.createBucket(serverBucket.getBucketMetadata());
                }
                catch (Exception exception) {
                    this.errors.getAndIncrement();
                    logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                    return;
                }
            }
        }
    }
}

