/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.model.ServiceStatus;
import io.odilon.model.list.DataList;
import io.odilon.model.list.Item;
import io.odilon.virtualFileSystem.DriveInfo;
import io.odilon.virtualFileSystem.ObjectPath;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.DriveStatus;
import io.odilon.virtualFileSystem.model.LockService;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.SimpleDrive;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import io.odilon.virtualFileSystem.raid1.RAIDOneDriver;
import jakarta.annotation.PostConstruct;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class RAIDOneDriveSync
implements Runnable {
    private static Logger logger = Logger.getLogger((String)RAIDOneDriveSync.class.getName());
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    @JsonIgnore
    private AtomicBoolean bucketsCreated = new AtomicBoolean(false);
    @JsonIgnore
    private AtomicLong checkOk = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong counter = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong copied = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong totalBytes = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong errors = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong cleaned = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong notAvailable = new AtomicLong(0L);
    @JsonIgnore
    private RAIDOneDriver driver;
    @JsonIgnore
    private Thread thread;
    @JsonIgnore
    private AtomicBoolean done;
    @JsonIgnore
    private LockService vfsLockService;

    public RAIDOneDriveSync(RAIDOneDriver rAIDOneDriver) {
        this.driver = rAIDOneDriver;
        this.vfsLockService = this.driver.getLockService();
    }

    public AtomicBoolean isDone() {
        return this.done;
    }

    public AtomicLong getErrors() {
        return this.errors;
    }

    public AtomicLong getNnotAvailable() {
        return this.notAvailable;
    }

    @PostConstruct
    public void onInitialize() {
        this.thread = new Thread((Runnable)this);
        this.thread.setDaemon(true);
        this.thread.setName(this.getClass().getSimpleName());
        this.thread.start();
    }

    @Override
    public void run() {
        logger.info("Starting -> " + this.getClass().getSimpleName());
        long l = System.currentTimeMillis();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (this.getDriver().getVirtualFileSystemService().getStatus() != ServiceStatus.RUNNING) {
            startuplogger.info("waiting for " + VirtualFileSystemService.class.getSimpleName() + " to startup (" + String.valueOf(Double.valueOf(System.currentTimeMillis() - l) / Double.valueOf(1000.0)) + " secs)");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.copy();
        if (this.errors.get() > 0L || this.notAvailable.get() > 0L) {
            startuplogger.error(new String[]{"The process can not be completed due to errors"});
            return;
        }
        this.updateDrives();
        this.done = new AtomicBoolean(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy() {
        long l = System.currentTimeMillis();
        int n = Double.valueOf(Double.valueOf(Runtime.getRuntime().availableProcessors() - 1) / 2.0).intValue() + 1;
        ExecutorService executorService = null;
        try {
            this.errors = new AtomicLong(0L);
            executorService = Executors.newFixedThreadPool(n);
            for (ServerBucket serverBucket : this.getDriver().getVirtualFileSystemService().listAllBuckets()) {
                Integer n2 = 1000;
                Long l2 = 0L;
                String string = null;
                boolean bl = false;
                Drive drive = (Drive)this.getDriver().getDrivesEnabled().get(0);
                while (!bl) {
                    DataList dataList = this.driver.getVirtualFileSystemService().listObjects(serverBucket.getName(), Optional.of(l2), Optional.ofNullable(n2), Optional.empty(), Optional.ofNullable(string));
                    if (string == null) {
                        string = dataList.getAgentId();
                    }
                    ArrayList<Callable<Object>> arrayList = new ArrayList<Callable<Object>>(dataList.getList().size());
                    for (Item item : dataList.getList()) {
                        arrayList.add(() -> {
                            block28: {
                                try {
                                    this.counter.getAndIncrement();
                                    if ((this.counter.get() + 1L) % 50L == 0L) {
                                        logger.debug("scanned (copy) so far -> " + String.valueOf(this.counter.get()));
                                    }
                                    if (item.isOk()) {
                                        for (Drive drive2 : this.getDriver().getDrivesAll()) {
                                            if (drive2.getDriveInfo().getStatus() != DriveStatus.NOTSYNC) continue;
                                            try {
                                                this.getLockService().getObjectLock(((ObjectMetadata)item.getObject()).bucketId, ((ObjectMetadata)item.getObject()).objectName).writeLock().lock();
                                                try {
                                                    Object object;
                                                    File file;
                                                    Object object2;
                                                    this.getLockService().getBucketLock(serverBucket).readLock().lock();
                                                    File file2 = drive2.getObjectMetadataFile(serverBucket, ((ObjectMetadata)item.getObject()).objectName);
                                                    if (!file2.exists()) {
                                                        object2 = new ObjectPath(drive2, serverBucket, ((ObjectMetadata)item.getObject()).getObjectName());
                                                        file = object2.dataFilePath().toFile();
                                                        object = new BufferedInputStream(new FileInputStream(file));
                                                        try {
                                                            String string = object2.dataFilePath().toString();
                                                            byte[] byArray = new byte[8192];
                                                            try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string), 8192);){
                                                                int n;
                                                                while ((n = ((InputStream)object).read(byArray, 0, byArray.length)) >= 0) {
                                                                    bufferedOutputStream.write(byArray, 0, n);
                                                                }
                                                                this.totalBytes.addAndGet(file.length());
                                                            }
                                                        }
                                                        finally {
                                                            ((InputStream)object).close();
                                                        }
                                                        object = (ObjectMetadata)item.getObject();
                                                        ((ObjectMetadata)object).drive = drive2.getName();
                                                        drive2.saveObjectMetadata((ObjectMetadata)object);
                                                        this.copied.getAndIncrement();
                                                    }
                                                    if (!this.getDriver().getVirtualFileSystemService().getServerSettings().isVersionControl()) continue;
                                                    for (int i = 0; i < ((ObjectMetadata)item.getObject()).version; ++i) {
                                                        object2 = drive.getObjectMetadataVersionFile(serverBucket, ((ObjectMetadata)item.getObject()).objectName, i);
                                                        if (((File)object2).exists()) {
                                                            drive2.putObjectMetadataVersionFile(serverBucket, ((ObjectMetadata)item.getObject()).objectName, i, (File)object2);
                                                        }
                                                        if (!((File)(object = (file = new ObjectPath(drive, ((ObjectMetadata)item.getObject()).bucketId, ((ObjectMetadata)item.getObject()).objectName)).dataFileVersionPath(i).toFile())).exists()) continue;
                                                        ((SimpleDrive)drive2).putObjectDataVersionFile(((ObjectMetadata)item.getObject()).bucketId, ((ObjectMetadata)item.getObject()).objectName, i, (File)object);
                                                    }
                                                }
                                                catch (Exception exception) {
                                                    logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                                                    this.errors.getAndIncrement();
                                                }
                                                finally {
                                                    this.getLockService().getBucketLock(serverBucket).readLock().unlock();
                                                }
                                            }
                                            finally {
                                                this.getLockService().getObjectLock(((ObjectMetadata)item.getObject()).bucketId, ((ObjectMetadata)item.getObject()).objectName).writeLock().unlock();
                                            }
                                        }
                                        break block28;
                                    }
                                    this.notAvailable.getAndIncrement();
                                }
                                catch (Exception exception) {
                                    logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                                    this.errors.getAndIncrement();
                                }
                            }
                            return null;
                        });
                    }
                    try {
                        executorService.invokeAll(arrayList, 10L, TimeUnit.MINUTES);
                    }
                    catch (InterruptedException interruptedException) {
                        logger.error((Throwable)interruptedException, new String[]{"---- not thrown ----"});
                    }
                    l2 = l2 + Long.valueOf(Integer.valueOf(dataList.getList().size()).longValue());
                    bl = dataList.isEOD() || this.errors.get() > 0L || this.notAvailable.get() > 0L;
                }
            }
            try {
                executorService.shutdown();
                executorService.awaitTermination(15L, TimeUnit.MINUTES);
                logger.debug("scanned (copy) so far -> " + String.valueOf(this.counter.get()));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            startuplogger.info("---------------------------------");
            startuplogger.info(this.getClass().getSimpleName() + " Process completed");
            startuplogger.debug("Threads: " + String.valueOf(n));
            startuplogger.info("Total objects scanned: " + String.valueOf(this.counter.get()));
            startuplogger.info("Total objects  copied: " + String.valueOf(this.copied.get()));
            double d = Double.valueOf(this.totalBytes.get()) / 1.073741824E9;
            startuplogger.info("Total size: " + String.format("%14.4f", d).trim() + " GB");
            if (this.errors.get() > 0L) {
                startuplogger.info("Errors: " + String.valueOf(this.errors.get()));
            }
            if (this.notAvailable.get() > 0L) {
                startuplogger.info("Not available: " + String.valueOf(this.notAvailable.get()));
            }
            startuplogger.info("Duration: " + String.valueOf(Double.valueOf(System.currentTimeMillis() - l) / Double.valueOf(1000.0)) + " secs");
            startuplogger.info("---------------------------------");
            throw throwable;
        }
        startuplogger.info("---------------------------------");
        startuplogger.info(this.getClass().getSimpleName() + " Process completed");
        startuplogger.debug("Threads: " + String.valueOf(n));
        startuplogger.info("Total objects scanned: " + String.valueOf(this.counter.get()));
        startuplogger.info("Total objects  copied: " + String.valueOf(this.copied.get()));
        double d = Double.valueOf(this.totalBytes.get()) / 1.073741824E9;
        startuplogger.info("Total size: " + String.format("%14.4f", d).trim() + " GB");
        if (this.errors.get() > 0L) {
            startuplogger.info("Errors: " + String.valueOf(this.errors.get()));
        }
        if (this.notAvailable.get() > 0L) {
            startuplogger.info("Not available: " + String.valueOf(this.notAvailable.get()));
        }
        startuplogger.info("Duration: " + String.valueOf(Double.valueOf(System.currentTimeMillis() - l) / Double.valueOf(1000.0)) + " secs");
        startuplogger.info("---------------------------------");
    }

    protected RAIDOneDriver getDriver() {
        return this.driver;
    }

    protected LockService getLockService() {
        return this.vfsLockService;
    }

    private void updateDrives() {
        for (Drive drive : this.getDriver().getDrivesAll()) {
            if (drive.getDriveInfo().getStatus() != DriveStatus.NOTSYNC) continue;
            DriveInfo driveInfo = drive.getDriveInfo();
            driveInfo.setStatus(DriveStatus.ENABLED);
            driveInfo.setOrder(drive.getConfigOrder());
            drive.setDriveInfo(driveInfo);
            this.getDriver().getVirtualFileSystemService().updateDriveStatus(drive);
            startuplogger.debug("drive synced -> " + drive.getRootDirPath());
        }
    }
}

