/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid1;

import io.odilon.cache.CacheEvent;
import io.odilon.error.OdilonObjectNotFoundException;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.model.RedundancyLevel;
import io.odilon.model.list.DataList;
import io.odilon.model.list.Item;
import io.odilon.query.BucketIteratorService;
import io.odilon.scheduler.DeleteBucketObjectPreviousVersionServiceRequest;
import io.odilon.scheduler.ServiceRequest;
import io.odilon.util.Check;
import io.odilon.virtualFileSystem.Action;
import io.odilon.virtualFileSystem.BaseIODriver;
import io.odilon.virtualFileSystem.ObjectPath;
import io.odilon.virtualFileSystem.OdilonObject;
import io.odilon.virtualFileSystem.OdilonVirtualFileSystemOperation;
import io.odilon.virtualFileSystem.model.BucketIterator;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.LockService;
import io.odilon.virtualFileSystem.model.OperationCode;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.SimpleDrive;
import io.odilon.virtualFileSystem.model.VirtualFileSystemObject;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import io.odilon.virtualFileSystem.raid1.RAIDOneBucketIterator;
import io.odilon.virtualFileSystem.raid1.RAIDOneCreateObjectHandler;
import io.odilon.virtualFileSystem.raid1.RAIDOneDeleteObjectAllPreviousVersionsHandler;
import io.odilon.virtualFileSystem.raid1.RAIDOneDeleteObjectHandler;
import io.odilon.virtualFileSystem.raid1.RAIDOneDriveSetup;
import io.odilon.virtualFileSystem.raid1.RAIDOneRollbackCreateHandler;
import io.odilon.virtualFileSystem.raid1.RAIDOneRollbackDeleteHandler;
import io.odilon.virtualFileSystem.raid1.RAIDOneRollbackUpdateHandler;
import io.odilon.virtualFileSystem.raid1.RAIDOneUpdateObjectHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@ThreadSafe
public class RAIDOneDriver
extends BaseIODriver {
    private static Logger logger = Logger.getLogger((String)RAIDOneDriver.class.getName());

    public RAIDOneDriver(VirtualFileSystemService virtualFileSystemService, LockService lockService) {
        super(virtualFileSystemService, lockService);
    }

    public boolean hasVersions(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        this.checkIsAccesible(serverBucket);
        return !this.getObjectMetadataVersionAll(serverBucket, string).isEmpty();
    }

    public void wipeAllPreviousVersions() {
        this.getSchedulerService().enqueue((ServiceRequest)this.getVirtualFileSystemService().getApplicationContext().getBean(DeleteBucketObjectPreviousVersionServiceRequest.class));
    }

    public void deleteBucketAllPreviousVersions(ServerBucket serverBucket) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        this.checkIsAccesible(serverBucket);
        this.getSchedulerService().enqueue((ServiceRequest)this.getVirtualFileSystemService().getApplicationContext().getBean(DeleteBucketObjectPreviousVersionServiceRequest.class, new Object[]{serverBucket.getName(), serverBucket.getId()}));
    }

    public ObjectMetadata restorePreviousVersion(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        this.checkIsAccesible(serverBucket);
        RAIDOneUpdateObjectHandler rAIDOneUpdateObjectHandler = new RAIDOneUpdateObjectHandler(this);
        return rAIDOneUpdateObjectHandler.restorePreviousVersion(serverBucket, string);
    }

    /*
     * Exception decompiling
     */
    public InputStream getObjectVersionInputStream(ServerBucket var1_1, String var2_2, int var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void deleteObjectAllPreviousVersions(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireNonNullArgument((Object)string, (String)("objectName is null or empty | b:" + this.objectInfo(serverBucket)));
        this.checkIsAccesible(serverBucket);
        RAIDOneDeleteObjectAllPreviousVersionsHandler rAIDOneDeleteObjectAllPreviousVersionsHandler = new RAIDOneDeleteObjectAllPreviousVersionsHandler(this, serverBucket, string);
        rAIDOneDeleteObjectAllPreviousVersionsHandler.delete();
    }

    public void putObject(ServerBucket serverBucket, String string, InputStream inputStream, String string2, String string3, Optional<List<String>> optional) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireNonNullStringArgument((String)string, (String)("objectName can not be null | b:" + serverBucket.getId()));
        Check.requireNonNullStringArgument((String)string2, (String)("fileName is null | b: " + serverBucket.getId() + " o:" + string));
        Check.requireNonNullArgument((Object)inputStream, (String)("InpuStream can not null -> b:" + serverBucket.getId() + " | o:" + string));
        this.checkIsAccesible(serverBucket);
        if (this.exists(serverBucket, string)) {
            RAIDOneUpdateObjectHandler rAIDOneUpdateObjectHandler = new RAIDOneUpdateObjectHandler(this);
            rAIDOneUpdateObjectHandler.update(serverBucket, string, inputStream, string2, string3, optional);
            this.getVirtualFileSystemService().getSystemMonitorService().getUpdateObjectCounter().inc();
        } else {
            RAIDOneCreateObjectHandler rAIDOneCreateObjectHandler = new RAIDOneCreateObjectHandler(this, serverBucket, string);
            rAIDOneCreateObjectHandler.create(inputStream, string2, string3, optional);
            this.getVirtualFileSystemService().getSystemMonitorService().getCreateObjectCounter().inc();
        }
    }

    public void delete(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireNonNullArgument((Object)string, (String)("objectName is null or empty | b:" + serverBucket.getId()));
        this.checkIsAccesible(serverBucket);
        RAIDOneDeleteObjectHandler rAIDOneDeleteObjectHandler = new RAIDOneDeleteObjectHandler(this, serverBucket, string);
        rAIDOneDeleteObjectHandler.delete();
    }

    public void postObjectDeleteTransaction(ObjectMetadata objectMetadata, int n) {
    }

    public void postObjectPreviousVersionDeleteAllTransaction(ObjectMetadata objectMetadata, int n) {
    }

    public void putObjectMetadata(ObjectMetadata objectMetadata) {
        Check.requireNonNullArgument((Object)objectMetadata, (String)"meta is null");
        RAIDOneUpdateObjectHandler rAIDOneUpdateObjectHandler = new RAIDOneUpdateObjectHandler(this);
        rAIDOneUpdateObjectHandler.updateObjectMetadata(objectMetadata);
        this.getVirtualFileSystemService().getSystemMonitorService().getUpdateObjectCounter().inc();
    }

    public boolean setUpDrives() {
        logger.debug("Starting non blocking process to set up drives");
        return ((RAIDOneDriveSetup)this.getApplicationContext().getBean(RAIDOneDriveSetup.class, new Object[]{this})).setup();
    }

    public boolean isEmpty(ServerBucket serverBucket) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        this.bucketReadLock(serverBucket);
        try {
            if (!this.existsCacheBucket(serverBucket.getName())) {
                throw new IllegalArgumentException("bucket does not exist -> " + this.objectInfo(serverBucket));
            }
            boolean bl = this.getReadDrive(serverBucket).isEmpty(serverBucket);
            return bl;
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, this.objectInfo(serverBucket));
        }
        finally {
            this.bucketReadUnLock(serverBucket);
        }
    }

    /*
     * Loose catch block
     */
    public List<ObjectMetadata> getObjectMetadataVersionAll(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireNonNullStringArgument((String)string, (String)("objectName is null or empty | " + this.objectInfo(serverBucket)));
        this.checkIsAccesible(serverBucket);
        ArrayList<ObjectMetadata> arrayList = new ArrayList<ObjectMetadata>();
        Drive drive = null;
        this.objectReadLock(serverBucket, string);
        try {
            ArrayList<ObjectMetadata> arrayList2;
            this.bucketReadLock(serverBucket);
            try {
                if (!this.existsCacheBucket(serverBucket)) {
                    throw new IllegalArgumentException("bucket does not exist -> " + this.objectInfo(serverBucket));
                }
                drive = this.getReadDrive(serverBucket, string);
                ObjectMetadata objectMetadata = this.getDriverObjectMetadataInternal(serverBucket, string, true);
                if (objectMetadata == null || !objectMetadata.isAccesible()) {
                    throw new OdilonObjectNotFoundException(this.objectInfo(serverBucket, string));
                }
                objectMetadata.setBucketName(serverBucket.getName());
                if (objectMetadata.getVersion() == 0) {
                    ArrayList<ObjectMetadata> arrayList3 = arrayList;
                    return arrayList3;
                }
                for (int i = 0; i < objectMetadata.getVersion(); ++i) {
                    ObjectMetadata objectMetadata2 = drive.getObjectMetadataVersion(serverBucket, string, i);
                    if (objectMetadata2 == null) continue;
                    objectMetadata2.setBucketName(serverBucket.getName());
                    arrayList.add(objectMetadata2);
                }
                arrayList2 = arrayList;
            }
            catch (Exception exception) {
                throw new InternalCriticalException(exception, this.objectInfo(serverBucket, string));
            }
            finally {
                this.bucketReadUnLock(serverBucket);
            }
            return arrayList2;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.objectReadUnLock(serverBucket, string);
        }
    }

    public ObjectMetadata getObjectMetadata(ServerBucket serverBucket, String string) {
        return this.getOM(serverBucket, string, Optional.empty(), true);
    }

    public ObjectMetadata getObjectMetadataVersion(ServerBucket serverBucket, String string, int n) {
        return this.getOM(serverBucket, string, Optional.of(n), true);
    }

    /*
     * Loose catch block
     */
    public VirtualFileSystemObject getObject(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireTrue((boolean)serverBucket.isAccesible(), (String)("bucket is not Accesible (ie. enabled or archived) b:" + serverBucket.getId()));
        Check.requireNonNullArgument((Object)string, (String)("objectName can not be null | b:" + serverBucket.getId()));
        this.objectReadLock(serverBucket, string);
        try {
            this.bucketReadLock(serverBucket);
            try {
                if (!this.existsCacheBucket(serverBucket)) {
                    throw new IllegalArgumentException("bucket does not exist -> " + this.objectInfo(serverBucket));
                }
                if (!this.exists(serverBucket, string)) {
                    throw new IllegalArgumentException("object does not exists for ->  b:" + serverBucket.getId() + " | o:" + string + " | " + this.getClass().getSimpleName());
                }
                ObjectMetadata objectMetadata = this.getDriverObjectMetadataInternal(serverBucket, string, true);
                if (objectMetadata == null || !objectMetadata.isAccesible()) {
                    throw new OdilonObjectNotFoundException(this.objectInfo(serverBucket, string));
                }
                OdilonObject odilonObject = new OdilonObject(serverBucket, string, this.getVirtualFileSystemService());
                return odilonObject;
            }
            catch (Exception exception) {
                throw new InternalCriticalException(exception, this.objectInfo(serverBucket, string));
            }
            finally {
                this.bucketReadUnLock(serverBucket);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.objectReadUnLock(serverBucket, string);
        }
    }

    /*
     * Loose catch block
     */
    public boolean exists(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireNonNullStringArgument((String)string, (String)("objectName is null or empty | b:" + serverBucket.getId()));
        Check.requireTrue((boolean)serverBucket.isAccesible(), (String)("bucket is not Accesible (ie. enabled or archived) b:" + serverBucket.getId()));
        this.objectReadLock(serverBucket, string);
        try {
            this.bucketReadLock(serverBucket);
            try {
                if (!this.existsCacheBucket(serverBucket.getName())) {
                    throw new IllegalArgumentException("bucket does not exist -> " + this.objectInfo(serverBucket));
                }
                boolean bl = this.getReadDrive(serverBucket, string).existsObjectMetadata(serverBucket, string);
                return bl;
            }
            catch (Exception exception) {
                throw new InternalCriticalException(exception, this.objectInfo(serverBucket, string));
            }
            finally {
                this.bucketReadUnLock(serverBucket);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.objectReadUnLock(serverBucket, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataList<Item<ObjectMetadata>> listObjects(ServerBucket serverBucket, Optional<Long> optional, Optional<Integer> optional2, Optional<String> optional3, Optional<String> optional4) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        BucketIterator bucketIterator = null;
        BucketIteratorService bucketIteratorService = this.getVirtualFileSystemService().getBucketIteratorService();
        try {
            DataList dataList;
            Path path;
            if (optional4.isPresent()) {
                bucketIterator = bucketIteratorService.get(optional4.get());
            }
            if (bucketIterator == null) {
                bucketIterator = new RAIDOneBucketIterator(this, serverBucket, optional, optional3);
                bucketIteratorService.register(bucketIterator);
            }
            ArrayList<DataList> arrayList = new ArrayList<DataList>();
            int n = optional2.orElseGet(() -> 60);
            int n2 = 0;
            while (bucketIterator.hasNext() && n2++ < n) {
                try {
                    path = bucketIterator.next();
                    String string = path.toFile().getName();
                    dataList = new Item((Serializable)this.getObjectMetadata(serverBucket, string));
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                    logger.error((Throwable)illegalMonitorStateException, new String[]{"---- not thrown ----"});
                    dataList = new Item((Exception)illegalMonitorStateException);
                }
                catch (Exception exception) {
                    logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                    dataList = new Item(exception);
                }
                arrayList.add(dataList);
            }
            dataList = new DataList(arrayList);
            if (!bucketIterator.hasNext()) {
                dataList.setEOD(true);
            }
            dataList.setOffset(bucketIterator.getOffset().longValue());
            dataList.setPageSize((long)n);
            dataList.setAgentId(bucketIterator.getAgentId());
            path = dataList;
            return path;
        }
        finally {
            if (bucketIterator != null && !bucketIterator.hasNext()) {
                this.getVirtualFileSystemService().getBucketIteratorService().remove(bucketIterator.getAgentId());
            }
        }
    }

    /*
     * Loose catch block
     */
    public InputStream getInputStream(ServerBucket serverBucket, String string) throws IOException {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireTrue((boolean)serverBucket.isAccesible(), (String)("bucket is not Accesible (ie. enabled or archived) b:" + serverBucket.getId()));
        Check.requireNonNullArgument((Object)string, (String)("objectName is null or empty | b:" + serverBucket.getId()));
        this.objectReadLock(serverBucket, string);
        try {
            this.bucketReadLock(serverBucket);
            try {
                if (!this.existsCacheBucket(serverBucket.getName())) {
                    throw new IllegalArgumentException("bucket does not exist -> " + this.objectInfo(serverBucket));
                }
                Drive drive = this.getReadDrive(serverBucket, string);
                ObjectMetadata objectMetadata = this.getDriverObjectMetadataInternal(serverBucket, string, true);
                InputStream inputStream = this.getInputStreamFromSelectedDrive(drive, serverBucket.getId(), string);
                if (objectMetadata.isEncrypt()) {
                    InputStream inputStream2 = this.getVirtualFileSystemService().getEncryptionService().decryptStream(inputStream);
                    return inputStream2;
                }
                InputStream inputStream3 = inputStream;
                return inputStream3;
            }
            catch (Exception exception) {
                throw new InternalCriticalException(exception, this.objectInfo(serverBucket, string));
            }
            finally {
                this.bucketReadUnLock(serverBucket);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.objectReadUnLock(serverBucket, string);
        }
    }

    /*
     * Exception decompiling
     */
    public boolean checkIntegrity(ServerBucket var1_1, String var2_2, boolean var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 20[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public RedundancyLevel getRedundancyLevel() {
        return RedundancyLevel.RAID_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void rollback(VirtualFileSystemOperation virtualFileSystemOperation, Object object, boolean bl) {
        block32: {
            block29: {
                if (virtualFileSystemOperation.getOperationCode() == OperationCode.CREATE_OBJECT) {
                    RAIDOneRollbackCreateHandler rAIDOneRollbackCreateHandler = new RAIDOneRollbackCreateHandler(this, virtualFileSystemOperation, bl);
                    rAIDOneRollbackCreateHandler.rollback();
                    return;
                }
                if (virtualFileSystemOperation.getOperationCode() == OperationCode.UPDATE_OBJECT) {
                    RAIDOneRollbackUpdateHandler rAIDOneRollbackUpdateHandler = new RAIDOneRollbackUpdateHandler(this, virtualFileSystemOperation, bl);
                    rAIDOneRollbackUpdateHandler.rollback();
                    return;
                }
                if (virtualFileSystemOperation.getOperationCode() == OperationCode.DELETE_OBJECT) {
                    RAIDOneRollbackDeleteHandler rAIDOneRollbackDeleteHandler = new RAIDOneRollbackDeleteHandler(this, virtualFileSystemOperation, bl);
                    rAIDOneRollbackDeleteHandler.rollback();
                    return;
                }
                if (virtualFileSystemOperation.getOperationCode() == OperationCode.DELETE_OBJECT_PREVIOUS_VERSIONS) {
                    RAIDOneRollbackDeleteHandler rAIDOneRollbackDeleteHandler = new RAIDOneRollbackDeleteHandler(this, virtualFileSystemOperation, bl);
                    rAIDOneRollbackDeleteHandler.rollback();
                    return;
                }
                if (virtualFileSystemOperation.getOperationCode() == OperationCode.UPDATE_OBJECT_METADATA) {
                    RAIDOneRollbackUpdateHandler rAIDOneRollbackUpdateHandler = new RAIDOneRollbackUpdateHandler(this, virtualFileSystemOperation, bl);
                    rAIDOneRollbackUpdateHandler.rollback();
                    return;
                }
                boolean bl2 = false;
                try {
                    if (virtualFileSystemOperation.getOperationCode() == OperationCode.CREATE_BUCKET) {
                        bl2 = this.generalRollbackJournal(virtualFileSystemOperation);
                    } else if (virtualFileSystemOperation.getOperationCode() == OperationCode.DELETE_BUCKET) {
                        bl2 = this.generalRollbackJournal(virtualFileSystemOperation);
                    } else if (virtualFileSystemOperation.getOperationCode() == OperationCode.UPDATE_BUCKET) {
                        bl2 = this.generalRollbackJournal(virtualFileSystemOperation);
                    }
                    if (virtualFileSystemOperation.getOperationCode() == OperationCode.CREATE_SERVER_MASTERKEY) {
                        bl2 = this.generalRollbackJournal(virtualFileSystemOperation);
                    } else if (virtualFileSystemOperation.getOperationCode() == OperationCode.CREATE_SERVER_METADATA) {
                        bl2 = this.generalRollbackJournal(virtualFileSystemOperation);
                    } else if (virtualFileSystemOperation.getOperationCode() == OperationCode.UPDATE_SERVER_METADATA) {
                        bl2 = this.generalRollbackJournal(virtualFileSystemOperation);
                    }
                    if (!bl2 && !bl) break block29;
                }
                catch (InternalCriticalException internalCriticalException) {
                    block30: {
                        if (!bl) {
                            throw internalCriticalException;
                        }
                        logger.error(new String[]{this.opInfo(virtualFileSystemOperation), "---- not thrown ----"});
                        if (!bl2 && !bl) break block30;
                        virtualFileSystemOperation.cancel();
                    }
                    if (this.getServerSettings().isRecovery()) {
                        logger.error(new String[]{"---------------------------------------------------------------"});
                        logger.error(new String[]{"Cancelling failed operation -> " + this.opInfo(virtualFileSystemOperation)});
                        logger.error(new String[]{"---------------------------------------------------------------"});
                        virtualFileSystemOperation.cancel();
                    }
                }
                catch (Exception exception) {
                    block31: {
                        if (!bl) {
                            throw new InternalCriticalException(exception, this.opInfo(virtualFileSystemOperation));
                        }
                        logger.error(new String[]{this.opInfo(virtualFileSystemOperation), "---- not thrown ----"});
                        if (!bl2 && !bl) break block31;
                        {
                            catch (Throwable throwable) {
                                if (bl2 || bl) {
                                    virtualFileSystemOperation.cancel();
                                } else if (this.getServerSettings().isRecovery()) {
                                    logger.error(new String[]{"---------------------------------------------------------------"});
                                    logger.error(new String[]{"Cancelling failed operation -> " + this.opInfo(virtualFileSystemOperation)});
                                    logger.error(new String[]{"---------------------------------------------------------------"});
                                    virtualFileSystemOperation.cancel();
                                }
                                throw throwable;
                            }
                        }
                        virtualFileSystemOperation.cancel();
                    }
                    if (this.getServerSettings().isRecovery()) {
                        logger.error(new String[]{"---------------------------------------------------------------"});
                        logger.error(new String[]{"Cancelling failed operation -> " + this.opInfo(virtualFileSystemOperation)});
                        logger.error(new String[]{"---------------------------------------------------------------"});
                        virtualFileSystemOperation.cancel();
                    }
                }
                virtualFileSystemOperation.cancel();
                break block32;
            }
            if (this.getServerSettings().isRecovery()) {
                logger.error(new String[]{"---------------------------------------------------------------"});
                logger.error(new String[]{"Cancelling failed operation -> " + this.opInfo(virtualFileSystemOperation)});
                logger.error(new String[]{"---------------------------------------------------------------"});
                virtualFileSystemOperation.cancel();
            }
        }
    }

    public void syncObject(ObjectMetadata objectMetadata) {
        Check.requireNonNullArgument((Object)objectMetadata, (String)"meta is null");
        logger.error(new String[]{"not done", "---- not thrown ----"});
    }

    protected Drive getObjectMetadataReadDrive(ServerBucket serverBucket, String string) {
        return this.getReadDrive(serverBucket, string);
    }

    protected Drive getReadDrive(ServerBucket serverBucket, String string) {
        return (Drive)this.getDrivesEnabled().get(Double.valueOf(Math.abs(Math.random() * 1000.0)).intValue() % this.getDrivesEnabled().size());
    }

    protected Drive getReadDrive(ServerBucket serverBucket) {
        return (Drive)this.getDrivesEnabled().get(Double.valueOf(Math.abs(Math.random() * 1000.0)).intValue() % this.getDrivesEnabled().size());
    }

    protected InputStream getInputStreamFromSelectedDrive(Drive drive, Long l, String string) throws IOException {
        return Files.newInputStream(Paths.get(drive.getRootDirPath() + File.separator + l.toString() + File.separator + string, new String[0]), new OpenOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fix(ServerBucket serverBucket, String string, ObjectMetadata objectMetadata, Boolean[] booleanArray, Drive drive) {
        boolean bl = true;
        this.objectWriteLock(serverBucket, string);
        try {
            this.bucketReadLock(serverBucket);
            try {
                SimpleDrive simpleDrive;
                ObjectMetadata objectMetadata2 = drive.getObjectMetadata(serverBucket, string);
                if (!objectMetadata2.getLastModified().equals(objectMetadata.getLastModified())) {
                    boolean bl2 = true;
                    return bl2;
                }
                booleanArray[0] = true;
                booleanArray[1] = false;
                int n = booleanArray.length;
                for (int i = 0; i < n; ++i) {
                    if (booleanArray[i].booleanValue()) continue;
                    simpleDrive = (SimpleDrive)this.getDrivesEnabled().get(i);
                    try (InputStream inputStream = null;){
                        if (drive.equals((Object)simpleDrive)) continue;
                        ObjectPath objectPath = new ObjectPath(drive, serverBucket, string);
                        inputStream = Files.newInputStream(objectPath.dataFilePath(), new OpenOption[0]);
                        simpleDrive.putObjectStream(serverBucket.getId(), string, inputStream);
                        objectMetadata.setDrive(simpleDrive.getName());
                        simpleDrive.saveObjectMetadata(objectMetadata);
                        logger.debug("Fixed -> d: " + simpleDrive.getName() + " " + this.objectInfo(serverBucket, string));
                        continue;
                    }
                }
                OdilonVirtualFileSystemOperation odilonVirtualFileSystemOperation = new OdilonVirtualFileSystemOperation();
                odilonVirtualFileSystemOperation.setOperationCode(OperationCode.INTEGRITY_CHECK);
                odilonVirtualFileSystemOperation.setBucketId(serverBucket.getId());
                odilonVirtualFileSystemOperation.setObjectName(string);
                simpleDrive = new CacheEvent((VirtualFileSystemOperation)odilonVirtualFileSystemOperation, Action.COMMIT);
                this.getVirtualFileSystemService().getApplicationEventPublisher().publishEvent((ApplicationEvent)simpleDrive);
            }
            catch (Exception exception) {
                logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                bl = false;
            }
            finally {
                this.bucketReadUnLock(serverBucket);
            }
        }
        finally {
            this.objectWriteUnLock(serverBucket, string);
        }
        return bl;
    }

    /*
     * Loose catch block
     */
    private ObjectMetadata getOM(ServerBucket serverBucket, String string, Optional<Integer> optional, boolean bl) {
        Drive drive = null;
        this.objectReadLock(serverBucket, string);
        try {
            this.bucketReadLock(serverBucket);
            try {
                if (!this.existsCacheBucket(serverBucket.getName())) {
                    throw new IllegalArgumentException("bucket does not exist -> " + this.objectInfo(serverBucket));
                }
                drive = this.getReadDrive(serverBucket, string);
                if (!this.exists(serverBucket, string)) {
                    throw new IllegalArgumentException("Object does not exists -> " + this.objectInfo(serverBucket, string));
                }
                ObjectMetadata objectMetadata = optional.isPresent() ? drive.getObjectMetadataVersion(serverBucket, string, optional.get().intValue()) : this.getDriverObjectMetadataInternal(serverBucket, string, bl);
                objectMetadata.setBucketName(serverBucket.getName());
                ObjectMetadata objectMetadata2 = objectMetadata;
                return objectMetadata2;
            }
            catch (Exception exception) {
                throw new InternalCriticalException(exception, this.objectInfo(serverBucket, string));
            }
            finally {
                this.bucketReadUnLock(serverBucket);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.objectReadUnLock(serverBucket, string);
        }
    }
}

