/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid6;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.client.util.NumberFormatter;
import io.odilon.log.Logger;
import io.odilon.model.RedundancyLevel;
import io.odilon.model.ServiceStatus;
import io.odilon.service.BaseService;
import io.odilon.service.ServerSettings;
import jakarta.annotation.PostConstruct;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BufferPoolService
extends BaseService {
    private static Logger logger = Logger.getLogger((String)BufferPoolService.class.getName());
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    @JsonIgnore
    private final BlockingQueue<byte[]> pool;
    @JsonIgnore
    @Autowired
    private final ServerSettings serverSettings;
    private int poolSize;
    private int bufferSize;
    @JsonIgnore
    private AtomicBoolean initialized = new AtomicBoolean(false);

    public BufferPoolService(ServerSettings serverSettings) {
        this.serverSettings = serverSettings;
        this.poolSize = serverSettings.getR6BufferPoolSize();
        this.bufferSize = 0x2000000;
        this.pool = new ArrayBlockingQueue(this.poolSize);
    }

    @PostConstruct
    protected synchronized void onInitialize() {
        this.setStatus(ServiceStatus.STARTING);
        startuplogger.debug("Started -> " + BufferPoolService.class.getSimpleName());
        if (this.serverSettings.getRedundancyLevel() != RedundancyLevel.RAID_6) {
            startuplogger.debug("Buffers are not required for " + this.serverSettings.getRedundancyLevel().getName() + " and will not be initialized.");
        } else {
            this.initialize();
            startuplogger.debug("Buffer pool. " + this.poolSize + " | Total size. " + NumberFormatter.formatFileSize((long)(this.poolSize * this.bufferSize)));
        }
        this.setStatus(ServiceStatus.RUNNING);
    }

    private synchronized void initialize() {
        if (this.initialized.get()) {
            return;
        }
        for (int i = 0; i < this.poolSize; ++i) {
            this.pool.add(new byte[this.bufferSize]);
        }
        this.initialized.set(true);
    }

    public byte[] acquire() {
        if (!this.initialized.get()) {
            this.initialize();
        }
        try {
            return (byte[])this.pool.take();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted while acquiring buffer", interruptedException);
        }
    }

    public void release(byte[] byArray) {
        if (!this.initialized.get()) {
            this.initialize();
        }
        if (byArray != null) {
            this.pool.offer(byArray);
        }
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setPoolSize(int n) {
        this.poolSize = n;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }
}

