/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid6;

import io.odilon.virtualFileSystem.raid6.Galois;

/*
 * Exception performing whole class analysis ignored.
 */
public class Matrix {
    private final int rows;
    private final int columns;
    private final byte[][] data;

    public Matrix(int n, int n2) {
        this.rows = n;
        this.columns = n2;
        this.data = new byte[this.rows][];
        for (int i = 0; i < this.rows; ++i) {
            this.data[i] = new byte[this.columns];
        }
    }

    public Matrix(byte[][] byArray) {
        this.rows = byArray.length;
        this.columns = byArray[0].length;
        this.data = new byte[this.rows][];
        for (int i = 0; i < this.rows; ++i) {
            if (byArray[i].length != this.columns) {
                throw new IllegalArgumentException("Not all rows have the same number of columns");
            }
            this.data[i] = new byte[this.columns];
            for (int j = 0; j < this.columns; ++j) {
                this.data[i][j] = byArray[i][j];
            }
        }
    }

    public static Matrix identity(int n) {
        Matrix matrix = new Matrix(n, n);
        for (int i = 0; i < n; ++i) {
            matrix.set(i, i, (byte)1);
        }
        return matrix;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        for (int i = 0; i < this.rows; ++i) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append('[');
            for (int j = 0; j < this.columns; ++j) {
                if (j != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.data[i][j] & 0xFF);
            }
            stringBuilder.append(']');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toBigString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                int n = this.get(i, j);
                if (n < 0) {
                    n += 256;
                }
                stringBuilder.append(String.format("%02x ", n));
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }

    public byte get(int n, int n2) {
        if (n < 0 || this.rows <= n) {
            throw new IllegalArgumentException("Row index out of range: " + n);
        }
        if (n2 < 0 || this.columns <= n2) {
            throw new IllegalArgumentException("Column index out of range: " + n2);
        }
        return this.data[n][n2];
    }

    public void set(int n, int n2, byte by) {
        if (n < 0 || this.rows <= n) {
            throw new IllegalArgumentException("Row index out of range: " + n);
        }
        if (n2 < 0 || this.columns <= n2) {
            throw new IllegalArgumentException("Column index out of range: " + n2);
        }
        this.data[n][n2] = by;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Matrix)) {
            return false;
        }
        for (int i = 0; i < this.rows; ++i) {
            if (this.data[i].equals(((Matrix)object).data[i])) continue;
            return false;
        }
        return true;
    }

    public Matrix times(Matrix matrix) {
        if (this.getColumns() != matrix.getRows()) {
            throw new IllegalArgumentException("Columns on left (" + this.getColumns() + ") is different than rows on right (" + matrix.getRows() + ")");
        }
        Matrix matrix2 = new Matrix(this.getRows(), matrix.getColumns());
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < matrix.getColumns(); ++j) {
                byte by = 0;
                for (int k = 0; k < this.getColumns(); ++k) {
                    by = (byte)(by ^ Galois.multiply((byte)this.get(i, k), (byte)matrix.get(k, j)));
                }
                matrix2.set(i, j, by);
            }
        }
        return matrix2;
    }

    public Matrix augment(Matrix matrix) {
        if (this.rows != matrix.rows) {
            throw new IllegalArgumentException("Matrices don't have the same number of rows");
        }
        Matrix matrix2 = new Matrix(this.rows, this.columns + matrix.columns);
        for (int i = 0; i < this.rows; ++i) {
            int n;
            for (n = 0; n < this.columns; ++n) {
                matrix2.data[i][n] = this.data[i][n];
            }
            for (n = 0; n < matrix.columns; ++n) {
                matrix2.data[i][this.columns + n] = matrix.data[i][n];
            }
        }
        return matrix2;
    }

    public Matrix submatrix(int n, int n2, int n3, int n4) {
        Matrix matrix = new Matrix(n3 - n, n4 - n2);
        for (int i = n; i < n3; ++i) {
            for (int j = n2; j < n4; ++j) {
                matrix.data[i - n][j - n2] = this.data[i][j];
            }
        }
        return matrix;
    }

    public byte[] getRow(int n) {
        byte[] byArray = new byte[this.columns];
        for (int i = 0; i < this.columns; ++i) {
            byArray[i] = this.get(n, i);
        }
        return byArray;
    }

    public void swapRows(int n, int n2) {
        if (n < 0 || this.rows <= n || n2 < 0 || this.rows <= n2) {
            throw new IllegalArgumentException("Row index out of range");
        }
        byte[] byArray = this.data[n];
        this.data[n] = this.data[n2];
        this.data[n2] = byArray;
    }

    public Matrix invert() {
        if (this.rows != this.columns) {
            throw new IllegalArgumentException("Only square matrices can be inverted");
        }
        Matrix matrix = this.augment(Matrix.identity((int)this.rows));
        matrix.gaussianElimination();
        return matrix.submatrix(0, this.rows, this.columns, this.columns * 2);
    }

    private void gaussianElimination() {
        int n;
        byte by;
        byte by2;
        int n2;
        for (n2 = 0; n2 < this.rows; ++n2) {
            if (this.data[n2][n2] == 0) {
                for (by2 = n2 + 1; by2 < this.rows; ++by2) {
                    if (this.data[by2][n2] == 0) continue;
                    this.swapRows(n2, (int)by2);
                    break;
                }
            }
            if (this.data[n2][n2] == 0) {
                throw new IllegalArgumentException("Matrix is singular");
            }
            if (this.data[n2][n2] != 1) {
                by2 = Galois.divide((byte)1, (byte)this.data[n2][n2]);
                for (by = 0; by < this.columns; ++by) {
                    this.data[n2][by] = Galois.multiply((byte)this.data[n2][by], (byte)by2);
                }
            }
            for (by2 = n2 + 1; by2 < this.rows; ++by2) {
                if (this.data[by2][n2] == 0) continue;
                by = this.data[by2][n2];
                for (n = 0; n < this.columns; ++n) {
                    byte[] byArray = this.data[by2];
                    int n3 = n;
                    byArray[n3] = (byte)(byArray[n3] ^ Galois.multiply((byte)by, (byte)this.data[n2][n]));
                }
            }
        }
        for (n2 = 0; n2 < this.rows; ++n2) {
            for (by2 = 0; by2 < n2; ++by2) {
                if (this.data[by2][n2] == 0) continue;
                by = this.data[by2][n2];
                for (n = 0; n < this.columns; ++n) {
                    byte[] byArray = this.data[by2];
                    int n4 = n;
                    byArray[n4] = (byte)(byArray[n4] ^ Galois.multiply((byte)by, (byte)this.data[n2][n]));
                }
            }
        }
    }
}

