/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid6;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.monitor.SystemMonitorService;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.LockService;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.raid6.BufferPoolService;
import io.odilon.virtualFileSystem.raid6.RAIDSixCoder;
import io.odilon.virtualFileSystem.raid6.RAIDSixDriver;
import io.odilon.virtualFileSystem.raid6.RAIDSixEncoder;
import io.odilon.virtualFileSystem.raid6.ReedSolomon;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Optional;

/*
 * Exception performing whole class analysis ignored.
 */
public class RAIDSixDecoder
extends RAIDSixCoder {
    private static Logger logger = Logger.getLogger((String)RAIDSixEncoder.class.getName());
    @JsonIgnore
    private static final DateTimeFormatter formatter = DateTimeFormatter.RFC_1123_DATE_TIME;
    private final int data_shards = this.getVirtualFileSystemService().getServerSettings().getRAID6DataDrives();
    private final int parity_shards = this.getVirtualFileSystemService().getServerSettings().getRAID6ParityDrives();
    private final int total_shards = this.data_shards + this.parity_shards;
    private final ReedSolomon reedSolomon;

    protected RAIDSixDecoder(RAIDSixDriver rAIDSixDriver) {
        super(rAIDSixDriver);
        if (!rAIDSixDriver.isConfigurationValid(this.data_shards, this.parity_shards)) {
            throw new InternalCriticalException("Invalid configuration -> " + this.toString());
        }
        this.reedSolomon = new ReedSolomon(this.data_shards, this.parity_shards);
    }

    public BufferPoolService getBullferPoolService() {
        return this.getVirtualFileSystemService().getBufferPoolService();
    }

    public File decodeHead(ObjectMetadata objectMetadata, ServerBucket serverBucket) {
        return this.decode(objectMetadata, serverBucket, true);
    }

    public File decodeVersion(ObjectMetadata objectMetadata, ServerBucket serverBucket) {
        return this.decode(objectMetadata, serverBucket, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File decode(ObjectMetadata objectMetadata, ServerBucket serverBucket, boolean bl) {
        String string = objectMetadata.getBucketName();
        String string2 = objectMetadata.getObjectName();
        int n = objectMetadata.getTotalBlocks() / this.getTotalShards();
        if (objectMetadata.getRaidDrives() > 0 && objectMetadata.getRaidDrives() != this.getTotalShards()) {
            String string3 = "b: " + objectMetadata.getBucketName() + " o: " + objectMetadata.getObjectName() + " | was stored on " + formatter.format(objectMetadata.getLastModified()) + " | with  " + String.valueOf(objectMetadata.getRaidDrives()) + " drives | Server is currently set up with -> " + String.valueOf(this.getTotalShards()) + " drives";
            logger.error(new String[]{string3});
            logger.error(new String[]{"RAID Drives"});
            this.getDriver().getDrivesEnabled().forEach(drive -> logger.error(new String[]{drive.getRootDirPath()}));
            throw new InternalCriticalException(string3);
        }
        Optional optional = bl ? Optional.empty() : Optional.of(objectMetadata.getVersion());
        int n2 = 0;
        File file = this.getFileCacheService().get(serverBucket.getId(), string2, optional);
        if (file != null && file.exists()) {
            this.getSystemMonitorService().getCacheFileHitCounter().inc();
            return file;
        }
        this.getSystemMonitorService().getCacheFileMissCounter().inc();
        this.getLockService().getFileCacheLock(serverBucket.getId(), string2, optional).writeLock().lock();
        try {
            Object object;
            String string4 = this.getFileCacheService().getFileCachePath(serverBucket.getId(), string2, optional);
            try {
                object = new BufferedOutputStream(new FileOutputStream(string4));
                try {
                    while (n2 < n) {
                        this.decodeChunk(objectMetadata, serverBucket, n2++, (OutputStream)object, bl);
                    }
                }
                finally {
                    ((OutputStream)object).close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new InternalCriticalException((Exception)fileNotFoundException, this.objectInfo(string, string2, string4));
            }
            catch (IOException iOException) {
                throw new InternalCriticalException((Exception)iOException, this.objectInfo(string, string2, string4));
            }
            object = new File(string4);
            this.getFileCacheService().put(serverBucket.getId(), string2, optional, (File)object, false);
            Object object2 = object;
            return object2;
        }
        finally {
            this.getLockService().getFileCacheLock(serverBucket.getId(), string2, optional).writeLock().unlock();
        }
    }

    private boolean decodeChunk(ObjectMetadata objectMetadata, ServerBucket serverBucket, int n, OutputStream outputStream, boolean bl) {
        int n2;
        byte[][] byArrayArray = new byte[this.total_shards][];
        boolean[] blArray = new boolean[this.total_shards];
        int n3 = 0;
        int n4 = 0;
        Map map = this.getMapDrivesRSDecode();
        for (n2 = 0; n2 < this.getTotalShards(); ++n2) {
            File file;
            Drive drive = (Drive)map.get(n2);
            if (drive == null) continue;
            int n5 = drive.getConfigOrder();
            File file2 = file = bl ? new File(drive.getBucketObjectDataDirPath(serverBucket), objectMetadata.getObjectName() + "." + n + "." + n5) : new File(drive.getBucketObjectDataDirPath(serverBucket) + File.separator + "version", objectMetadata.getObjectName() + "." + n + "." + n5 + ".v" + objectMetadata.getVersion());
            if (!file.exists()) continue;
            n3 = (int)file.length();
            byArrayArray[n5] = new byte[n3];
            blArray[n5] = true;
            ++n4;
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
                RAIDSixDecoder.readFully((InputStream)bufferedInputStream, (byte[])byArrayArray[n5]);
                continue;
            }
            catch (IOException iOException) {
                logger.error(new String[]{this.objectInfo(objectMetadata) + " | f:" + file.getName(), "---- not thrown ----"});
                blArray[n5] = false;
                byArrayArray[n5] = null;
                --n4;
            }
        }
        if (n4 < this.data_shards) {
            throw new InternalCriticalException("We need at least " + this.data_shards + " shards to reconstruct | " + this.objectInfo(objectMetadata));
        }
        for (n2 = 0; n2 < this.total_shards; ++n2) {
            if (blArray[n2]) continue;
            byArrayArray[n2] = new byte[n3];
        }
        this.reedSolomon.decodeMissing((byte[][])byArrayArray, blArray, 0, n3);
        byte[] byArray = this.getBullferPoolService().acquire();
        try {
            int n6;
            for (n6 = 0; n6 < this.data_shards; ++n6) {
                System.arraycopy(byArrayArray[n6], 0, byArray, n6 * n3, n3);
            }
            n6 = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
            outputStream.write(byArray, 4, n6);
        }
        catch (IOException iOException) {
            throw new InternalCriticalException((Exception)iOException, this.objectInfo(objectMetadata));
        }
        finally {
            this.getBullferPoolService().release(byArray);
        }
        return true;
    }

    private static void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        int n2 = 0;
        for (int i = byArray.length; i > 0; i -= n) {
            n = inputStream.read(byArray, n2, i);
            if (n < 0) {
                throw new EOFException("Unexpected EOF");
            }
            n2 += n;
        }
    }

    private final Map<Integer, Drive> getMapDrivesRSDecode() {
        return this.getDriver().getVirtualFileSystemService().getMapDrivesRSDecode();
    }

    private SystemMonitorService getSystemMonitorService() {
        return this.getDriver().getVirtualFileSystemService().getSystemMonitorService();
    }

    private String objectInfo(String string, String string2, String string3) {
        return this.getDriver().objectInfo(string, string2, string3);
    }

    private LockService getLockService() {
        return this.getFileCacheService().getLockService();
    }

    private int getTotalShards() {
        return this.total_shards;
    }
}

