/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid6;

import io.odilon.error.OdilonObjectNotFoundException;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.scheduler.AfterDeleteObjectServiceRequest;
import io.odilon.scheduler.ServiceRequest;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.raid6.RAIDSixDriver;
import io.odilon.virtualFileSystem.raid6.RAIDSixTransactionObjectHandler;
import java.io.File;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;

public class RAIDSixDeleteObjectAllPreviousVersionsHandler
extends RAIDSixTransactionObjectHandler {
    private static Logger logger = Logger.getLogger((String)RAIDSixDeleteObjectAllPreviousVersionsHandler.class.getName());

    public RAIDSixDeleteObjectAllPreviousVersionsHandler(RAIDSixDriver rAIDSixDriver, ServerBucket serverBucket, String string) {
        super(rAIDSixDriver, serverBucket, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void delete() {
        ObjectMetadata objectMetadata;
        boolean bl;
        VirtualFileSystemOperation virtualFileSystemOperation;
        block35: {
            virtualFileSystemOperation = null;
            bl = false;
            boolean bl2 = false;
            objectMetadata = null;
            this.objectWriteLock();
            try {
                block34: {
                    this.bucketReadLock();
                    this.checkExistsBucket();
                    this.checkExistObject();
                    objectMetadata = this.getMetadata();
                    if (objectMetadata.getVersion() != 0) break block34;
                    try {
                        if (!bl) {
                            try {
                                this.rollback(virtualFileSystemOperation);
                                return;
                            }
                            catch (Exception exception) {
                                if (!bl2) {
                                    throw new InternalCriticalException(exception, this.info());
                                }
                                logger.error((Throwable)exception, new String[]{this.info(), "---- not thrown ----"});
                                return;
                            }
                        }
                        if (!bl) return;
                        this.postCommit(objectMetadata, this.getBucket(), objectMetadata.getVersion());
                        return;
                    }
                    finally {
                        this.bucketReadLock();
                    }
                }
                this.backup();
                virtualFileSystemOperation = this.deleteObjectPreviousVersions(objectMetadata.getVersion());
                for (int i = 0; i < objectMetadata.getVersion(); ++i) {
                    for (Drive drive2 : this.getDriver().getDrivesAll()) {
                        FileUtils.deleteQuietly((File)drive2.getObjectMetadataVersionFile(this.getBucket(), this.getObjectName(), i));
                    }
                }
                objectMetadata.addSystemTag("delete versions");
                objectMetadata.setLastModified(OffsetDateTime.now());
                List list = this.getDriver().getDrivesAll();
                ArrayList arrayList = new ArrayList();
                this.getDriver().getDrivesAll().forEach(drive -> arrayList.add(drive.getObjectMetadata(this.getBucket(), this.getObjectName())));
                this.saveRAIDSixObjectMetadataToDisk(list, (List)arrayList, true);
                bl = virtualFileSystemOperation.commit();
                try {
                    if (!bl) {
                        try {
                            this.rollback(virtualFileSystemOperation);
                        }
                        catch (Exception exception) {
                            if (!bl2) {
                                throw new InternalCriticalException(exception, this.info());
                            }
                            logger.error((Throwable)exception, new String[]{this.info(), "---- not thrown ----"});
                        }
                        break block35;
                    }
                    if (bl) {
                        this.postCommit(objectMetadata, this.getBucket(), objectMetadata.getVersion());
                    }
                    break block35;
                }
                finally {
                    this.bucketReadLock();
                }
                catch (OdilonObjectNotFoundException odilonObjectNotFoundException) {
                    try {
                        bl2 = true;
                        throw odilonObjectNotFoundException;
                        catch (Exception exception) {
                            bl2 = true;
                            throw new InternalCriticalException(exception);
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (!bl) {
                                try {
                                    this.rollback(virtualFileSystemOperation);
                                    throw throwable;
                                }
                                catch (Exception exception) {
                                    if (!bl2) {
                                        throw new InternalCriticalException(exception, this.info());
                                    }
                                    logger.error((Throwable)exception, new String[]{this.info(), "---- not thrown ----"});
                                    throw throwable;
                                }
                            }
                            if (!bl) throw throwable;
                            this.postCommit(objectMetadata, this.getBucket(), objectMetadata.getVersion());
                            throw throwable;
                        }
                        finally {
                            this.bucketReadLock();
                        }
                    }
                }
            }
            finally {
                this.objectWriteLock();
            }
        }
        if (!bl) return;
        this.onAfterCommit(virtualFileSystemOperation, objectMetadata, objectMetadata.getVersion());
    }

    private void backup() {
        try {
            for (Drive drive : this.getDriver().getDrivesAll()) {
                String string = drive.getObjectMetadataDirPath(this.getBucket(), this.getObjectName());
                String string2 = drive.getBucketWorkDirPath(this.getBucket()) + File.separator + this.getObjectName();
                File file = new File(string);
                if (!file.exists()) continue;
                FileUtils.copyDirectory((File)file, (File)new File(string2));
            }
        }
        catch (IOException iOException) {
            throw new InternalCriticalException((Exception)iOException, this.info());
        }
    }

    private void onAfterCommit(VirtualFileSystemOperation virtualFileSystemOperation, ObjectMetadata objectMetadata, int n) {
        try {
            this.getSchedulerService().enqueue((ServiceRequest)this.getVirtualFileSystemService().getApplicationContext().getBean(AfterDeleteObjectServiceRequest.class, new Object[]{virtualFileSystemOperation.getOperationCode(), objectMetadata, n}));
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
        }
    }

    private void postCommit(ObjectMetadata objectMetadata, ServerBucket serverBucket, int n) {
        try {
            for (int i = 0; i < n; ++i) {
                this.getDriver().getObjectDataFiles(objectMetadata, serverBucket, Optional.of(i)).forEach(file -> FileUtils.deleteQuietly((File)file));
            }
            for (Drive drive : this.getDriver().getDrivesAll()) {
                FileUtils.deleteQuietly((File)new File(drive.getBucketWorkDirPath(serverBucket), objectMetadata.getObjectName()));
            }
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
        }
    }

    private VirtualFileSystemOperation deleteObjectPreviousVersions(int n) {
        return this.getJournalService().deleteObjectPreviousVersions(this.getBucket(), this.getObjectName(), n);
    }
}

