/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid6;

import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.scheduler.AfterDeleteObjectServiceRequest;
import io.odilon.scheduler.DeleteBucketObjectPreviousVersionServiceRequest;
import io.odilon.scheduler.ServiceRequest;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.raid6.RAIDSixDriver;
import io.odilon.virtualFileSystem.raid6.RAIDSixTransactionObjectHandler;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FileUtils;

@ThreadSafe
public class RAIDSixDeleteObjectHandler
extends RAIDSixTransactionObjectHandler {
    private static Logger logger = Logger.getLogger((String)RAIDSixDeleteObjectHandler.class.getName());

    protected RAIDSixDeleteObjectHandler(RAIDSixDriver rAIDSixDriver, ServerBucket serverBucket, String string) {
        super(rAIDSixDriver, serverBucket, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void delete() {
        ObjectMetadata objectMetadata;
        boolean bl;
        VirtualFileSystemOperation virtualFileSystemOperation;
        block30: {
            virtualFileSystemOperation = null;
            bl = false;
            boolean bl2 = false;
            objectMetadata = null;
            this.objectWriteLock();
            try {
                this.bucketReadLock();
                this.checkExistsBucket();
                this.checkExistObject();
                objectMetadata = this.getMetadata();
                this.backup(objectMetadata);
                virtualFileSystemOperation = this.deleteObject(objectMetadata.getVersion());
                for (Drive drive : this.getDriver().getDrivesAll()) {
                    drive.deleteObjectMetadata(this.getBucket(), this.getObjectName());
                }
                bl = virtualFileSystemOperation.commit();
                try {
                    if (!bl) {
                        try {
                            this.rollback(virtualFileSystemOperation);
                        }
                        catch (Exception exception) {
                            if (!bl2) {
                                throw new InternalCriticalException(exception, this.info());
                            }
                            logger.error((Throwable)exception, new String[]{this.info(), "---- not thrown ----"});
                        }
                        break block30;
                    }
                    if (bl) {
                        this.postCommit(objectMetadata, this.getBucket(), objectMetadata.getVersion());
                    }
                    break block30;
                }
                catch (Exception exception) {
                    logger.error((Throwable)exception, new String[]{this.opInfo(virtualFileSystemOperation), "---- not thrown ----"});
                    break block30;
                }
                finally {
                    this.bucketReadUnLock();
                }
                catch (InternalCriticalException internalCriticalException) {
                    try {
                        bl2 = true;
                        throw new InternalCriticalException((Exception)((Object)internalCriticalException));
                        catch (Exception exception) {
                            bl2 = true;
                            throw new InternalCriticalException(exception, this.info());
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (!bl) {
                                try {
                                    this.rollback(virtualFileSystemOperation);
                                    throw throwable;
                                }
                                catch (Exception exception) {
                                    if (!bl2) {
                                        throw new InternalCriticalException(exception, this.info());
                                    }
                                    logger.error((Throwable)exception, new String[]{this.info(), "---- not thrown ----"});
                                    throw throwable;
                                }
                            }
                            if (!bl) throw throwable;
                            this.postCommit(objectMetadata, this.getBucket(), objectMetadata.getVersion());
                            throw throwable;
                        }
                        catch (Exception exception) {
                            logger.error((Throwable)exception, new String[]{this.opInfo(virtualFileSystemOperation), "---- not thrown ----"});
                            throw throwable;
                        }
                        finally {
                            this.bucketReadUnLock();
                        }
                    }
                }
            }
            finally {
                this.objectWriteUnLock();
            }
        }
        if (!bl) return;
        try {
            this.getSchedulerService().enqueue((ServiceRequest)this.getVirtualFileSystemService().getApplicationContext().getBean(AfterDeleteObjectServiceRequest.class, new Object[]{virtualFileSystemOperation.getOperationCode(), objectMetadata, objectMetadata.getVersion()}));
            return;
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
        }
    }

    private VirtualFileSystemOperation deleteObject(int n) {
        return this.getJournalService().deleteObject(this.getBucket(), this.getObjectName(), n);
    }

    protected void deleteBucketAllPreviousVersions(ServerBucket serverBucket) {
        this.getSchedulerService().enqueue((ServiceRequest)this.getVirtualFileSystemService().getApplicationContext().getBean(DeleteBucketObjectPreviousVersionServiceRequest.class, new Object[]{serverBucket.getName(), serverBucket.getId()}));
    }

    private void postCommit(ObjectMetadata objectMetadata, ServerBucket serverBucket, int n) {
        String string = objectMetadata.getObjectName();
        try {
            for (int i = 0; i < n; ++i) {
                this.getDriver().getObjectDataFiles(objectMetadata, serverBucket, Optional.of(i)).forEach(file -> FileUtils.deleteQuietly((File)file));
            }
            this.getDriver().getObjectDataFiles(objectMetadata, serverBucket, Optional.empty()).forEach(file -> FileUtils.deleteQuietly((File)file));
            for (Drive drive : this.getDriver().getDrivesAll()) {
                FileUtils.deleteQuietly((File)new File(drive.getBucketWorkDirPath(serverBucket), string));
            }
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
        }
    }

    private void backup(ObjectMetadata objectMetadata) {
        try {
            for (Drive drive : this.getDriver().getDrivesAll()) {
                String string = drive.getObjectMetadataDirPath(this.getBucket(), objectMetadata.getObjectName());
                String string2 = drive.getBucketWorkDirPath(this.getBucket()) + File.separator + objectMetadata.getObjectName();
                File file = new File(string);
                if (!file.exists()) continue;
                FileUtils.copyDirectory((File)file, (File)new File(string2));
            }
        }
        catch (IOException iOException) {
            throw new InternalCriticalException((Exception)iOException, this.objectInfo(objectMetadata));
        }
    }
}

