/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid6;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.error.OdilonObjectNotFoundException;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.model.RedundancyLevel;
import io.odilon.model.list.DataList;
import io.odilon.model.list.Item;
import io.odilon.query.BucketIteratorService;
import io.odilon.scheduler.DeleteBucketObjectPreviousVersionServiceRequest;
import io.odilon.scheduler.ServiceRequest;
import io.odilon.util.Check;
import io.odilon.virtualFileSystem.BaseIODriver;
import io.odilon.virtualFileSystem.OdilonObject;
import io.odilon.virtualFileSystem.model.BucketIterator;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.LockService;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemObject;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import io.odilon.virtualFileSystem.raid6.RAIDSixBucketIterator;
import io.odilon.virtualFileSystem.raid6.RAIDSixCreateObjectHandler;
import io.odilon.virtualFileSystem.raid6.RAIDSixDecoder;
import io.odilon.virtualFileSystem.raid6.RAIDSixDeleteObjectAllPreviousVersionsHandler;
import io.odilon.virtualFileSystem.raid6.RAIDSixDeleteObjectHandler;
import io.odilon.virtualFileSystem.raid6.RAIDSixDriveSetup;
import io.odilon.virtualFileSystem.raid6.RAIDSixSyncObjectHandler;
import io.odilon.virtualFileSystem.raid6.RAIDSixUpdateObjectHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@ThreadSafe
public class RAIDSixDriver
extends BaseIODriver
implements ApplicationContextAware {
    private static Logger logger = Logger.getLogger((String)RAIDSixDriver.class.getName());
    @JsonIgnore
    private ApplicationContext applicationContext;

    public RAIDSixDriver(VirtualFileSystemService virtualFileSystemService, LockService lockService) {
        super(virtualFileSystemService, lockService);
    }

    public void syncObject(ObjectMetadata objectMetadata) {
        Check.requireNonNullArgument((Object)objectMetadata, (String)"meta is null");
        RAIDSixSyncObjectHandler rAIDSixSyncObjectHandler = new RAIDSixSyncObjectHandler(this);
        rAIDSixSyncObjectHandler.sync(objectMetadata);
    }

    public InputStream getInputStream(ServerBucket serverBucket, String string) throws IOException {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireNonNullArgument((Object)string, (String)("objectName is null or empty | b:" + serverBucket.getName()));
        this.objectReadLock(serverBucket, string);
        try {
            this.bucketReadLock(serverBucket);
            try {
                this.checkExistBucket(serverBucket);
                this.checkIsAccesible(serverBucket);
                ObjectMetadata objectMetadata = this.getDriverObjectMetadataInternal(serverBucket, string, true);
                if (objectMetadata != null && objectMetadata.isAccesible()) {
                    RAIDSixDecoder rAIDSixDecoder = new RAIDSixDecoder(this);
                    InputStream inputStream = objectMetadata.isEncrypt() ? this.getVirtualFileSystemService().getEncryptionService().decryptStream(Files.newInputStream(rAIDSixDecoder.decodeHead(objectMetadata, serverBucket).toPath(), new OpenOption[0])) : Files.newInputStream(rAIDSixDecoder.decodeHead(objectMetadata, serverBucket).toPath(), new OpenOption[0]);
                    return inputStream;
                }
                try {
                    throw new OdilonObjectNotFoundException(this.objectInfo(serverBucket, string));
                }
                catch (OdilonObjectNotFoundException odilonObjectNotFoundException) {
                    throw odilonObjectNotFoundException;
                }
                catch (Exception exception) {
                    throw new InternalCriticalException(exception, this.objectInfo(serverBucket, string));
                }
            }
            finally {
                this.bucketReadUnLock(serverBucket);
            }
        }
        finally {
            this.objectReadUnLock(serverBucket, string);
        }
    }

    /*
     * Loose catch block
     */
    public InputStream getObjectVersionInputStream(ServerBucket serverBucket, String string, int n) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireNonNullArgument((Object)string, (String)("objectName is null or empty | b:" + serverBucket.getName()));
        this.objectReadLock(serverBucket, string);
        try {
            InputStream inputStream;
            this.bucketReadLock(serverBucket);
            try {
                this.checkExistBucket(serverBucket);
                this.checkIsAccesible(serverBucket);
                Drive drive = this.getObjectMetadataReadDrive(serverBucket, string);
                ObjectMetadata objectMetadata = drive.getObjectMetadataVersion(serverBucket, string, n);
                if (objectMetadata == null || !objectMetadata.isAccesible()) {
                    throw new OdilonObjectNotFoundException("object version does not exists for -> b:" + this.objectInfo(serverBucket, string) + " | v:" + String.valueOf(n));
                }
                RAIDSixDecoder rAIDSixDecoder = new RAIDSixDecoder(this);
                File file = rAIDSixDecoder.decodeVersion(objectMetadata, serverBucket);
                if (objectMetadata.isEncrypt()) {
                    InputStream inputStream2 = this.getVirtualFileSystemService().getEncryptionService().decryptStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
                    return inputStream2;
                }
                inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
            }
            catch (OdilonObjectNotFoundException odilonObjectNotFoundException) {
                throw odilonObjectNotFoundException;
            }
            catch (Exception exception) {
                throw new InternalCriticalException(exception, this.objectInfo(serverBucket, string) + " | v:" + String.valueOf(n));
            }
            finally {
                this.bucketReadUnLock(serverBucket);
            }
            return inputStream;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.objectReadUnLock(serverBucket, string);
        }
    }

    /*
     * Exception decompiling
     */
    public boolean checkIntegrity(ServerBucket var1_1, String var2_2, boolean var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 22[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void rollback(VirtualFileSystemOperation var1_1, Object var2_2, boolean var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public ObjectMetadata getObjectMetadata(ServerBucket serverBucket, String string) {
        return this.getOM(serverBucket, string, Optional.empty(), true);
    }

    /*
     * Loose catch block
     */
    public boolean exists(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireNonNullStringArgument((String)string, (String)("objectName is null or empty | b:" + serverBucket.getName()));
        this.getLockService().getObjectLock(serverBucket, string).readLock().lock();
        try {
            this.getLockService().getBucketLock(serverBucket).readLock().lock();
            try {
                this.checkIsAccesible(serverBucket);
                boolean bl = this.getObjectMetadataReadDrive(serverBucket, string).existsObjectMetadata(serverBucket, string);
                return bl;
            }
            catch (Exception exception) {
                throw new InternalCriticalException(exception, this.objectInfo(serverBucket, string));
            }
            finally {
                this.getLockService().getBucketLock(serverBucket).readLock().unlock();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.getLockService().getObjectLock(serverBucket, string).readLock().unlock();
        }
    }

    public void putObject(ServerBucket serverBucket, String string, InputStream inputStream, String string2, String string3, Optional<List<String>> optional) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireNonNullStringArgument((String)string, (String)("objectName can not be null | b:" + serverBucket.getName()));
        Check.requireNonNullStringArgument((String)string2, (String)("fileName is null | b: " + serverBucket.getName() + " o:" + string));
        Check.requireNonNullArgument((Object)inputStream, (String)("InpuStream can not null -> b:" + serverBucket.getName() + " | o:" + string));
        if (this.exists(serverBucket, string)) {
            RAIDSixUpdateObjectHandler rAIDSixUpdateObjectHandler = new RAIDSixUpdateObjectHandler(this, serverBucket, string);
            rAIDSixUpdateObjectHandler.update(serverBucket, string, inputStream, string2, string3, optional);
            this.getVirtualFileSystemService().getSystemMonitorService().getUpdateObjectCounter().inc();
        } else {
            RAIDSixCreateObjectHandler rAIDSixCreateObjectHandler = new RAIDSixCreateObjectHandler(this, serverBucket, string);
            rAIDSixCreateObjectHandler.create(inputStream, string2, string3, optional);
            this.getVirtualFileSystemService().getSystemMonitorService().getCreateObjectCounter().inc();
        }
    }

    public void putObjectMetadata(ObjectMetadata objectMetadata) {
        Check.requireNonNullArgument((Object)objectMetadata, (String)"meta is null");
        RAIDSixUpdateObjectHandler rAIDSixUpdateObjectHandler = new RAIDSixUpdateObjectHandler(this, this.getBucket(objectMetadata.getBucketName()), objectMetadata.getObjectName());
        rAIDSixUpdateObjectHandler.updateObjectMetadataHeadVersion(objectMetadata);
        this.getVirtualFileSystemService().getSystemMonitorService().getUpdateObjectCounter().inc();
    }

    /*
     * Loose catch block
     */
    public VirtualFileSystemObject getObject(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireNonNullArgument((Object)string, (String)("objectName can not be null | b:" + serverBucket.getName()));
        String string2 = serverBucket.getName();
        this.getLockService().getObjectLock(serverBucket, string).readLock().lock();
        try {
            this.bucketReadLock(serverBucket);
            try {
                this.checkIsAccesible(serverBucket);
                if (!this.existsCacheBucket(serverBucket.getName())) {
                    throw new IllegalArgumentException("bucket does not exist -> " + this.objectInfo(serverBucket));
                }
                ObjectMetadata objectMetadata = this.getDriverObjectMetadataInternal(serverBucket, string, true);
                if (objectMetadata == null || !objectMetadata.isAccesible()) {
                    throw new OdilonObjectNotFoundException(this.objectInfo(serverBucket, string));
                }
                OdilonObject odilonObject = new OdilonObject(serverBucket, string, this.getVirtualFileSystemService());
                return odilonObject;
            }
            catch (Exception exception) {
                throw new InternalCriticalException(exception, this.objectInfo(string2, string));
            }
            finally {
                this.bucketReadUnLock(serverBucket);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.getLockService().getObjectLock(serverBucket, string).readLock().unlock();
        }
    }

    public void postObjectDeleteTransaction(ObjectMetadata objectMetadata, int n) {
    }

    public void postObjectPreviousVersionDeleteAllTransaction(ObjectMetadata objectMetadata, int n) {
    }

    public boolean hasVersions(ServerBucket serverBucket, String string) {
        return !this.getObjectMetadataVersionAll(serverBucket, string).isEmpty();
    }

    /*
     * Loose catch block
     */
    public List<ObjectMetadata> getObjectMetadataVersionAll(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireNonNullStringArgument((String)string, (String)("objectName is null or empty | b:" + serverBucket.getName()));
        ArrayList<ObjectMetadata> arrayList = new ArrayList<ObjectMetadata>();
        Drive drive = null;
        this.getLockService().getObjectLock(serverBucket, string).readLock().lock();
        try {
            ArrayList<ObjectMetadata> arrayList2;
            this.bucketReadLock(serverBucket);
            try {
                this.checkIsAccesible(serverBucket);
                if (!this.existsCacheBucket(serverBucket.getName())) {
                    throw new IllegalArgumentException("bucket does not exist -> " + this.objectInfo(serverBucket));
                }
                drive = this.getObjectMetadataReadDrive(serverBucket, string);
                ObjectMetadata objectMetadata = this.getDriverObjectMetadataInternal(serverBucket, string, true);
                if (objectMetadata == null || !objectMetadata.isAccesible()) {
                    throw new OdilonObjectNotFoundException(ObjectMetadata.class.getName() + " does not exist");
                }
                objectMetadata.setBucketName(serverBucket.getName());
                if (objectMetadata.getVersion() == 0) {
                    ArrayList<ObjectMetadata> arrayList3 = arrayList;
                    return arrayList3;
                }
                for (int i = 0; i < objectMetadata.getVersion(); ++i) {
                    ObjectMetadata objectMetadata2 = drive.getObjectMetadataVersion(serverBucket, string, i);
                    if (objectMetadata2 == null) continue;
                    objectMetadata2.setBucketName(serverBucket.getName());
                    arrayList.add(objectMetadata2);
                }
                arrayList2 = arrayList;
            }
            catch (OdilonObjectNotFoundException odilonObjectNotFoundException) {
                odilonObjectNotFoundException.setErrorMessage((String)(odilonObjectNotFoundException.getMessage() != null ? odilonObjectNotFoundException.getMessage() + " | " : "") + this.objectInfo(serverBucket, string) + ", d:" + (Optional.ofNullable(drive).isPresent() ? drive.getName() : "null"));
                throw odilonObjectNotFoundException;
            }
            catch (Exception exception) {
                throw new InternalCriticalException(exception, this.objectInfo(serverBucket, string) + ", d:" + (Optional.ofNullable(drive).isPresent() ? drive.getName() : "null"));
            }
            finally {
                this.bucketReadUnLock(serverBucket);
            }
            return arrayList2;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.getLockService().getObjectLock(serverBucket, string).readLock().unlock();
        }
    }

    public void wipeAllPreviousVersions() {
        this.getSchedulerService().enqueue((ServiceRequest)this.getVirtualFileSystemService().getApplicationContext().getBean(DeleteBucketObjectPreviousVersionServiceRequest.class));
    }

    public void delete(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireNonNullArgument((Object)string, (String)("objectName is null or empty | b:" + serverBucket.getName()));
        RAIDSixDeleteObjectHandler rAIDSixDeleteObjectHandler = new RAIDSixDeleteObjectHandler(this, serverBucket, string);
        rAIDSixDeleteObjectHandler.delete();
    }

    public ObjectMetadata getObjectMetadataVersion(ServerBucket serverBucket, String string, int n) {
        return this.getOM(serverBucket, string, Optional.of(n), true);
    }

    public ObjectMetadata restorePreviousVersion(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        RAIDSixUpdateObjectHandler rAIDSixUpdateObjectHandler = new RAIDSixUpdateObjectHandler(this, serverBucket, string);
        return rAIDSixUpdateObjectHandler.restorePreviousVersion(serverBucket, string);
    }

    public void deleteObjectAllPreviousVersions(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireNonNullArgument((Object)serverBucket, (String)("bucket does not exist ->" + this.objectInfo(serverBucket)));
        Check.requireNonNullArgument((Object)string, (String)("objectName is null or empty | b:" + this.objectInfo(serverBucket)));
        RAIDSixDeleteObjectAllPreviousVersionsHandler rAIDSixDeleteObjectAllPreviousVersionsHandler = new RAIDSixDeleteObjectAllPreviousVersionsHandler(this, serverBucket, string);
        rAIDSixDeleteObjectAllPreviousVersionsHandler.delete();
    }

    public void deleteBucketAllPreviousVersions(ServerBucket serverBucket) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireNonNullArgument((Object)serverBucket, (String)("bucket does not exist ->" + this.objectInfo(serverBucket)));
        Check.requireTrue((boolean)serverBucket.isAccesible(), (String)("bucket is not Accesible " + this.objectInfo(serverBucket)));
        this.getSchedulerService().enqueue((ServiceRequest)this.getVirtualFileSystemService().getApplicationContext().getBean(DeleteBucketObjectPreviousVersionServiceRequest.class, new Object[]{serverBucket.getName(), serverBucket.getId()}));
    }

    public RedundancyLevel getRedundancyLevel() {
        return RedundancyLevel.RAID_6;
    }

    public boolean setUpDrives() {
        logger.debug("Starting async process to set up drives");
        return ((RAIDSixDriveSetup)this.getApplicationContext().getBean(RAIDSixDriveSetup.class, new Object[]{this})).setup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataList<Item<ObjectMetadata>> listObjects(ServerBucket serverBucket, Optional<Long> optional, Optional<Integer> optional2, Optional<String> optional3, Optional<String> optional4) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        BucketIterator bucketIterator = null;
        BucketIteratorService bucketIteratorService = this.getVirtualFileSystemService().getBucketIteratorService();
        try {
            DataList dataList;
            Path path;
            if (optional4.isPresent()) {
                bucketIterator = bucketIteratorService.get(optional4.get());
            }
            if (bucketIterator == null) {
                bucketIterator = new RAIDSixBucketIterator(this, serverBucket, optional, optional3);
                bucketIteratorService.register(bucketIterator);
            }
            ArrayList<DataList> arrayList = new ArrayList<DataList>();
            int n = optional2.orElseGet(() -> 60);
            int n2 = 0;
            while (bucketIterator.hasNext() && n2++ < n) {
                try {
                    path = bucketIterator.next();
                    String string = path.toFile().getName();
                    dataList = new Item((Serializable)this.getObjectMetadata(serverBucket, string));
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                    logger.error((Throwable)illegalMonitorStateException, new String[]{"---- not thrown ----"});
                    dataList = new Item((Exception)illegalMonitorStateException);
                }
                catch (Exception exception) {
                    logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                    dataList = new Item(exception);
                }
                arrayList.add(dataList);
            }
            dataList = new DataList(arrayList);
            if (!bucketIterator.hasNext()) {
                dataList.setEOD(true);
            }
            dataList.setOffset(bucketIterator.getOffset().longValue());
            dataList.setPageSize((long)n);
            dataList.setAgentId(bucketIterator.getAgentId());
            path = dataList;
            return path;
        }
        finally {
            if (bucketIterator != null && !bucketIterator.hasNext()) {
                this.getVirtualFileSystemService().getBucketIteratorService().remove(bucketIterator.getAgentId());
            }
        }
    }

    protected Drive getObjectMetadataReadDrive(ServerBucket serverBucket, String string) {
        return (Drive)this.getDrivesEnabled().get(Double.valueOf(Math.abs(Math.random() * 1000.0)).intValue() % this.getDrivesEnabled().size());
    }

    /*
     * Exception decompiling
     */
    private ObjectMetadata getOM(ServerBucket var1_1, String var2_2, Optional<Integer> var3_3, boolean var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Map<Drive, List<String>> getObjectDataFilesNames(ObjectMetadata objectMetadata, Optional<Integer> optional) {
        Check.requireNonNullArgument((Object)objectMetadata, (String)"meta is null");
        HashMap<Drive, List<String>> hashMap = new HashMap<Drive, List<String>>();
        for (Drive drive : this.getDrivesAll()) {
            hashMap.put(drive, new ArrayList());
        }
        int n = objectMetadata.getSha256Blocks().size();
        int n2 = this.getVirtualFileSystemService().getServerSettings().getRAID6DataDrives() + this.getVirtualFileSystemService().getServerSettings().getRAID6ParityDrives();
        Check.checkTrue((n2 > 0 ? 1 : 0) != 0, (String)"total disks must be greater than zero");
        int n3 = n / n2;
        Check.checkTrue((n3 > 0 ? 1 : 0) != 0, (String)"chunks must be greater than zero");
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < this.getDrivesAll().size(); ++j) {
                String string = "." + String.valueOf(i) + "." + String.valueOf(j) + (String)(optional.isEmpty() ? "" : ".v" + String.valueOf(optional.get()));
                Drive drive = (Drive)this.getDrivesAll().get(j);
                ((List)hashMap.get(drive)).add(objectMetadata.getObjectName() + string);
            }
        }
        return hashMap;
    }

    protected boolean isConfigurationValid(int n, int n2) {
        return this.getVirtualFileSystemService().getServerSettings().isRAID6ConfigurationValid(n, n2);
    }

    protected List<File> getObjectDataFiles(ObjectMetadata objectMetadata, ServerBucket serverBucket, Optional<Integer> optional) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (objectMetadata == null) {
            return arrayList;
        }
        int n = objectMetadata.getSha256Blocks().size();
        int n2 = this.getServerSettings().getRAID6DataDrives() + this.getServerSettings().getRAID6ParityDrives();
        Check.checkTrue((n2 > 0 ? 1 : 0) != 0, (String)"total disks must be greater than zero");
        int n3 = n / n2;
        Check.checkTrue((n3 > 0 ? 1 : 0) != 0, (String)"chunks must be greater than zero");
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < this.getDrivesAll().size(); ++j) {
                String string = "." + String.valueOf(i) + "." + String.valueOf(j) + (String)(optional.isEmpty() ? "" : ".v" + String.valueOf(optional.get()));
                Drive drive = (Drive)this.getDrivesAll().get(j);
                if (optional.isEmpty()) {
                    arrayList.add(new File(drive.getBucketObjectDataDirPath(serverBucket), objectMetadata.getObjectName() + string));
                    continue;
                }
                arrayList.add(new File(drive.getBucketObjectDataDirPath(serverBucket) + File.separator + "version", objectMetadata.getObjectName() + string));
            }
        }
        return arrayList;
    }
}

