/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid6;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.errors.InternalCriticalException;
import io.odilon.file.ParallelFileCoypAgent;
import io.odilon.util.Check;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.raid6.BufferPoolService;
import io.odilon.virtualFileSystem.raid6.RAIDSixBlocks;
import io.odilon.virtualFileSystem.raid6.RAIDSixCoder;
import io.odilon.virtualFileSystem.raid6.RAIDSixDriver;
import io.odilon.virtualFileSystem.raid6.ReedSolomon;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class RAIDSixEncoder
extends RAIDSixCoder {
    @JsonIgnore
    private long fileSize = 0L;
    @JsonIgnore
    private int chunk = 0;
    @JsonIgnore
    private final int data_shards;
    @JsonIgnore
    private final int partiy_shards;
    @JsonIgnore
    private final int total_shards;
    @JsonIgnore
    private RAIDSixBlocks encodedInfo;
    @JsonIgnore
    private List<Drive> r6Drives;
    @JsonIgnore
    private final ReedSolomon reedSolomon;

    protected RAIDSixEncoder(RAIDSixDriver rAIDSixDriver) {
        this(rAIDSixDriver, null);
    }

    protected RAIDSixEncoder(RAIDSixDriver rAIDSixDriver, List<Drive> list) {
        super(rAIDSixDriver);
        this.r6Drives = list != null ? list : rAIDSixDriver.getDrivesAll();
        this.data_shards = this.getVirtualFileSystemService().getServerSettings().getRAID6DataDrives();
        this.partiy_shards = this.getVirtualFileSystemService().getServerSettings().getRAID6ParityDrives();
        this.total_shards = this.data_shards + this.partiy_shards;
        this.reedSolomon = new ReedSolomon(this.getDataShards(), this.getPartityShards());
    }

    public RAIDSixBlocks encodeHead(InputStream inputStream, ServerBucket serverBucket, String string) {
        return this.encode(inputStream, serverBucket, string, Optional.empty());
    }

    public RAIDSixBlocks encodeVersion(InputStream inputStream, ServerBucket serverBucket, String string, int n) {
        return this.encode(inputStream, serverBucket, string, Optional.of(n));
    }

    protected RAIDSixBlocks encode(InputStream inputStream, ServerBucket serverBucket, String string, Optional<Integer> optional) {
        Check.requireNonNull((Object)inputStream);
        Check.requireNonNull((Object)string);
        Check.requireNonNull((Object)serverBucket);
        if (!this.getDriver().isConfigurationValid(this.data_shards, this.partiy_shards)) {
            throw new InternalCriticalException("Incorrect configuration for RAID 6 -> data: " + String.valueOf(this.data_shards) + " | parity:" + String.valueOf(this.partiy_shards));
        }
        if (this.getDrives().size() < this.getTotalShards()) {
            throw new InternalCriticalException("There are not enough drives to encode the file in RAID 6 -> drives: " + String.valueOf(this.getDrives().size()) + " | required: " + String.valueOf(this.total_shards));
        }
        this.fileSize = 0L;
        this.chunk = 0;
        this.encodedInfo = new RAIDSixBlocks();
        boolean bl = false;
        try (InputStream inputStream2 = inputStream;){
            while (!bl) {
                bl = this.encodeChunk(inputStream, serverBucket, string, this.chunk++, optional);
            }
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, "o:" + string);
        }
        this.encodedInfo.setFileSize(this.fileSize);
        return this.encodedInfo;
    }

    public BufferPoolService getBullferPoolService() {
        return this.getVirtualFileSystemService().getBufferPoolService();
    }

    public boolean encodeChunk(InputStream inputStream, ServerBucket serverBucket, String string, int n, Optional<Integer> optional) {
        byte[] byArray = this.getBullferPoolService().acquire();
        boolean bl = false;
        try {
            int n2;
            int n3;
            for (n2 = 0; n2 < 0x1FFFFFC; n2 += n3) {
                n3 = inputStream.read(byArray, 4 + n2, 0x1FFFFFC - n2);
                if (n3 >= 0) continue;
                bl = true;
                break;
            }
            if (n2 == 0) {
                n3 = 1;
                return n3 != 0;
            }
            this.fileSize += (long)n2;
            byArray[0] = (byte)(n2 >>> 24);
            byArray[1] = (byte)(n2 >>> 16);
            byArray[2] = (byte)(n2 >>> 8);
            byArray[3] = (byte)n2;
            n3 = n2 + 4;
            int n4 = (n3 + this.data_shards - 1) / this.data_shards;
            int n5 = this.getTotalShards();
            int n6 = this.getDataShards();
            byte[][] byArray2 = new byte[n5][n4];
            for (int i = 0; i < n6; ++i) {
                System.arraycopy(byArray, i * n4, byArray2[i], 0, n4);
            }
            this.reedSolomon.encodeParity(byArray2, 0, n4);
            ArrayList<File> arrayList = new ArrayList<File>(n5);
            Boolean[] booleanArray = new Boolean[n5];
            for (int i = 0; i < n5; ++i) {
                if (this.isWrite(i)) {
                    String string2 = ((Drive)this.getDrives().get(i)).getBucketObjectDataDirPath(serverBucket) + (String)(optional.isEmpty() ? "" : File.separator + "version");
                    String string3 = string + "." + n + "." + i + (String)(optional.isEmpty() ? "" : "v." + String.valueOf(optional.get()));
                    arrayList.add(new File(string2, string3));
                    booleanArray[i] = Boolean.TRUE;
                    continue;
                }
                booleanArray[i] = Boolean.FALSE;
            }
            ParallelFileCoypAgent parallelFileCoypAgent = new ParallelFileCoypAgent(byArray2, arrayList, booleanArray);
            parallelFileCoypAgent.setExecutor(this.getVirtualFileSystemService().getExecutorService());
            if (!parallelFileCoypAgent.execute()) {
                throw new InternalCriticalException(this.objectInfo(serverBucket, string));
            }
            arrayList.forEach(file -> this.encodedInfo.getEncodedBlocks().add(file));
            boolean bl2 = bl;
            return bl2;
        }
        catch (IOException iOException) {
            throw new InternalCriticalException((Exception)iOException, this.objectInfo(serverBucket, string));
        }
        finally {
            this.getBullferPoolService().release(byArray);
        }
    }

    protected boolean isWrite(int n) {
        return true;
    }

    protected List<Drive> getDrives() {
        return this.r6Drives;
    }

    private int getTotalShards() {
        return this.total_shards;
    }

    private int getDataShards() {
        return this.data_shards;
    }

    private int getPartityShards() {
        return this.partiy_shards;
    }
}

