/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid6;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.errors.InternalCriticalException;
import io.odilon.file.ParallelFileCoypAgent;
import io.odilon.util.Check;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.raid6.RAIDSixBlocks;
import io.odilon.virtualFileSystem.raid6.RAIDSixCoder;
import io.odilon.virtualFileSystem.raid6.RAIDSixDriver;
import io.odilon.virtualFileSystem.raid6.ReedSolomon;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Deprecated
public class RAIDSixEncoderOLD
extends RAIDSixCoder {
    @JsonIgnore
    private long fileSize = 0L;
    @JsonIgnore
    private int chunk = 0;
    @JsonIgnore
    private final int data_shards;
    @JsonIgnore
    private final int partiy_shards;
    @JsonIgnore
    private final int total_shards;
    @JsonIgnore
    private RAIDSixBlocks encodedInfo;
    @JsonIgnore
    private List<Drive> r6Drives;

    protected RAIDSixEncoderOLD(RAIDSixDriver rAIDSixDriver) {
        this(rAIDSixDriver, null);
    }

    protected RAIDSixEncoderOLD(RAIDSixDriver rAIDSixDriver, List<Drive> list) {
        super(rAIDSixDriver);
        this.r6Drives = list != null ? list : rAIDSixDriver.getDrivesAll();
        this.data_shards = this.getVirtualFileSystemService().getServerSettings().getRAID6DataDrives();
        this.partiy_shards = this.getVirtualFileSystemService().getServerSettings().getRAID6ParityDrives();
        this.total_shards = this.data_shards + this.partiy_shards;
    }

    public RAIDSixBlocks encodeHead(InputStream inputStream, ServerBucket serverBucket, String string) {
        return this.encode(inputStream, serverBucket, string, Optional.empty());
    }

    public RAIDSixBlocks encodeVersion(InputStream inputStream, ServerBucket serverBucket, String string, int n) {
        return this.encode(inputStream, serverBucket, string, Optional.of(n));
    }

    protected RAIDSixBlocks encode(InputStream inputStream, ServerBucket serverBucket, String string, Optional<Integer> optional) {
        Check.requireNonNull((Object)inputStream);
        Check.requireNonNull((Object)string);
        Check.requireNonNull((Object)serverBucket);
        if (!this.getDriver().isConfigurationValid(this.data_shards, this.partiy_shards)) {
            throw new InternalCriticalException("Incorrect configuration for RAID 6 -> data: " + String.valueOf(this.data_shards) + " | parity:" + String.valueOf(this.partiy_shards));
        }
        if (this.getDrives().size() < this.getTotalShards()) {
            throw new InternalCriticalException("There are not enough drives to encode the file in RAID 6 -> drives: " + String.valueOf(this.getDrives().size()) + " | required: " + String.valueOf(this.total_shards));
        }
        this.fileSize = 0L;
        this.chunk = 0;
        this.encodedInfo = new RAIDSixBlocks();
        boolean bl = false;
        try (InputStream inputStream2 = inputStream;){
            while (!bl) {
                bl = this.encodeChunk(inputStream, serverBucket, string, this.chunk++, optional);
            }
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, "o:" + string);
        }
        this.encodedInfo.setFileSize(this.fileSize);
        return this.encodedInfo;
    }

    public boolean encodeChunk(InputStream inputStream, ServerBucket serverBucket, String string, int n, Optional<Integer> optional) {
        int n2;
        int n3;
        byte[] byArray = new byte[0x2000000];
        int n4 = 0;
        boolean bl = false;
        try {
            n3 = 0;
            n2 = 0;
            while (n3 == 0) {
                n2 = inputStream.read(byArray, 4 + n4, 0x1FFFFFC - n4);
                if (n2 > 0) {
                    n4 += n2;
                } else {
                    bl = true;
                }
                n3 = bl || n4 == 0x1FFFFFC ? 1 : 0;
            }
        }
        catch (IOException iOException) {
            throw new InternalCriticalException((Exception)iOException, this.objectInfo(serverBucket, string));
        }
        if (n4 == 0) {
            return true;
        }
        this.fileSize += (long)n4;
        ByteBuffer.wrap(byArray).putInt(n4);
        n3 = n4 + 4;
        n2 = (n3 + this.data_shards - 1) / this.data_shards;
        int n5 = this.getTotalShards();
        int n6 = this.getDataShards();
        int n7 = this.getPartityShards();
        byte[][] byArray2 = new byte[n5][n2];
        for (int i = 0; i < n6; ++i) {
            System.arraycopy(byArray, i * n2, byArray2[i], 0, n2);
        }
        ReedSolomon reedSolomon = new ReedSolomon(n6, n7);
        reedSolomon.encodeParity(byArray2, 0, n2);
        ArrayList<File> arrayList = new ArrayList<File>();
        int n8 = this.getTotalShards();
        Boolean[] booleanArray = new Boolean[n8];
        for (int i = 0; i < this.getTotalShards(); ++i) {
            if (this.isWrite(i)) {
                String string2 = ((Drive)this.getDrives().get(i)).getBucketObjectDataDirPath(serverBucket) + (String)(optional.isEmpty() ? "" : File.separator + "version");
                String string3 = string + "." + String.valueOf(n) + "." + String.valueOf(i) + (String)(optional.isEmpty() ? "" : "v." + String.valueOf(optional.get()));
                arrayList.add(new File(string2, string3));
                booleanArray[i] = true;
                continue;
            }
            booleanArray[i] = false;
        }
        ParallelFileCoypAgent parallelFileCoypAgent = new ParallelFileCoypAgent(byArray2, arrayList, booleanArray);
        parallelFileCoypAgent.setExecutor(this.getVirtualFileSystemService().getExecutorService());
        boolean bl2 = parallelFileCoypAgent.execute();
        arrayList.forEach(file -> this.encodedInfo.getEncodedBlocks().add(file));
        if (!bl2) {
            throw new InternalCriticalException(this.objectInfo(serverBucket, string));
        }
        return bl;
    }

    protected boolean isWrite(int n) {
        return true;
    }

    protected List<Drive> getDrives() {
        return this.r6Drives;
    }

    private int getTotalShards() {
        return this.total_shards;
    }

    private int getDataShards() {
        return this.data_shards;
    }

    private int getPartityShards() {
        return this.partiy_shards;
    }
}

