/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid6;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.error.OdilonObjectNotFoundException;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.util.Check;
import io.odilon.virtualFileSystem.BaseRAIDHandler;
import io.odilon.virtualFileSystem.RAIDHandler;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import io.odilon.virtualFileSystem.raid6.RAIDSixDriver;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class RAIDSixHandler
extends BaseRAIDHandler
implements RAIDHandler {
    private static Logger logger = Logger.getLogger((String)RAIDSixHandler.class.getName());
    @JsonIgnore
    private final RAIDSixDriver driver;

    public RAIDSixHandler(RAIDSixDriver rAIDSixDriver) {
        this.driver = rAIDSixDriver;
    }

    public RAIDSixDriver getDriver() {
        return this.driver;
    }

    public VirtualFileSystemService getVirtualFileSystemService() {
        return this.getDriver().getVirtualFileSystemService();
    }

    protected void checkNotExistObject(ServerBucket serverBucket, String string) {
        if (this.existsObjectMetadata(serverBucket, string)) {
            throw new IllegalArgumentException("Object already exist -> " + this.objectInfo(serverBucket, string));
        }
    }

    protected void checkExistObject(ServerBucket serverBucket, String string) {
        if (!this.existsObjectMetadata(serverBucket, string)) {
            throw new OdilonObjectNotFoundException("Object does not exist -> " + this.objectInfo(serverBucket, string));
        }
    }

    protected boolean existsObjectMetadata(ServerBucket serverBucket, String string) {
        if (this.existsCacheObject(serverBucket, string)) {
            return true;
        }
        return this.getDriver().getObjectMetadataReadDrive(serverBucket, string).existsObjectMetadata(serverBucket, string);
    }

    protected Drive getObjectMetadataReadDrive(ServerBucket serverBucket, String string) {
        return (Drive)this.getDriver().getDrivesEnabled().get(Math.abs(this.getKey(serverBucket, string).hashCode()) % this.getDriver().getDrivesEnabled().size());
    }

    protected void saveRAIDSixObjectMetadataToDisk(List<Drive> list, List<ObjectMetadata> list2, boolean bl) {
        int n;
        if (logger.isDebugEnabled()) {
            Check.requireTrue((list.size() > 0 ? 1 : 0) != 0, (String)"no drives");
            Check.requireTrue((list.size() == list2.size() ? 1 : 0) != 0, (String)("must have the same number of elements. Drives -> " + String.valueOf(list.size()) + " - ObjectMetadata -> " + String.valueOf(list2.size())));
        }
        if ((n = list.size()) == 1) {
            try {
                ObjectMetadata objectMetadata = list2.get(0);
                if (bl) {
                    list.get(0).saveObjectMetadata(objectMetadata);
                } else {
                    list.get(0).saveObjectMetadataVersion(objectMetadata);
                }
            }
            catch (Exception exception) {
                throw new InternalCriticalException(exception);
            }
            return;
        }
        ExecutorService executorService = this.getDriver().getVirtualFileSystemService().getExecutorService();
        ArrayList<Callable<Boolean>> arrayList = new ArrayList<Callable<Boolean>>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            arrayList.add(() -> {
                ObjectMetadata objectMetadata = null;
                try {
                    objectMetadata = (ObjectMetadata)list2.get(n3);
                    if (bl) {
                        ((Drive)list.get(n3)).saveObjectMetadata(objectMetadata);
                    } else {
                        ((Drive)list.get(n3)).saveObjectMetadataVersion(objectMetadata);
                    }
                    Boolean bl2 = true;
                    return bl2;
                }
                catch (Exception exception) {
                    logger.error((Throwable)exception, new String[]{this.objectInfo(objectMetadata), "---- not thrown ----"});
                    Boolean bl3 = false;
                    return bl3;
                }
            });
        }
        try {
            List list3 = executorService.invokeAll(arrayList, 10L, TimeUnit.MINUTES);
            Iterator iterator = list3.iterator();
            while (iterator.hasNext()) {
                if (((Boolean)iterator.next().get()).booleanValue()) continue;
                throw new InternalCriticalException(ObjectMetadata.class.getSimpleName());
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new InternalCriticalException(exception, ObjectMetadata.class.getSimpleName());
        }
    }
}

