/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid6;

import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.raid6.RAIDSixDriver;
import io.odilon.virtualFileSystem.raid6.RAIDSixRollbackHandler;
import java.io.File;
import java.util.Optional;
import org.apache.commons.io.FileUtils;

public class RAIDSixRollbackCreateHandler
extends RAIDSixRollbackHandler {
    private static Logger logger = Logger.getLogger((String)RAIDSixRollbackCreateHandler.class.getName());

    public RAIDSixRollbackCreateHandler(RAIDSixDriver rAIDSixDriver, VirtualFileSystemOperation virtualFileSystemOperation, boolean bl) {
        super(rAIDSixDriver, virtualFileSystemOperation, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollback() {
        ServerBucket serverBucket = this.getBucketCache().get(this.getOperation().getBucketId());
        boolean bl = false;
        try {
            ObjectMetadata objectMetadata = null;
            for (Drive drive : this.getDriver().getDrivesAll()) {
                File file2 = drive.getObjectMetadataFile(serverBucket, this.getOperation().getObjectName());
                if (objectMetadata == null && file2 != null) {
                    try {
                        objectMetadata = drive.getObjectMetadata(serverBucket, this.getOperation().getObjectName());
                    }
                    catch (Exception exception) {
                        logger.error(new String[]{"can not load meta -> d: " + drive.getName() + "---- not thrown ----"});
                    }
                }
                FileUtils.deleteQuietly((File)new File(drive.getObjectMetadataDirPath(serverBucket, this.getOperation().getObjectName())));
            }
            if (objectMetadata != null) {
                this.getDriver().getObjectDataFiles(objectMetadata, serverBucket, Optional.empty()).forEach(file -> FileUtils.deleteQuietly((File)file));
            }
            bl = true;
        }
        catch (InternalCriticalException internalCriticalException) {
            if (!this.isRecovery()) {
                throw internalCriticalException;
            }
            logger.error((Throwable)internalCriticalException, new String[]{this.info(), "---- not thrown ----"});
        }
        catch (Exception exception) {
            if (!this.isRecovery()) {
                throw new InternalCriticalException(exception, this.info());
            }
            logger.error((Throwable)exception, new String[]{this.opInfo(this.getOperation()), "---- not thrown ----"});
        }
        finally {
            if (bl || this.isRecovery()) {
                this.getOperation().cancel();
            }
        }
    }

    private String info() {
        return this.opInfo(this.getOperation());
    }
}

