/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid6;

import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.raid6.RAIDSixDriver;
import io.odilon.virtualFileSystem.raid6.RAIDSixRollbackHandler;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class RAIDSixRollbackSyncHandler
extends RAIDSixRollbackHandler {
    private static Logger logger = Logger.getLogger((String)RAIDSixRollbackSyncHandler.class.getName());

    public RAIDSixRollbackSyncHandler(RAIDSixDriver rAIDSixDriver, VirtualFileSystemOperation virtualFileSystemOperation, boolean bl) {
        super(rAIDSixDriver, virtualFileSystemOperation, bl);
    }

    protected void rollback() {
        boolean bl = false;
        try {
            this.restore();
            bl = true;
        }
        catch (InternalCriticalException internalCriticalException) {
            if (!this.isRecovery()) {
                throw internalCriticalException;
            }
            logger.error((Throwable)internalCriticalException, new String[]{this.opInfo(this.getOperation()), "---- not thrown ----"});
        }
        catch (Exception exception) {
            if (!this.isRecovery()) {
                throw new InternalCriticalException(exception);
            }
            logger.error((Throwable)exception, new String[]{this.opInfo(this.getOperation()), "---- not thrown ----"});
        }
        finally {
            if (bl || this.isRecovery()) {
                this.getOperation().cancel();
            }
        }
    }

    private void restore() {
        ServerBucket serverBucket = this.getBucketCache().get(this.getOperation().getBucketId());
        String string = this.getOperation().getObjectName();
        try {
            for (Drive drive : this.getDriver().getDrivesEnabled()) {
                File file = new File(drive.getObjectMetadataDirPath(serverBucket, string));
                File file2 = new File(drive.getBucketWorkDirPath(serverBucket) + File.separator + string);
                if (file2.exists()) {
                    FileUtils.copyDirectory((File)file2, (File)file);
                    continue;
                }
                throw new InternalCriticalException("dir does not exist " + this.objectInfo(serverBucket, string) + " | dir:" + file2.getAbsolutePath());
            }
        }
        catch (IOException iOException) {
            throw new InternalCriticalException((Exception)iOException, this.objectInfo(serverBucket, string));
        }
    }
}

