/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid6;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.DriveStatus;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.raid6.RAIDSixDecoder;
import io.odilon.virtualFileSystem.raid6.RAIDSixDriver;
import io.odilon.virtualFileSystem.raid6.RAIDSixSDriveSyncEncoder;
import io.odilon.virtualFileSystem.raid6.RAIDSixTransactionHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FileUtils;

@ThreadSafe
public class RAIDSixSyncObjectHandler
extends RAIDSixTransactionHandler {
    private static Logger logger = Logger.getLogger((String)RAIDSixSyncObjectHandler.class.getName());
    @JsonIgnore
    private List<Drive> drives;
    @JsonIgnore
    private List<Drive> drivesToSync;

    protected RAIDSixSyncObjectHandler(RAIDSixDriver rAIDSixDriver) {
        super(rAIDSixDriver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(ObjectMetadata objectMetadata) {
        block15: {
            VirtualFileSystemOperation virtualFileSystemOperation = null;
            boolean bl = false;
            this.objectWriteLock(objectMetadata.getBucketId(), objectMetadata.getObjectName());
            try {
                this.bucketReadLock(objectMetadata.getBucketId());
                try {
                    this.checkExistsBucket(objectMetadata.getBucketId());
                    ServerBucket serverBucket = this.getBucketCache().get(objectMetadata.getBucketId());
                    this.backup(serverBucket, objectMetadata);
                    virtualFileSystemOperation = this.getJournalService().syncObject(serverBucket, objectMetadata.getObjectName());
                    this.syncHead(objectMetadata, serverBucket);
                    this.syncVersions(objectMetadata, serverBucket);
                    bl = virtualFileSystemOperation.commit();
                }
                catch (Throwable throwable) {
                    block16: {
                        try {
                            if (bl) break block16;
                            try {
                                this.rollback(virtualFileSystemOperation);
                            }
                            catch (Exception exception) {
                                throw new InternalCriticalException(exception, this.objectInfo(objectMetadata));
                            }
                        }
                        finally {
                            this.bucketReadUnLock(objectMetadata.getBucketId());
                        }
                    }
                    throw throwable;
                }
                try {
                    if (bl) break block15;
                    try {
                        this.rollback(virtualFileSystemOperation);
                    }
                    catch (Exception exception) {
                        throw new InternalCriticalException(exception, this.objectInfo(objectMetadata));
                    }
                }
                finally {
                    this.bucketReadUnLock(objectMetadata.getBucketId());
                }
            }
            finally {
                this.objectWriteUnLock(objectMetadata.getBucketId(), objectMetadata.getObjectName());
            }
        }
    }

    protected synchronized List<Drive> getDrives() {
        if (this.drives != null) {
            return this.drives;
        }
        this.drives = new ArrayList();
        this.getDriver().getDrivesAll().forEach(drive -> this.drives.add(drive));
        this.drives.sort(new /* Unavailable Anonymous Inner Class!! */);
        return this.drives;
    }

    protected synchronized List<Drive> getDrivesToSync() {
        if (this.drivesToSync != null) {
            return this.drivesToSync;
        }
        this.drivesToSync = new ArrayList();
        this.getDrives().forEach(drive -> {
            if (drive.getDriveInfo().getStatus() == DriveStatus.NOTSYNC) {
                this.drivesToSync.add(drive);
            }
        });
        return this.drivesToSync;
    }

    private void backup(ServerBucket serverBucket, ObjectMetadata objectMetadata) {
        try {
            for (Drive drive : this.getDriver().getDrivesEnabled()) {
                File file = new File(drive.getObjectMetadataDirPath(serverBucket, objectMetadata.getObjectName()));
                File file2 = new File(drive.getBucketWorkDirPath(serverBucket) + File.separator + objectMetadata.getObjectName());
                if (!file.exists()) continue;
                FileUtils.copyDirectory((File)file, (File)file2);
            }
        }
        catch (IOException iOException) {
            throw new InternalCriticalException((Exception)iOException, this.objectInfo(objectMetadata));
        }
    }

    private void syncHead(ObjectMetadata objectMetadata, ServerBucket serverBucket) {
        Object object;
        RAIDSixDecoder rAIDSixDecoder = new RAIDSixDecoder(this.getDriver());
        File file = rAIDSixDecoder.decodeHead(objectMetadata, serverBucket);
        RAIDSixSDriveSyncEncoder rAIDSixSDriveSyncEncoder = new RAIDSixSDriveSyncEncoder(this.getDriver(), this.getDrives());
        try {
            object = new BufferedInputStream(new FileInputStream(file.getAbsolutePath()));
            try {
                rAIDSixSDriveSyncEncoder.encodeHead((InputStream)object, serverBucket, objectMetadata.getObjectName());
            }
            finally {
                ((InputStream)object).close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new InternalCriticalException((Exception)fileNotFoundException, this.objectInfo(objectMetadata));
        }
        catch (IOException iOException) {
            throw new InternalCriticalException((Exception)iOException, this.objectInfo(objectMetadata));
        }
        objectMetadata.setDateSynced(OffsetDateTime.now());
        object = new ArrayList();
        this.getDrivesToSync().forEach(arg_0 -> RAIDSixSyncObjectHandler.lambda$syncHead$0((List)object, objectMetadata, arg_0));
        this.saveRAIDSixObjectMetadataToDisk(this.getDrivesToSync(), (List)object, true);
    }

    private void syncVersions(ObjectMetadata objectMetadata, ServerBucket serverBucket) {
        if (this.getDriver().getVirtualFileSystemService().getServerSettings().isVersionControl()) {
            for (int i = 0; i < objectMetadata.getVersion(); ++i) {
                ObjectMetadata objectMetadata2 = this.getDriver().getObjectMetadataReadDrive(serverBucket, objectMetadata.getObjectName()).getObjectMetadataVersion(serverBucket, objectMetadata.getObjectName(), i);
                if (objectMetadata2 != null) {
                    Object object;
                    RAIDSixDecoder rAIDSixDecoder = new RAIDSixDecoder(this.getDriver());
                    RAIDSixSDriveSyncEncoder rAIDSixSDriveSyncEncoder = new RAIDSixSDriveSyncEncoder(this.getDriver(), this.getDrives());
                    try {
                        object = new BufferedInputStream(new FileInputStream(rAIDSixDecoder.decodeVersion(objectMetadata2, serverBucket).getAbsolutePath()));
                        try {
                            rAIDSixSDriveSyncEncoder.encodeVersion((InputStream)object, serverBucket, objectMetadata.getObjectName(), objectMetadata2.getVersion());
                        }
                        finally {
                            ((InputStream)object).close();
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw new InternalCriticalException((Exception)fileNotFoundException, this.objectInfo(objectMetadata));
                    }
                    catch (IOException iOException) {
                        throw new InternalCriticalException((Exception)iOException, this.objectInfo(objectMetadata));
                    }
                    objectMetadata2.setDateSynced(OffsetDateTime.now());
                    object = new ArrayList();
                    this.getDrives().forEach(arg_0 -> RAIDSixSyncObjectHandler.lambda$syncHead$0((List)object, objectMetadata2, arg_0));
                    this.saveRAIDSixObjectMetadataToDisk(this.getDrives(), (List)object, false);
                    continue;
                }
                logger.warn(new String[]{"previous version was deleted for Object -> " + String.valueOf(i) + " |  head " + this.objectInfo(objectMetadata) + "  head version:" + String.valueOf(objectMetadata.getVersion())});
            }
        }
    }

    private static /* synthetic */ void lambda$syncHead$0(List list, ObjectMetadata objectMetadata, Drive drive) {
        list.add(objectMetadata);
    }
}

