/*
 * Decompiled with CFR 0.152.
 */
package io.odilon;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.log.Logger;
import io.odilon.model.OdilonServerInfo;
import io.odilon.model.RedundancyLevel;
import io.odilon.replication.ReplicationService;
import io.odilon.scheduler.CronJobDataIntegrityCheckRequest;
import io.odilon.scheduler.CronJobWorkDirCleanUpRequest;
import io.odilon.scheduler.PingCronJobRequest;
import io.odilon.scheduler.SchedulerService;
import io.odilon.scheduler.ServiceRequest;
import io.odilon.security.VaultService;
import io.odilon.service.ObjectStorageService;
import io.odilon.service.ServerSettings;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import java.io.File;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class OdilonStartupApplicationRunner
implements ApplicationRunner {
    private static Logger logger = Logger.getLogger((String)OdilonStartupApplicationRunner.class.getName());
    private static Logger startupLogger = Logger.getLogger((String)"StartupLogger");
    @JsonIgnore
    private final ApplicationContext appContext;
    @JsonIgnore
    @Autowired
    private final SchedulerService schedulerService;

    public OdilonStartupApplicationRunner(ApplicationContext applicationContext, SchedulerService schedulerService) {
        this.appContext = applicationContext;
        this.schedulerService = schedulerService;
    }

    public void run(ApplicationArguments applicationArguments) throws Exception {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        if (startupLogger.isDebugEnabled()) {
            startupLogger.debug("Command line args:");
            applicationArguments.getNonOptionArgs().forEach(string -> startupLogger.debug(string));
            startupLogger.debug("---------------------------------");
        }
        Locale.setDefault(Locale.ENGLISH);
        this.initCronJobs();
        boolean bl5 = this.initBaseParams();
        if (bl5) {
            startupLogger.info("---------------------------------");
        }
        if (bl4 = this.initGeneral()) {
            startupLogger.info("---------------------------------");
        }
        if (bl3 = this.initVault()) {
            startupLogger.info("---------------------------------");
        }
        if (bl2 = this.initKeys()) {
            startupLogger.info("---------------------------------");
        }
        if (bl = this.initStandby()) {
            startupLogger.info("---------------------------------");
        }
        startupLogger.info("Startup at -> " + DateTimeFormatter.RFC_1123_DATE_TIME.format(OffsetDateTime.now()));
    }

    public SchedulerService getSchedulerService() {
        return this.schedulerService;
    }

    public ApplicationContext getAppContext() {
        return this.appContext;
    }

    private void initCronJobs() {
        String string;
        ServerSettings serverSettings = (ServerSettings)this.getAppContext().getBean(ServerSettings.class);
        if (serverSettings.isIntegrityCheck()) {
            string = (CronJobDataIntegrityCheckRequest)this.appContext.getBean(CronJobDataIntegrityCheckRequest.class, new Object[]{serverSettings.getIntegrityCheckCronExpression()});
            this.getSchedulerService().enqueue((ServiceRequest)string);
            startupLogger.debug("Integrity Check -> CronExpression: " + serverSettings.getIntegrityCheckCronExpression() + " | Checking interval (days) " + String.valueOf(serverSettings.getIntegrityCheckDays()) + " | Threads " + String.valueOf(serverSettings.getIntegrityCheckThreads()));
        } else {
            startupLogger.debug("Integrity Check -> disabled");
        }
        string = serverSettings.getCronJobWorkDirCleanUp();
        CronJobWorkDirCleanUpRequest cronJobWorkDirCleanUpRequest = (CronJobWorkDirCleanUpRequest)this.getAppContext().getBean(CronJobWorkDirCleanUpRequest.class, new Object[]{string});
        this.getSchedulerService().enqueue((ServiceRequest)cronJobWorkDirCleanUpRequest);
        if (serverSettings.isPingEnabled()) {
            String string2 = serverSettings.getCronJobcronJobPing();
            PingCronJobRequest pingCronJobRequest = (PingCronJobRequest)this.getAppContext().getBean(PingCronJobRequest.class, new Object[]{string2});
            this.getSchedulerService().enqueue((ServiceRequest)pingCronJobRequest);
            startupLogger.debug("Ping -> CronExpression: " + string2);
        }
    }

    private boolean initBaseParams() {
        try {
            ObjectStorageService objectStorageService = (ObjectStorageService)this.getAppContext().getBean(ObjectStorageService.class);
            objectStorageService.getSystemInfo().getColloquial().forEach((string, string2) -> startupLogger.debug(string + " -> " + string2));
            if (startupLogger.isDebugEnabled()) {
                objectStorageService.getSystemInfo().getColloquial().forEach((string, string2) -> startupLogger.debug(string + " -> " + string2));
            } else {
                startupLogger.info("javaVendor -> " + (String)objectStorageService.getSystemInfo().getColloquial().get("javaVendor"));
                startupLogger.info("javaVersion -> " + (String)objectStorageService.getSystemInfo().getColloquial().get("javaVersion"));
                startupLogger.info("osName -> " + (String)objectStorageService.getSystemInfo().getColloquial().get("osName"));
                startupLogger.info("osArch -> " + (String)objectStorageService.getSystemInfo().getColloquial().get("osArch"));
                startupLogger.info("serverHost -> " + (String)objectStorageService.getSystemInfo().getColloquial().get("serverHost"));
                startupLogger.info("serverStorage -> " + (String)objectStorageService.getSystemInfo().getColloquial().get("serverStorage"));
                startupLogger.info("TimeZone -> " + ZoneId.systemDefault().toString());
            }
        }
        catch (Exception exception) {
            startupLogger.error((Throwable)exception, new String[]{"---- not thrown ----"});
        }
        return true;
    }

    private boolean initGeneral() {
        ServerSettings serverSettings = (ServerSettings)this.getAppContext().getBean(ServerSettings.class);
        startupLogger.info("Https -> " + (serverSettings.isHTTPS() ? "true" : "false"));
        startupLogger.info("Port-> " + String.valueOf(serverSettings.getPort()));
        OdilonServerInfo odilonServerInfo = ((VirtualFileSystemService)this.getAppContext().getBean(VirtualFileSystemService.class)).getOdilonServerInfo();
        startupLogger.info("Encryption service initialized -> " + (odilonServerInfo != null && odilonServerInfo.isEncryptionIntialized() ? "true" : "false"));
        startupLogger.info("Encryption enabled -> " + String.valueOf(serverSettings.isEncryptionEnabled()));
        startupLogger.info("Version Control -> " + String.valueOf(serverSettings.isVersionControl()));
        startupLogger.info("Data Storage mode -> " + serverSettings.getDataStorage().getName());
        if (serverSettings.getRedundancyLevel() == RedundancyLevel.RAID_6) {
            startupLogger.info("Data Storage redundancy level -> " + serverSettings.getRedundancyLevel().getName() + " [data:" + String.valueOf(serverSettings.getRAID6DataDrives()) + ", parity:" + String.valueOf(serverSettings.getRAID6ParityDrives()) + "]");
        } else {
            startupLogger.info("Data Storage redundancy level -> " + serverSettings.getRedundancyLevel().getName());
        }
        ((VirtualFileSystemService)this.getAppContext().getBean(VirtualFileSystemService.class)).getMapDrivesEnabled().forEach((string, drive) -> startupLogger.info("Drive: " + string + " | rootDir: " + drive.getRootDirPath()));
        return true;
    }

    private boolean initVault() {
        ServerSettings serverSettings = (ServerSettings)this.getAppContext().getBean(ServerSettings.class);
        boolean bl = true;
        startupLogger.info("Vault enabled -> " + String.valueOf(serverSettings.isVaultEnabled()));
        startupLogger.info("Vault use for new files if enabled -> " + String.valueOf(serverSettings.isUseVaultNewFiles()));
        if (serverSettings.isVaultEnabled()) {
            if (serverSettings.getVaultUrl().isPresent()) {
                String string = ((VaultService)this.getAppContext().getBean(VaultService.class)).ping();
                if (string == null || !string.equals("ok")) {
                    startupLogger.error(new String[0]);
                    startupLogger.error(new String[]{string});
                    startupLogger.error(new String[0]);
                    bl = false;
                } else {
                    startupLogger.info("Vault connection -> " + (String)serverSettings.getVaultUrl().get());
                    startupLogger.info("Vault connection status -> " + string);
                    bl = true;
                }
            } else {
                startupLogger.error(new String[]{"Vault is enabled but vault.url is null"});
                bl = false;
            }
            if (!bl) {
                startupLogger.error(new String[]{"The system can not run without a Vault operational"});
                startupLogger.error(new String[]{"Check variable 'vault.url' and 'vault' in -> ." + File.separator + "config" + File.separator + "odilon.properties"});
                startupLogger.error(new String[]{"Current value for vault.enabled = " + serverSettings.isVaultEnabled()});
                startupLogger.error(new String[]{"Current value for vault.newfiles = " + serverSettings.isUseVaultNewFiles()});
                startupLogger.error(new String[]{"Current value for vault.url -> " + (String)serverSettings.getVaultUrl().get()});
                startupLogger.error(new String[]{"You must set vault.enabled=false if there is no Vault available"});
                startupLogger.error(new String[]{"Vault related variables (with sample values): "});
                startupLogger.error(new String[]{"# no Vault at all, reagrdless of the other variables"});
                startupLogger.error(new String[]{"vault.enabled=false"});
                startupLogger.error(new String[]{"# What to do with new files, whether to use Vault or not"});
                startupLogger.error(new String[]{"vault.newfiles=false"});
                startupLogger.error(new String[]{"vault.url=http://127.0.0.1:8220"});
                startupLogger.error(new String[]{"vault.roleId=01aa9d05-1a0a-1392-5a90-784819064f05"});
                startupLogger.error(new String[]{"vault.secretId=xxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx"});
                startupLogger.error(new String[]{"vault.keyId=kbee-key"});
                startupLogger.error(new String[]{"Exiting"});
                startupLogger.error(new String[]{"---------------------------------"});
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ((ConfigurableApplicationContext)((VirtualFileSystemService)this.getAppContext().getBean(VirtualFileSystemService.class)).getApplicationContext()).close();
                System.exit(1);
            }
            return true;
        }
        return true;
    }

    private boolean initKeys() {
        ServerSettings serverSettings = (ServerSettings)this.getAppContext().getBean(ServerSettings.class);
        if (serverSettings.getAccessKey().equals("odilon") && serverSettings.getSecretKey().equals("odilon")) {
            startupLogger.info("Odilon is running with default vaules for AccessKey and SecretKey (ie. odilon/odilon)");
            startupLogger.info("It is recommended to change their values in file -> ." + File.separator + "config" + File.separator + "odilon.properties");
            return true;
        }
        return false;
    }

    private boolean initStandby() {
        ServerSettings serverSettings = (ServerSettings)this.getAppContext().getBean(ServerSettings.class);
        if (serverSettings.getServerMode().equals("standby")) {
            startupLogger.info("Server is running in mode -> " + serverSettings.getServerMode());
            startupLogger.info("---------------------------------");
        } else {
            ReplicationService replicationService = (ReplicationService)this.getAppContext().getBean(ReplicationService.class);
            if (serverSettings.isStandByEnabled()) {
                startupLogger.info("Standby Server -> enabled");
                startupLogger.info("Standby connection -> " + replicationService.getStandByConnection());
                String string = replicationService.pingStandBy();
                if (string.equals("ok")) {
                    startupLogger.info("Standby connection status -> " + string);
                    if (serverSettings.isVersionControl() && !replicationService.isVersionControl()) {
                        startupLogger.error(new String[]{"Server has Version Control enabled but Standby replica does not. You must either:"});
                        startupLogger.error(new String[]{"- Disable Version Control in Master Server"});
                        startupLogger.error(new String[]{"- Enable Version Control in Standby Server"});
                        startupLogger.error(new String[]{"- Disable Standby replication"});
                        startupLogger.error(new String[]{"The server can not continue."});
                        ((ConfigurableApplicationContext)((VirtualFileSystemService)this.getAppContext().getBean(VirtualFileSystemService.class)).getApplicationContext()).close();
                        System.exit(1);
                    }
                } else {
                    startupLogger.error(new String[]{"Standby connection  error -> " + string});
                    startupLogger.error(new String[]{"The server is set up to use a standby connection that is not available"});
                    startupLogger.error(new String[]{"You must check the connection or disable standby replica in file -> ." + File.separator + "config" + File.separator + "odilon.properties"});
                    startupLogger.error(new String[]{"Current value for standby.enabled -> " + serverSettings.isStandByEnabled()});
                    startupLogger.error(new String[]{"Exiting"});
                    startupLogger.error(new String[]{"---------------------------------"});
                    try {
                        Thread.sleep(2500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ((ConfigurableApplicationContext)((VirtualFileSystemService)this.getAppContext().getBean(VirtualFileSystemService.class)).getApplicationContext()).close();
                    System.exit(1);
                }
                try {
                    replicationService.checkStructure();
                }
                catch (Exception exception) {
                    logger.error(new String[]{exception.getClass().getName() + " | " + exception.getMessage()});
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    logger.error(new String[]{"You will have to check the standby server to enable replication"});
                    logger.error(new String[]{"Meanwhile we recommend to startup the server without it  in ./config/odilon.properties -> standby.enabled=false "});
                    System.exit(1);
                }
            }
        }
        return false;
    }
}

