/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.api;

import io.odilon.api.BaseApiController;
import io.odilon.log.Logger;
import io.odilon.model.SystemInfo;
import io.odilon.monitor.SystemMonitorService;
import io.odilon.service.ObjectStorageService;
import io.odilon.service.ServerSettings;
import io.odilon.traffic.TrafficControlService;
import io.odilon.traffic.TrafficPass;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class InfoController
extends BaseApiController {
    private static Logger logger = Logger.getLogger((String)InfoController.class.getName());
    private ServerSettings settings;

    @Autowired
    public InfoController(ObjectStorageService objectStorageService, VirtualFileSystemService virtualFileSystemService, SystemMonitorService systemMonitorService, ServerSettings serverSettings, TrafficControlService trafficControlService) {
        super(objectStorageService, virtualFileSystemService, systemMonitorService, trafficControlService);
        this.settings = serverSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/libraries"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<String> getLibraries() {
        ResponseEntity responseEntity;
        TrafficPass trafficPass = null;
        try {
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            StringBuilder stringBuilder = new StringBuilder();
            Map map = this.getObjectStorageService().getSystemLibrariesInfo();
            map.forEach((string, string2) -> stringBuilder.append("    " + string + " -> " + string2 + "\n"));
            stringBuilder.append("\n");
            responseEntity = new ResponseEntity((Object)stringBuilder.toString(), (HttpStatusCode)HttpStatus.OK);
        }
        catch (Throwable throwable) {
            this.getTrafficControlService().release(trafficPass);
            this.mark();
            throw throwable;
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
        return responseEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/info"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<String> getMetrics() {
        ResponseEntity responseEntity;
        TrafficPass trafficPass = null;
        try {
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            StringBuilder stringBuilder = new StringBuilder();
            SystemInfo systemInfo = this.getObjectStorageService().getSystemInfo();
            stringBuilder.append("\n");
            stringBuilder.append("\n");
            for (String string3 : this.getServerSettings().getAppCharacterName()) {
                stringBuilder.append("    " + string3 + "\n");
            }
            stringBuilder.append("\n");
            Map map = systemInfo.getColloquial();
            map.forEach((string, string2) -> stringBuilder.append("    " + string + " -> " + string2 + "\n"));
            stringBuilder.append("\n");
            responseEntity = new ResponseEntity((Object)stringBuilder.toString(), (HttpStatusCode)HttpStatus.OK);
        }
        catch (Throwable throwable) {
            this.getTrafficControlService().release(trafficPass);
            this.mark();
            throw throwable;
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
        return responseEntity;
    }

    protected ServerSettings getServerSettings() {
        return this.settings;
    }
}

