/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.api.BaseApiController;
import io.odilon.error.OdilonInternalErrorException;
import io.odilon.error.OdilonObjectNotFoundException;
import io.odilon.error.OdilonServerAPIException;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.model.ObjectStatus;
import io.odilon.monitor.SystemMonitorService;
import io.odilon.net.ErrorCode;
import io.odilon.net.ODHttpStatus;
import io.odilon.security.AuthToken;
import io.odilon.security.TokenService;
import io.odilon.service.ObjectStorageService;
import io.odilon.service.ServerSettings;
import io.odilon.traffic.TrafficControlService;
import io.odilon.traffic.TrafficPass;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/object"})
public class ObjectController
extends BaseApiController {
    private static Logger logger = Logger.getLogger((String)ObjectController.class.getName());
    @JsonIgnore
    @Autowired
    private final TokenService tokenService;
    @JsonIgnore
    @Autowired
    private final ServerSettings settings;

    public ObjectController(ObjectStorageService objectStorageService, VirtualFileSystemService virtualFileSystemService, SystemMonitorService systemMonitorService, TrafficControlService trafficControlService, TokenService tokenService, ServerSettings serverSettings) {
        super(objectStorageService, virtualFileSystemService, systemMonitorService, trafficControlService);
        this.tokenService = tokenService;
        this.settings = serverSettings;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/exists/{bucketName}/{objectName}"}, method={RequestMethod.GET})
    public ResponseEntity<Boolean> exists(@PathVariable(value="bucketName") String string, @PathVariable(value="objectName") String string2) {
        ResponseEntity responseEntity;
        TrafficPass trafficPass;
        block6: {
            trafficPass = null;
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            if (this.getObjectStorageService().existsBucket(string)) break block6;
            ResponseEntity responseEntity2 = new ResponseEntity((Object)false, (HttpStatusCode)HttpStatus.OK);
            this.getTrafficControlService().release(trafficPass);
            this.mark();
            return responseEntity2;
        }
        try {
            responseEntity = new ResponseEntity((Object)(this.getObjectStorageService().existsObject(string, string2) ? 1 : 0), (HttpStatusCode)HttpStatus.OK);
        }
        catch (OdilonServerAPIException odilonServerAPIException) {
            try {
                throw odilonServerAPIException;
                catch (Exception exception) {
                    throw new OdilonInternalErrorException(this.getMessage((Throwable)exception));
                }
            }
            catch (Throwable throwable) {
                this.getTrafficControlService().release(trafficPass);
                this.mark();
                throw throwable;
            }
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
        return responseEntity;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/hasversions/{bucketName}/{objectName}"}, method={RequestMethod.GET})
    public ResponseEntity<Boolean> hasVersions(@PathVariable(value="bucketName") String string, @PathVariable(value="objectName") String string2) {
        ResponseEntity responseEntity;
        TrafficPass trafficPass = null;
        try {
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            if (!this.getVirtualFileSystemService().getServerSettings().isVersionControl()) {
                throw new OdilonServerAPIException(ODHttpStatus.METHOD_NOT_ALLOWED, ErrorCode.API_NOT_ENABLED, new String[]{"Version Control not enabled"});
            }
            if (!this.getObjectStorageService().existsObject(string, string2)) {
                throw new OdilonObjectNotFoundException(String.format("Object not Ffund -> b: %s | o:%s", Optional.ofNullable(string).orElse("null"), Optional.ofNullable(string2).orElse("null")));
            }
            responseEntity = new ResponseEntity((Object)(this.getObjectStorageService().hasVersions(string, string2) ? 1 : 0), (HttpStatusCode)HttpStatus.OK);
        }
        catch (OdilonServerAPIException odilonServerAPIException) {
            try {
                throw odilonServerAPIException;
                catch (Exception exception) {
                    throw new OdilonInternalErrorException(this.getMessage((Throwable)exception));
                }
            }
            catch (Throwable throwable) {
                this.getTrafficControlService().release(trafficPass);
                this.mark();
                throw throwable;
            }
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
        return responseEntity;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(path={"/get/{bucketName}/{objectName}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<InputStreamResource> getObjectStream(@PathVariable(value="bucketName") String string, @PathVariable(value="objectName") String string2) {
        ResponseEntity responseEntity;
        HttpHeaders httpHeaders;
        int n;
        long l;
        MediaType mediaType;
        InputStream inputStream;
        TrafficPass trafficPass;
        block15: {
            trafficPass = null;
            inputStream = null;
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            if (!this.getObjectStorageService().existsObject(string, string2)) {
                throw new OdilonObjectNotFoundException(String.format("object not found -> b: %s | o:%s", Optional.ofNullable(string).orElse("null"), Optional.ofNullable(string2).orElse("null")));
            }
            ObjectMetadata objectMetadata = this.getObjectStorageService().getObjectMetadata(string, string2);
            if (objectMetadata == null || objectMetadata.status == ObjectStatus.DELETED || objectMetadata.status == ObjectStatus.DRAFT) {
                throw new OdilonObjectNotFoundException(String.format("object not found -> b: %s | o:%s", Optional.ofNullable(string).orElse("null"), Optional.ofNullable(string2).orElse("null")));
            }
            if (objectMetadata.getFileName() != null && objectMetadata.getFileName().toLowerCase().endsWith(".svg")) {
                objectMetadata.setContentType("image/svg+xml");
            }
            mediaType = MediaType.valueOf((String)objectMetadata.getContentType());
            if (objectMetadata.contentType() == null || objectMetadata.getContentType().equals("application/octet-stream")) {
                mediaType = this.estimateContentType(objectMetadata.getFileName());
            }
            l = this.getSrcFileLength(objectMetadata);
            inputStream = this.getObjectStorageService().getObjectStream(string, string2);
            n = this.settings.getserverObjectstreamCacheSecs();
            this.getSystemMonitorService().getGetObjectMeter().mark();
            httpHeaders = new HttpHeaders();
            String string3 = objectMetadata.getFileName().replace("[", "").replace("]", "");
            httpHeaders.set("Content-Disposition", "inline; filename=\"" + string3 + "\"");
            httpHeaders.set("Accept-Ranges", "bytes");
            if (l != -1L) break block15;
            ResponseEntity responseEntity2 = ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(httpHeaders)).cacheControl(CacheControl.maxAge((long)n, (TimeUnit)TimeUnit.SECONDS))).contentType(mediaType).body((Object)new InputStreamResource(inputStream));
            this.getTrafficControlService().release(trafficPass);
            this.mark();
            return responseEntity2;
        }
        try {
            responseEntity = ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(httpHeaders)).cacheControl(CacheControl.maxAge((long)n, (TimeUnit)TimeUnit.SECONDS))).contentType(mediaType).contentLength(l).body((Object)new InputStreamResource(inputStream));
        }
        catch (OdilonServerAPIException odilonServerAPIException) {
            try {
                if (inputStream == null) throw odilonServerAPIException;
                try {
                    inputStream.close();
                    throw odilonServerAPIException;
                }
                catch (IOException iOException) {
                    logger.error((Throwable)iOException, new String[]{"---- not thrown ----"});
                }
                throw odilonServerAPIException;
                catch (Exception exception) {
                    if (inputStream == null) throw new OdilonServerAPIException(ODHttpStatus.INTERNAL_SERVER_ERROR, ErrorCode.INTERNAL_ERROR, new String[]{this.getMessage((Throwable)exception)});
                    try {
                        inputStream.close();
                        throw new OdilonServerAPIException(ODHttpStatus.INTERNAL_SERVER_ERROR, ErrorCode.INTERNAL_ERROR, new String[]{this.getMessage((Throwable)exception)});
                    }
                    catch (IOException iOException) {
                        logger.error((Throwable)iOException, new String[]{"---- not thrown ----"});
                    }
                    throw new OdilonServerAPIException(ODHttpStatus.INTERNAL_SERVER_ERROR, ErrorCode.INTERNAL_ERROR, new String[]{this.getMessage((Throwable)exception)});
                }
            }
            catch (Throwable throwable) {
                this.getTrafficControlService().release(trafficPass);
                this.mark();
                throw throwable;
            }
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
        return responseEntity;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(path={"/getversion/{bucketName}/{objectName}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<InputStreamResource> getObjectVersionStream(@PathVariable(value="bucketName") String string, @PathVariable(value="objectName") String string2, @RequestParam(value="version") Optional<Integer> optional) {
        ResponseEntity responseEntity;
        HttpHeaders httpHeaders;
        long l;
        int n;
        MediaType mediaType;
        InputStream inputStream;
        TrafficPass trafficPass;
        block22: {
            trafficPass = null;
            inputStream = null;
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            if (!this.getVirtualFileSystemService().getServerSettings().isVersionControl()) {
                throw new OdilonServerAPIException(ODHttpStatus.METHOD_NOT_ALLOWED, ErrorCode.API_NOT_ENABLED, new String[]{"Version Control not enabled"});
            }
            if (!this.getObjectStorageService().existsObject(string, string2)) {
                throw new OdilonObjectNotFoundException(String.format("object not found -> b: %s | o:%s", Optional.ofNullable(string).orElse("null"), Optional.ofNullable(string2).orElse("null")));
            }
            ObjectMetadata objectMetadata = this.getObjectStorageService().getObjectMetadata(string, string2);
            if (objectMetadata == null || objectMetadata.status == ObjectStatus.DELETED || objectMetadata.status == ObjectStatus.DRAFT) {
                throw new OdilonObjectNotFoundException(String.format("object not found -> b: %s | o:%s", Optional.ofNullable(string).orElse("null"), Optional.ofNullable(string2).orElse("null")));
            }
            if (objectMetadata.version == 0) {
                throw new OdilonObjectNotFoundException(String.format("object version not found", new Object[0]));
            }
            List list = this.getObjectStorageService().getObjectMetadataAllPreviousVersions(string, string2);
            if (list == null) throw new OdilonObjectNotFoundException(String.format("object version not found", new Object[0]));
            if (list.isEmpty()) {
                throw new OdilonObjectNotFoundException(String.format("object version not found", new Object[0]));
            }
            if (optional.isEmpty()) {
                throw new IllegalArgumentException("version can not be null");
            }
            if (optional.get() < 0) {
                throw new IllegalArgumentException("version must be 0 or greater");
            }
            ObjectMetadata objectMetadata2 = null;
            for (ObjectMetadata objectMetadata3 : list) {
                if (objectMetadata3.getVersion() != optional.get().intValue()) continue;
                objectMetadata2 = objectMetadata3;
                break;
            }
            if (objectMetadata2 == null) {
                throw new OdilonObjectNotFoundException(String.format("object version not found", new Object[0]));
            }
            this.getSystemMonitorService().getGetObjectMeter().mark();
            if (objectMetadata2.getFileName() != null && objectMetadata2.getFileName().toLowerCase().endsWith(".svg")) {
                objectMetadata2.setContentType("image/svg+xml");
            }
            mediaType = MediaType.valueOf((String)objectMetadata2.getContentType());
            if (objectMetadata2.contentType() == null || objectMetadata2.getContentType().equals("application/octet-stream")) {
                mediaType = this.estimateContentType(objectMetadata2.getFileName());
            }
            inputStream = this.getObjectStorageService().getObjectPreviousVersionStream(string, string2, objectMetadata2.version);
            n = this.settings.getserverObjectstreamCacheSecs();
            l = super.getSrcFileLength(objectMetadata2);
            httpHeaders = new HttpHeaders();
            String string3 = objectMetadata2.getFileName().replace("[", "").replace("]", "");
            httpHeaders.set("Content-Disposition", "inline; filename=\"" + string3 + "\"");
            httpHeaders.set("Accept-Ranges", "bytes");
            if (l != -1L) break block22;
            ResponseEntity responseEntity2 = ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(httpHeaders)).cacheControl(CacheControl.maxAge((long)n, (TimeUnit)TimeUnit.SECONDS))).contentType(mediaType).body((Object)new InputStreamResource(inputStream));
            this.getTrafficControlService().release(trafficPass);
            this.mark();
            return responseEntity2;
        }
        try {
            responseEntity = ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(httpHeaders)).cacheControl(CacheControl.maxAge((long)n, (TimeUnit)TimeUnit.SECONDS))).contentType(mediaType).contentLength(l).body((Object)new InputStreamResource(inputStream));
        }
        catch (OdilonServerAPIException odilonServerAPIException) {
            try {
                if (inputStream == null) throw odilonServerAPIException;
                try {
                    inputStream.close();
                    throw odilonServerAPIException;
                }
                catch (IOException iOException) {
                    logger.error((Throwable)iOException, new String[]{"---- not thrown ----"});
                }
                throw odilonServerAPIException;
                catch (Exception exception) {
                    if (inputStream == null) throw new OdilonServerAPIException(ODHttpStatus.INTERNAL_SERVER_ERROR, ErrorCode.INTERNAL_ERROR, new String[]{this.getMessage((Throwable)exception)});
                    try {
                        inputStream.close();
                        throw new OdilonServerAPIException(ODHttpStatus.INTERNAL_SERVER_ERROR, ErrorCode.INTERNAL_ERROR, new String[]{this.getMessage((Throwable)exception)});
                    }
                    catch (IOException iOException) {
                        logger.error((Throwable)iOException, new String[]{"---- not thrown ----"});
                    }
                    throw new OdilonServerAPIException(ODHttpStatus.INTERNAL_SERVER_ERROR, ErrorCode.INTERNAL_ERROR, new String[]{this.getMessage((Throwable)exception)});
                }
            }
            catch (Throwable throwable) {
                this.getTrafficControlService().release(trafficPass);
                this.mark();
                throw throwable;
            }
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
        return responseEntity;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(path={"/getpreviousversion/{bucketName}/{objectName}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<InputStreamResource> getObjectPreviousVersionStream(@PathVariable(value="bucketName") String string, @PathVariable(value="objectName") String string2) {
        ResponseEntity responseEntity;
        HttpHeaders httpHeaders;
        long l;
        int n;
        MediaType mediaType;
        InputStream inputStream;
        TrafficPass trafficPass;
        block18: {
            trafficPass = null;
            inputStream = null;
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            if (!this.getVirtualFileSystemService().getServerSettings().isVersionControl()) {
                throw new OdilonServerAPIException(ODHttpStatus.METHOD_NOT_ALLOWED, ErrorCode.API_NOT_ENABLED, new String[]{"Version Control not enabled"});
            }
            if (!this.getObjectStorageService().existsObject(string, string2)) {
                throw new OdilonObjectNotFoundException(String.format("object not found -> b: %s | o:%s", Optional.ofNullable(string).orElse("null"), Optional.ofNullable(string2).orElse("null")));
            }
            ObjectMetadata objectMetadata = this.getObjectStorageService().getObjectMetadata(string, string2);
            if (objectMetadata == null || objectMetadata.status == ObjectStatus.DELETED || objectMetadata.status == ObjectStatus.DRAFT) {
                throw new OdilonObjectNotFoundException(String.format("object not found -> b: %s | o:%s", Optional.ofNullable(string).orElse("null"), Optional.ofNullable(string2).orElse("null")));
            }
            if (objectMetadata.version == 0) {
                throw new OdilonObjectNotFoundException(String.format("object version not found", new Object[0]));
            }
            this.getSystemMonitorService().getGetObjectMeter().mark();
            ObjectMetadata objectMetadata2 = this.getObjectStorageService().getObjectMetadataPreviousVersion(string, string2);
            if (objectMetadata2.getFileName() != null && objectMetadata2.getFileName().toLowerCase().endsWith(".svg")) {
                objectMetadata2.setContentType("image/svg+xml");
            }
            mediaType = MediaType.valueOf((String)objectMetadata2.getContentType());
            if (objectMetadata2.contentType() == null || objectMetadata2.getContentType().equals("application/octet-stream")) {
                mediaType = this.estimateContentType(objectMetadata2.getFileName());
            }
            inputStream = this.getObjectStorageService().getObjectPreviousVersionStream(string, string2, objectMetadata2.version);
            n = this.settings.getserverObjectstreamCacheSecs();
            l = super.getSrcFileLength(objectMetadata2);
            httpHeaders = new HttpHeaders();
            String string3 = objectMetadata2.getFileName().replace("[", "").replace("]", "");
            httpHeaders.set("Content-Disposition", "inline; filename=\"" + string3 + "\"");
            httpHeaders.set("Accept-Ranges", "bytes");
            if (l != -1L) break block18;
            ResponseEntity responseEntity2 = ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(httpHeaders)).cacheControl(CacheControl.maxAge((long)n, (TimeUnit)TimeUnit.SECONDS))).contentType(mediaType).body((Object)new InputStreamResource(inputStream));
            this.getTrafficControlService().release(trafficPass);
            this.mark();
            return responseEntity2;
        }
        try {
            responseEntity = ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(httpHeaders)).cacheControl(CacheControl.maxAge((long)n, (TimeUnit)TimeUnit.SECONDS))).contentType(mediaType).contentLength(l).body((Object)new InputStreamResource(inputStream));
        }
        catch (OdilonServerAPIException odilonServerAPIException) {
            try {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        logger.error((Throwable)iOException, new String[]{"---- not thrown ----"});
                    }
                }
                logger.error((Throwable)odilonServerAPIException);
                throw odilonServerAPIException;
                catch (Exception exception) {
                    if (inputStream == null) throw new OdilonServerAPIException(ODHttpStatus.INTERNAL_SERVER_ERROR, ErrorCode.INTERNAL_ERROR, new String[]{this.getMessage((Throwable)exception)});
                    try {
                        inputStream.close();
                        throw new OdilonServerAPIException(ODHttpStatus.INTERNAL_SERVER_ERROR, ErrorCode.INTERNAL_ERROR, new String[]{this.getMessage((Throwable)exception)});
                    }
                    catch (IOException iOException) {
                        logger.error((Throwable)iOException, new String[]{"---- not thrown ----"});
                    }
                    throw new OdilonServerAPIException(ODHttpStatus.INTERNAL_SERVER_ERROR, ErrorCode.INTERNAL_ERROR, new String[]{this.getMessage((Throwable)exception)});
                }
            }
            catch (Throwable throwable) {
                this.getTrafficControlService().release(trafficPass);
                this.mark();
                throw throwable;
            }
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
        return responseEntity;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(path={"/get/presignedurl/{bucketName}/{objectName}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<String> getPresignedUrl(@PathVariable(value="bucketName") String string, @PathVariable(value="objectName") String string2, @RequestParam(value="durationSeconds") Optional<Integer> optional, @RequestParam(value="objectCacheExpiresSeconds") Optional<Integer> optional2) {
        ResponseEntity responseEntity;
        TrafficPass trafficPass = null;
        try {
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            if (!this.getObjectStorageService().existsObject(string, string2)) {
                throw new OdilonObjectNotFoundException(String.format("object not found -> b: %s | o:%s", Optional.ofNullable(string).orElse("null"), Optional.ofNullable(string2).orElse("null")));
            }
            ObjectMetadata objectMetadata = this.getObjectStorageService().getObjectMetadata(string, string2);
            if (objectMetadata == null || objectMetadata.status == ObjectStatus.DELETED || objectMetadata.status == ObjectStatus.DRAFT) {
                throw new OdilonObjectNotFoundException(String.format("object not found -> b: %s | o:%s", Optional.ofNullable(string).orElse("null"), Optional.ofNullable(string2).orElse("null")));
            }
            AuthToken authToken = null;
            authToken = optional.isPresent() ? new AuthToken(string, string2, optional.get().intValue()) : new AuthToken(string, string2);
            if (optional2.isPresent()) {
                authToken.setObjectCacheDurationSecs(optional2.get().intValue());
            } else {
                authToken.setObjectCacheDurationSecs(0);
            }
            String string3 = this.getTokenService().encrypt(authToken);
            this.getSystemMonitorService().getGetObjectMeter().mark();
            responseEntity = ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body((Object)string3);
        }
        catch (OdilonServerAPIException odilonServerAPIException) {
            try {
                throw odilonServerAPIException;
                catch (Exception exception) {
                    throw new OdilonServerAPIException(ODHttpStatus.INTERNAL_SERVER_ERROR, ErrorCode.INTERNAL_ERROR, new String[]{this.getMessage((Throwable)exception)});
                }
            }
            catch (Throwable throwable) {
                this.getTrafficControlService().release(trafficPass);
                this.mark();
                throw throwable;
            }
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
        return responseEntity;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(path={"/getmetadata/{bucketName}/{objectName}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<ObjectMetadata> getObjectMetadata(@PathVariable(value="bucketName") String string, @PathVariable(value="objectName") String string2) {
        ResponseEntity responseEntity;
        TrafficPass trafficPass = null;
        try {
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            ObjectMetadata objectMetadata = this.getObjectStorageService().getObjectMetadata(string, string2);
            if (objectMetadata == null || objectMetadata.status == ObjectStatus.DELETED || objectMetadata.status == ObjectStatus.DRAFT) {
                throw new OdilonObjectNotFoundException(String.format("object not found -> b: %s | o:%s", Optional.ofNullable(string).orElse("null"), Optional.ofNullable(string2).orElse("null")));
            }
            this.getSystemMonitorService().getGetObjectMeter().mark();
            responseEntity = ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body((Object)objectMetadata);
        }
        catch (OdilonServerAPIException odilonServerAPIException) {
            try {
                throw odilonServerAPIException;
                catch (Exception exception) {
                    throw new OdilonServerAPIException(ODHttpStatus.INTERNAL_SERVER_ERROR, ErrorCode.INTERNAL_ERROR, new String[]{this.getMessage((Throwable)exception)});
                }
            }
            catch (Throwable throwable) {
                this.getTrafficControlService().release(trafficPass);
                this.mark();
                throw throwable;
            }
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
        return responseEntity;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(path={"/getmetadatapreviousversion/{bucketName}/{objectName}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<ObjectMetadata> getObjectMetadataPreviousVersion(@PathVariable(value="bucketName") String string, @PathVariable(value="objectName") String string2) {
        ResponseEntity responseEntity;
        TrafficPass trafficPass = null;
        try {
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            if (!this.getVirtualFileSystemService().getServerSettings().isVersionControl()) {
                throw new OdilonServerAPIException(ODHttpStatus.METHOD_NOT_ALLOWED, ErrorCode.API_NOT_ENABLED, new String[]{"Version Control not enabled"});
            }
            ObjectMetadata objectMetadata = this.getObjectStorageService().getObjectMetadataPreviousVersion(string, string2);
            if (objectMetadata == null || objectMetadata.status == ObjectStatus.DELETED || objectMetadata.status == ObjectStatus.DRAFT) {
                throw new OdilonObjectNotFoundException(String.format("object not found -> b: %s | o:%s", Optional.ofNullable(string).orElse("null"), Optional.ofNullable(string2).orElse("null")));
            }
            this.getSystemMonitorService().getGetObjectMeter().mark();
            responseEntity = ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body((Object)objectMetadata);
        }
        catch (OdilonServerAPIException odilonServerAPIException) {
            try {
                throw odilonServerAPIException;
                catch (Exception exception) {
                    throw new OdilonServerAPIException(ODHttpStatus.INTERNAL_SERVER_ERROR, ErrorCode.INTERNAL_ERROR, new String[]{this.getMessage((Throwable)exception)});
                }
            }
            catch (Throwable throwable) {
                this.getTrafficControlService().release(trafficPass);
                this.mark();
                throw throwable;
            }
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
        return responseEntity;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(path={"/getmetadatapreviousversionall/{bucketName}/{objectName}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<List<ObjectMetadata>> getObjectMetadataAllPreviousVersion(@PathVariable(value="bucketName") String string, @PathVariable(value="objectName") String string2) {
        ResponseEntity responseEntity;
        TrafficPass trafficPass = null;
        try {
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            if (!this.getVirtualFileSystemService().getServerSettings().isVersionControl()) {
                throw new OdilonServerAPIException(ODHttpStatus.METHOD_NOT_ALLOWED, ErrorCode.API_NOT_ENABLED, new String[]{"Version Control not enabled"});
            }
            ObjectMetadata objectMetadata = this.getObjectStorageService().getObjectMetadataPreviousVersion(string, string2);
            if (objectMetadata == null || objectMetadata.status == ObjectStatus.DELETED || objectMetadata.status == ObjectStatus.DRAFT) {
                throw new OdilonObjectNotFoundException(String.format("object not found -> b: %s | o:%s", Optional.ofNullable(string).orElse("null"), Optional.ofNullable(string2).orElse("null")));
            }
            List list = this.getObjectStorageService().getObjectMetadataAllPreviousVersions(string, string2);
            this.getSystemMonitorService().getGetObjectMeter().mark();
            responseEntity = new ResponseEntity((Object)list, (HttpStatusCode)HttpStatus.OK);
        }
        catch (OdilonServerAPIException odilonServerAPIException) {
            try {
                throw odilonServerAPIException;
                catch (Exception exception) {
                    logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                    throw new OdilonServerAPIException(ODHttpStatus.INTERNAL_SERVER_ERROR, ErrorCode.INTERNAL_ERROR, new String[]{this.getMessage((Throwable)exception)});
                }
            }
            catch (Throwable throwable) {
                this.getTrafficControlService().release(trafficPass);
                this.mark();
                throw throwable;
            }
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
        return responseEntity;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(path={"/delete/{bucketName}/{objectName}"}, method={RequestMethod.DELETE})
    public void deleteObject(@PathVariable(value="bucketName") String string, @PathVariable(value="objectName") String string2) {
        TrafficPass trafficPass = null;
        try {
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            if (!this.getObjectStorageService().existsObject(string, string2)) {
                throw new OdilonObjectNotFoundException(String.format("object not found -> b: %s | o:%s", Optional.ofNullable(string).orElse("null"), Optional.ofNullable(string2).orElse("null")));
            }
            this.getObjectStorageService().deleteObject(string, string2);
            this.getSystemMonitorService().getDeleteObjectCounter().inc();
        }
        catch (OdilonServerAPIException odilonServerAPIException) {
            try {
                throw odilonServerAPIException;
                catch (Exception exception) {
                    throw new OdilonServerAPIException(ODHttpStatus.INTERNAL_SERVER_ERROR, ErrorCode.INTERNAL_ERROR, new String[]{this.getMessage((Throwable)exception)});
                }
            }
            catch (Throwable throwable) {
                this.getTrafficControlService().release(trafficPass);
                this.mark();
                throw throwable;
            }
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
    }

    @RequestMapping(path={"/deleteallpreviousversion/{bucketName}/{objectName}"}, method={RequestMethod.DELETE})
    public void deleteObjectAllPreviousVersion(@PathVariable(value="bucketName") String string, @PathVariable(value="objectName") String string2) {
        TrafficPass trafficPass = null;
        try {
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            if (!this.getVirtualFileSystemService().getServerSettings().isVersionControl()) {
                throw new OdilonServerAPIException(ODHttpStatus.METHOD_NOT_ALLOWED, ErrorCode.API_NOT_ENABLED, new String[]{"Version Control not enabled"});
            }
            this.getObjectStorageService().deleteObjectAllPreviousVersions(string, string2);
            this.getSystemMonitorService().getObjectDeleteAllVersionsCounter().inc();
        }
        catch (OdilonServerAPIException odilonServerAPIException) {
            throw odilonServerAPIException;
        }
        catch (Exception exception) {
            throw new OdilonServerAPIException(ODHttpStatus.INTERNAL_SERVER_ERROR, ErrorCode.INTERNAL_ERROR, new String[]{this.getMessage((Throwable)exception)});
        }
        finally {
            if (trafficPass != null) {
                this.getTrafficControlService().release(trafficPass);
            }
            this.mark();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(path={"/restorepreviousversion/{bucketName}/{objectName}"}, method={RequestMethod.POST})
    public void restorePreviousVersion(@PathVariable(value="bucketName") String string, @PathVariable(value="objectName") String string2) {
        TrafficPass trafficPass = null;
        try {
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            if (!this.getVirtualFileSystemService().getServerSettings().isVersionControl()) {
                throw new OdilonServerAPIException(ODHttpStatus.METHOD_NOT_ALLOWED, ErrorCode.API_NOT_ENABLED, new String[]{"Version Control not enabled"});
            }
            if (!this.getObjectStorageService().existsObject(string, string2)) {
                throw new OdilonObjectNotFoundException(String.format("object not found -> b: %s | o:%s", Optional.ofNullable(string).orElse("null"), Optional.ofNullable(string2).orElse("null")));
            }
            ObjectMetadata objectMetadata = this.getObjectStorageService().getObjectMetadata(string, string2);
            if (objectMetadata == null || objectMetadata.status == ObjectStatus.DELETED || objectMetadata.status == ObjectStatus.DRAFT) {
                throw new OdilonObjectNotFoundException(String.format("object not found -> b: %s | o:%s", Optional.ofNullable(string).orElse("null"), Optional.ofNullable(string2).orElse("null")));
            }
            if (objectMetadata.version == 0) {
                throw new OdilonObjectNotFoundException(String.format("Object has no previous version -> b:" + string + " o:" + string2, new Object[0]));
            }
            this.getObjectStorageService().restorePreviousVersion(string, string2);
            this.getSystemMonitorService().getObjectRestorePreviousVersionCounter().inc();
        }
        catch (OdilonServerAPIException odilonServerAPIException) {
            try {
                throw odilonServerAPIException;
                catch (Exception exception) {
                    throw new OdilonServerAPIException(ODHttpStatus.INTERNAL_SERVER_ERROR, ErrorCode.INTERNAL_ERROR, new String[]{this.getMessage((Throwable)exception)});
                }
            }
            catch (Throwable throwable) {
                this.getTrafficControlService().release(trafficPass);
                this.mark();
                throw throwable;
            }
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(path={"/upload/{bucketName}/{objectName}"})
    @ResponseBody
    public ResponseEntity<ObjectMetadata> putObject(@PathVariable(value="bucketName") String string, @PathVariable(value="objectName") String string2, @RequestParam(value="file") MultipartFile multipartFile, @RequestParam(value="fileName") Optional<String> optional, @RequestParam(value="Content-Type") String string3, @RequestParam(value="version") Optional<Integer> optional2, @RequestParam(value="customTags") Optional<String> optional3) {
        ResponseEntity responseEntity;
        TrafficPass trafficPass = null;
        try {
            ObjectMetadata objectMetadata;
            Optional<Object> optional4;
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            String string4 = Optional.ofNullable(optional.get()).orElseGet(() -> string2);
            if (optional3.isPresent()) {
                String[] stringArray;
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string5 : stringArray = optional3.get().split("||")) {
                    arrayList.add(string5);
                }
                optional4 = Optional.ofNullable(arrayList);
            } else {
                optional4 = Optional.empty();
            }
            if (optional2.isEmpty()) {
                long l = System.currentTimeMillis();
                this.getObjectStorageService().putObject(string, string2, multipartFile.getInputStream(), string4, string3, optional4);
                long l2 = System.currentTimeMillis();
                objectMetadata = this.getObjectStorageService().getObjectMetadata(string, string2);
                logger.debug("putObject -> b: " + string + " | o: " + string2 + " | " + String.valueOf(l2 - l) + " ms |  length: " + String.valueOf(objectMetadata.getSourceLength() / 1000L) + " KB");
            } else {
                objectMetadata = this.getObjectStorageService().getObjectMetadataPreviousVersion(string, string2, optional2.get().intValue());
                if (objectMetadata != null) {
                    throw new OdilonServerAPIException(ODHttpStatus.METHOD_NOT_ALLOWED, ErrorCode.INTERNAL_ERROR, new String[]{"version update not done"});
                }
            }
            this.getSystemMonitorService().getPutObjectMeter().mark();
            responseEntity = ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body((Object)objectMetadata);
        }
        catch (IllegalStateException illegalStateException) {
            try {
                throw new OdilonServerAPIException(ODHttpStatus.METHOD_NOT_ALLOWED, ErrorCode.DATA_STORAGE_MODE_OPERATION_NOT_ALLOWED, new String[]{this.getMessage((Throwable)illegalStateException)});
                catch (OdilonServerAPIException odilonServerAPIException) {
                    throw odilonServerAPIException;
                }
                catch (Exception exception) {
                    throw new OdilonServerAPIException(ODHttpStatus.INTERNAL_SERVER_ERROR, ErrorCode.INTERNAL_ERROR, new String[]{this.getMessage((Throwable)exception)});
                }
            }
            catch (Throwable throwable) {
                this.getTrafficControlService().release(trafficPass);
                this.mark();
                throw throwable;
            }
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
        return responseEntity;
    }

    @PostConstruct
    public void init() {
    }

    private TokenService getTokenService() {
        return this.tokenService;
    }
}

