/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.api;

import io.odilon.error.OdilonServerAPIException;
import io.odilon.errors.OdilonErrorProxy;
import io.odilon.log.Logger;
import io.odilon.net.ErrorCode;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.multipart.MultipartException;

@ControllerAdvice
public class OdilonExceptionAdvice {
    private static Logger logger = Logger.getLogger((String)OdilonExceptionAdvice.class.getName());

    @ExceptionHandler(value={OdilonServerAPIException.class})
    public ResponseEntity<OdilonErrorProxy> odilonExceptionHandler(OdilonServerAPIException odilonServerAPIException) {
        ResponseEntity responseEntity = new ResponseEntity((Object)new OdilonErrorProxy(odilonServerAPIException.getHttpsStatus(), odilonServerAPIException.getErrorCode(), odilonServerAPIException.getErrorMessage()), (HttpStatusCode)HttpStatus.valueOf((int)odilonServerAPIException.getHttpsStatus()));
        return responseEntity;
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<OdilonErrorProxy> handle(Exception exception) {
        logger.debug("Server error -> " + exception.getClass().getName() + " | msg: " + exception.getMessage() + " | cause: " + String.valueOf(exception.getCause()));
        if (exception instanceof NullPointerException) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        OdilonErrorProxy odilonErrorProxy = exception instanceof MultipartException ? new OdilonErrorProxy(HttpStatus.INTERNAL_SERVER_ERROR.value(), ErrorCode.INTERNAL_MULTIPART_ERROR.value(), exception.getClass().getName() + " | msg: " + exception.getMessage() + " | cause: " + String.valueOf(exception.getCause())) : new OdilonErrorProxy(HttpStatus.INTERNAL_SERVER_ERROR.value(), ErrorCode.INTERNAL_ERROR.value(), exception.getClass().getName() + " | " + exception.getMessage());
        ResponseEntity responseEntity = new ResponseEntity((Object)odilonErrorProxy, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        return responseEntity;
    }
}

