/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.api;

import io.odilon.api.BaseApiController;
import io.odilon.error.OdilonInternalErrorException;
import io.odilon.error.OdilonObjectNotFoundException;
import io.odilon.error.OdilonServerAPIException;
import io.odilon.monitor.SystemMonitorService;
import io.odilon.net.ErrorCode;
import io.odilon.scheduler.SchedulerService;
import io.odilon.scheduler.ServiceRequest;
import io.odilon.scheduler.TestServiceRequest;
import io.odilon.service.ObjectStorageService;
import io.odilon.traffic.TrafficControlService;
import io.odilon.traffic.TrafficPass;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servicerequest"})
public class RequestController
extends BaseApiController {
    @Autowired
    private SchedulerService schedulerService;

    @Autowired
    public RequestController(ObjectStorageService objectStorageService, VirtualFileSystemService virtualFileSystemService, SystemMonitorService systemMonitorService, TrafficControlService trafficControlService, SchedulerService schedulerService) {
        super(objectStorageService, virtualFileSystemService, systemMonitorService, trafficControlService);
        this.schedulerService = schedulerService;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/add/{name}"}, produces={"application/json"}, method={RequestMethod.POST})
    public void addRequest(@PathVariable(value="name") String string) {
        TrafficPass trafficPass = null;
        try {
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            if (string == null) {
                throw new OdilonObjectNotFoundException(ErrorCode.INTERNAL_ERROR, String.format("parameter request is null", new Object[0]));
            }
            string = TestServiceRequest.class.getName();
            ServiceRequest serviceRequest = (ServiceRequest)this.getApplicationContext().getBean(TestServiceRequest.class);
            if (serviceRequest == null) {
                throw new OdilonObjectNotFoundException(ErrorCode.OBJECT_NOT_FOUND, String.format("Request does not exist -> %s", string));
            }
            this.getSchedulerService().enqueue(serviceRequest);
        }
        catch (OdilonServerAPIException odilonServerAPIException) {
            try {
                throw odilonServerAPIException;
                catch (Exception exception) {
                    throw new OdilonInternalErrorException(this.getMessage((Throwable)exception));
                }
            }
            catch (Throwable throwable) {
                this.getTrafficControlService().release(trafficPass);
                this.mark();
                throw throwable;
            }
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
    }

    private SchedulerService getSchedulerService() {
        return this.schedulerService;
    }
}

