/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.api.BaseApiController;
import io.odilon.api.SimpleFileUploadController;
import io.odilon.log.Logger;
import io.odilon.monitor.SystemMonitorService;
import io.odilon.service.ObjectStorageService;
import io.odilon.service.ServerSettings;
import io.odilon.traffic.TrafficControlService;
import io.odilon.util.RandomIDGenerator;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/dev"})
public class SimpleFileUploadController
extends BaseApiController {
    private static Logger logger = Logger.getLogger((String)SimpleFileUploadController.class.getName());
    @JsonIgnore
    RandomIDGenerator idGenerator = new RandomIDGenerator();
    @JsonIgnore
    @Autowired
    private final ServerSettings serverSettings;

    public SimpleFileUploadController(ObjectStorageService objectStorageService, VirtualFileSystemService virtualFileSystemService, SystemMonitorService systemMonitorService, TrafficControlService trafficControlService, ServerSettings serverSettings) {
        super(objectStorageService, virtualFileSystemService, systemMonitorService, trafficControlService);
        this.serverSettings = serverSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/upload"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<FileUploadResponse> uploadFile(@RequestParam(value="file") MultipartFile multipartFile) throws IOException {
        try {
            String string = StringUtils.cleanPath((String)multipartFile.getOriginalFilename());
            long l = multipartFile.getSize();
            String string2 = this.saveFile(string, multipartFile);
            FileUploadResponse fileUploadResponse = new FileUploadResponse(this);
            fileUploadResponse.setFileName(string);
            fileUploadResponse.setSize(l);
            fileUploadResponse.setDownloadUri("/downloadFile/" + string2);
            ResponseEntity responseEntity = new ResponseEntity((Object)fileUploadResponse, (HttpStatusCode)HttpStatus.OK);
            return responseEntity;
        }
        finally {
            this.mark();
        }
    }

    private String saveFile(String string, MultipartFile multipartFile) throws IOException {
        Path path;
        String string2 = System.getProperty("user.dir");
        File file = new File(string2, "temp");
        if (!Files.exists(file.toPath(), new LinkOption[0])) {
            Files.createDirectories(file.toPath(), new FileAttribute[0]);
        }
        if (!Files.exists(path = Paths.get(file.getAbsolutePath(), "odilon-upload"), new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        String string3 = this.idGenerator.randomString(8);
        try (InputStream inputStream = multipartFile.getInputStream();){
            Path path2 = path.resolve(string3 + "-" + string);
            Files.copy(inputStream, path2, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException iOException) {
            throw new IOException("Could not save file: " + string, iOException);
        }
        return string3;
    }
}

