/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.api;

import io.odilon.api.BaseApiController;
import io.odilon.error.OdilonServerAPIException;
import io.odilon.monitor.SystemMonitorService;
import io.odilon.net.ErrorCode;
import io.odilon.net.ODHttpStatus;
import io.odilon.service.ObjectStorageService;
import io.odilon.traffic.TrafficControlService;
import io.odilon.traffic.TrafficPass;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class SystemController
extends BaseApiController {
    @Autowired
    public SystemController(ObjectStorageService objectStorageService, VirtualFileSystemService virtualFileSystemService, SystemMonitorService systemMonitorService, TrafficControlService trafficControlService) {
        super(objectStorageService, virtualFileSystemService, systemMonitorService, trafficControlService);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/wipeallpreviousversions"}, method={RequestMethod.DELETE})
    public void wipeAllPreviousVersions() {
        TrafficPass trafficPass = null;
        try {
            trafficPass = this.getTrafficControlService().getPass(this.getClass().getSimpleName());
            this.getObjectStorageService().wipeAllPreviousVersions();
        }
        catch (OdilonServerAPIException odilonServerAPIException) {
            try {
                throw odilonServerAPIException;
                catch (Exception exception) {
                    throw new OdilonServerAPIException(ODHttpStatus.INTERNAL_SERVER_ERROR, ErrorCode.INTERNAL_ERROR, new String[]{this.getMessage((Throwable)exception)});
                }
            }
            catch (Throwable throwable) {
                this.getTrafficControlService().release(trafficPass);
                this.mark();
                throw throwable;
            }
        }
        this.getTrafficControlService().release(trafficPass);
        this.mark();
    }
}

