/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.encryption;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public final class CountingInputStream
extends FilterInputStream {
    private final AtomicLong count = new AtomicLong(0L);
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public CountingInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            this.count.incrementAndGet();
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 > 0) {
            this.count.addAndGet(n3);
        }
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = super.skip(l);
        if (l2 > 0L) {
            this.count.addAndGet(l2);
        }
        return l2;
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            super.close();
        }
    }

    public long getCount() {
        return this.count.get();
    }

    public boolean isClosed() {
        return this.closed.get();
    }
}

