/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.encryption;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.encryption.EncryptedInputStream;
import io.odilon.encryption.JCipherStreamEncryptorInfo;
import io.odilon.encryption.KeyEncryptor;
import io.odilon.encryption.StreamEncryptor;
import io.odilon.encryption.StreamEncryptorInfo;
import io.odilon.errors.InternalCriticalException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class JCipherStreamEncryptor
implements StreamEncryptor {
    @JsonIgnore
    static SecureRandom secRandom = new SecureRandom();
    @JsonIgnore
    private KeyEncryptor keyEncryptor;
    @JsonIgnore
    byte[] ivs;
    private String encryptionAlgorithm;
    private String keyAlgorithm;

    public JCipherStreamEncryptor(String string, String string2, KeyEncryptor keyEncryptor) {
        this.encryptionAlgorithm = string;
        this.keyAlgorithm = string2;
        this.keyEncryptor = keyEncryptor;
        this.ivs = new byte[16];
        secRandom.nextBytes(this.ivs);
    }

    public String getNewKey() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(this.getKeyAlgorithm());
            keyGenerator.init(secRandom);
            SecretKey secretKey = keyGenerator.generateKey();
            return Base64.getEncoder().encodeToString(secretKey.getEncoded());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalCriticalException((Exception)noSuchAlgorithmException, "genNewKey");
        }
    }

    public StreamEncryptorInfo getStreamEncryptionInfo(String string, String string2) {
        byte[] byArray = Base64.getDecoder().decode(string);
        byte[] byArray2 = Base64.getDecoder().decode(string2);
        String string3 = Base64.getEncoder().encodeToString(this.getKeyEncryptor().encryptKey(byArray, byArray2));
        return new JCipherStreamEncryptorInfo(this, string3, Base64.getEncoder().encodeToString(byArray2));
    }

    public EncryptedInputStream encrypt(InputStream inputStream, String string, String string2) {
        try {
            byte[] byArray = Base64.getDecoder().decode(string);
            byte[] byArray2 = Base64.getDecoder().decode(string2);
            InputStream inputStream2 = this.processStream(inputStream, 1, byArray, byArray2);
            StreamEncryptorInfo streamEncryptorInfo = this.getStreamEncryptionInfo(string, string2);
            return new EncryptedInputStream(inputStream2, streamEncryptorInfo);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            throw new InternalCriticalException((Exception)generalSecurityException, "encrypt");
        }
    }

    public InputStream decrypt(InputStream inputStream, String string, String string2) {
        try {
            byte[] byArray = Base64.getDecoder().decode(string);
            byte[] byArray2 = Base64.getDecoder().decode(string2);
            byte[] byArray3 = this.getKeyEncryptor().decryptKey(byArray, byArray2);
            return this.processStream(inputStream, 2, byArray3, byArray2);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            throw new InternalCriticalException((Exception)generalSecurityException, " decrypt");
        }
    }

    public String getIV() {
        return Base64.getEncoder().encodeToString(this.getIVS());
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(String string) {
        this.encryptionAlgorithm = string;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public void setKeyAlgorithm(String string) {
        this.keyAlgorithm = string;
    }

    public KeyEncryptor getKeyEncryptor() {
        return this.keyEncryptor;
    }

    public void setKeyEncryptor(KeyEncryptor keyEncryptor) {
        this.keyEncryptor = keyEncryptor;
    }

    private InputStream processStream(InputStream inputStream, int n, byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, this.getKeyAlgorithm());
        Cipher cipher = Cipher.getInstance(this.getEncryptionAlgorithm());
        try {
            cipher.init(n, (Key)secretKeySpec, new GCMParameterSpec(128, byArray2));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException generalSecurityException) {
            // empty catch block
        }
        return new CipherInputStream(inputStream, cipher);
    }

    private byte[] getIVS() {
        return this.ivs;
    }
}

