/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.encryption;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.encryption.KeyEncryptor;
import io.odilon.encryption.OdilonKeyEncryptorService;
import io.odilon.encryption.VaultKeyEncryptorService;
import io.odilon.log.Logger;
import io.odilon.service.ServerSettings;
import jakarta.annotation.PostConstruct;
import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class KeyEncriptorWrapper
implements KeyEncryptor,
ApplicationContextAware {
    @JsonIgnore
    private static Logger logger = Logger.getLogger((String)KeyEncriptorWrapper.class.getName());
    @JsonIgnore
    private static ApplicationContext applicationContext;
    @JsonIgnore
    private static VaultKeyEncryptorService vaultKeyEncryptor;
    @JsonIgnore
    private static OdilonKeyEncryptorService odilonKeyEncryptor;
    @JsonIgnore
    private Optional<String> vaultUrl;

    public byte[] encryptKey(byte[] byArray, byte[] byArray2) {
        if (((ServerSettings)this.getApplicationContext().getBean(ServerSettings.class)).isUseVaultNewFiles() && this.vaultUrl.isPresent()) {
            return this.getVaultKeyEncryptor().encryptKey(byArray, byArray2);
        }
        return this.getOdilonKeyEncryptor().encryptKey(byArray, byArray2);
    }

    public byte[] decryptKey(byte[] byArray, byte[] byArray2) {
        boolean bl = new String(byArray).startsWith("vault:");
        if (bl) {
            return this.getVaultKeyEncryptor().decryptKey(byArray, byArray2);
        }
        return this.getOdilonKeyEncryptor().decryptKey(byArray, byArray2);
    }

    public VaultKeyEncryptorService getVaultKeyEncryptor() {
        return vaultKeyEncryptor;
    }

    public OdilonKeyEncryptorService getOdilonKeyEncryptor() {
        return odilonKeyEncryptor;
    }

    @JsonIgnore
    private boolean vault() {
        return this.vaultUrl.isPresent();
    }

    @PostConstruct
    protected void onInitialize() {
        this.vaultUrl = ((ServerSettings)applicationContext.getBean(ServerSettings.class)).getVaultUrl();
        if (vaultKeyEncryptor == null) {
            vaultKeyEncryptor = (VaultKeyEncryptorService)this.getApplicationContext().getBean(VaultKeyEncryptorService.class);
        }
        if (odilonKeyEncryptor == null) {
            odilonKeyEncryptor = (OdilonKeyEncryptorService)this.getApplicationContext().getBean(OdilonKeyEncryptorService.class);
        }
    }

    public ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (KeyEncriptorWrapper.applicationContext == null) {
            KeyEncriptorWrapper.applicationContext = applicationContext;
        }
    }
}

