/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.encryption;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ServiceStatus;
import io.odilon.service.BaseService;
import io.odilon.service.ServerSettings;
import io.odilon.service.util.ByteToString;
import jakarta.annotation.PostConstruct;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MasterKeyService
extends BaseService {
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    @JsonIgnore
    @Autowired
    private final ServerSettings serverSettings;
    @JsonIgnore
    private byte[] keyToEncryptMasterKey;
    @JsonIgnore
    private byte[] iv;

    public MasterKeyService(ServerSettings serverSettings) {
        this.serverSettings = serverSettings;
    }

    public byte[] encryptKey(byte[] byArray, byte[] byArray2) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.keyToEncryptMasterKey, "AES");
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)secretKeySpec, new GCMParameterSpec(128, byArray2));
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, "encryptKey");
        }
    }

    public byte[] decryptKey(byte[] byArray) {
        return this.decryptKey(byArray, this.iv);
    }

    public synchronized void setKeyToEncryptMasterKey(byte[] byArray, byte[] byArray2) {
        this.iv = byArray2;
        this.keyToEncryptMasterKey = byArray;
    }

    public ServerSettings getServerSettings() {
        return this.serverSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    protected void onInitialize() {
        MasterKeyService masterKeyService = this;
        synchronized (masterKeyService) {
            this.setStatus(ServiceStatus.STARTING);
            if (this.getServerSettings().getEncryptionKey() != null) {
                String string = this.getServerSettings().getEncryptionKey();
                String string2 = this.getServerSettings().getEncryptionIV();
                byte[] byArray = ByteToString.hexStringToByte((String)string);
                byte[] byArray2 = ByteToString.hexStringToByte((String)string2);
                this.setKeyToEncryptMasterKey(byArray, byArray2);
            }
            startuplogger.debug("Started -> " + this.getClass().getSimpleName());
            this.setStatus(ServiceStatus.RUNNING);
        }
    }

    private byte[] decryptKey(byte[] byArray, byte[] byArray2) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.keyToEncryptMasterKey, "AES");
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)secretKeySpec, new GCMParameterSpec(128, byArray2));
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, "decryptKey");
        }
    }
}

