/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.encryption;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.encryption.KeyEncryptor;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ServiceStatus;
import io.odilon.service.BaseService;
import io.odilon.service.ServerSettings;
import jakarta.annotation.PostConstruct;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OdilonKeyEncryptorService
extends BaseService
implements KeyEncryptor {
    private static final Logger logger = Logger.getLogger((String)OdilonKeyEncryptorService.class.getName());
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    @JsonIgnore
    @Autowired
    private final ServerSettings serverSettings;
    @JsonIgnore
    private byte[] masterKey = null;

    public OdilonKeyEncryptorService(ServerSettings serverSettings) {
        this.serverSettings = serverSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMasterKey(byte[] byArray) {
        OdilonKeyEncryptorService odilonKeyEncryptorService = this;
        synchronized (odilonKeyEncryptorService) {
            this.masterKey = byArray;
            startuplogger.debug("Started -> " + this.getClass().getSimpleName());
            this.setStatus(ServiceStatus.RUNNING);
        }
    }

    public byte[] encryptKey(byte[] byArray, byte[] byArray2) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.masterKey, "AES");
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)secretKeySpec, new GCMParameterSpec(128, byArray2));
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, "encryptKey");
        }
    }

    public byte[] decryptKey(byte[] byArray, byte[] byArray2) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.masterKey, "AES");
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)secretKeySpec, new GCMParameterSpec(128, byArray2));
            byte[] byArray3 = cipher.doFinal(byArray);
            return byArray3;
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, "decryptKey");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    protected void onInitialize() {
        OdilonKeyEncryptorService odilonKeyEncryptorService = this;
        synchronized (odilonKeyEncryptorService) {
            try {
                this.setStatus(ServiceStatus.STARTING);
            }
            catch (Exception exception) {
                startuplogger.error(new String[]{exception.getClass().getName() + " | " + exception.getMessage()});
                logger.error(new String[]{exception.getClass().getName() + " | " + exception.getMessage()});
                this.setStatus(ServiceStatus.STOPPED);
                throw new InternalCriticalException(exception, "onInitialize");
            }
        }
    }
}

