/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.file;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.errors.InternalCriticalException;
import io.odilon.file.FileCopyAgent;
import io.odilon.log.Logger;
import io.odilon.util.DateTimeUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class MulticastFileCopyAgent
extends FileCopyAgent {
    private static Logger logger = Logger.getLogger((String)MulticastFileCopyAgent.class.getName());
    @JsonIgnore
    private ExecutorService executor;
    private OffsetDateTime start;
    private OffsetDateTime end;
    @JsonIgnore
    List<File> destination;
    @JsonIgnore
    File source;
    @JsonIgnore
    InputStream sourceStream;

    public long durationMillisecs() {
        if (this.start == null || this.end == null) {
            return -1L;
        }
        return DateTimeUtil.dateTimeDifference((Temporal)this.start, (Temporal)this.end, (ChronoUnit)ChronoUnit.MILLIS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        try {
            int n;
            int n2;
            this.start = OffsetDateTime.now();
            int n3 = this.destination.size();
            this.executor = Executors.newFixedThreadPool(n3);
            byte[] byArray = new byte[8192];
            ArrayList arrayList = new ArrayList();
            this.destination.forEach(file -> {
                try {
                    arrayList.add(new BufferedOutputStream(new FileOutputStream((File)file)));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
            });
            ArrayList<Callable<Boolean>> arrayList2 = new ArrayList<Callable<Boolean>>(n3);
            while ((n2 = this.sourceStream.read(byArray, 0, byArray.length)) >= 0) {
                n = 0;
                while (n < n3) {
                    int n4 = n++;
                    arrayList2.add(() -> {
                        try {
                            ((OutputStream)arrayList.get(n4)).write(byArray);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            throw new InternalCriticalException((Exception)fileNotFoundException, "f: " + ((File)this.destination.get(n4)).getName());
                        }
                        catch (IOException iOException) {
                            throw new InternalCriticalException((Exception)iOException, "f: " + ((File)this.destination.get(n4)).getName());
                        }
                        return true;
                    });
                }
            }
            n = 1;
            return n != 0;
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
            boolean bl = false;
            return bl;
        }
        finally {
            this.end = OffsetDateTime.now();
            logger.info("Duration: " + DateTimeUtil.timeElapsed((OffsetDateTime)this.start, (OffsetDateTime)this.end));
        }
    }
}

