/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.monitor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.log.Logger;
import io.odilon.model.RedundancyLevel;
import io.odilon.model.ServiceStatus;
import io.odilon.model.SystemInfo;
import io.odilon.service.BaseService;
import io.odilon.service.ServerSettings;
import io.odilon.service.SystemService;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import jakarta.annotation.PostConstruct;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.nio.file.FileStore;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SystemInfoService
extends BaseService
implements SystemService {
    private static Logger logger = Logger.getLogger((String)SystemInfoService.class.getName());
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    private final OffsetDateTime started = OffsetDateTime.now();
    private Integer availableProcessors;
    private Long maxMemory;
    private Long totalMemory;
    private String osName;
    private String osVersion;
    private String userName;
    private String userProfile;
    private String javaVersion;
    private String appVersion;
    private String serverHost;
    private String serverMode;
    private String serverDataStorageMode;
    private String isEncryptEnabled;
    private String isEncryptionInitialized;
    private String isStandby;
    private String standbyUrl;
    private String standbyPort;
    private String isVaultEnabled;
    private String vaultUrl;
    private String isVersionControl;
    private String trafficTokens;
    @JsonIgnore
    @Autowired
    private ServerSettings serverSettings;
    @JsonIgnore
    private VirtualFileSystemService virtualFileSystemService;
    Map<String, String> libraries = null;

    public SystemInfoService(ServerSettings serverSettings, VirtualFileSystemService virtualFileSystemService) {
        this.serverSettings = serverSettings;
        this.virtualFileSystemService = virtualFileSystemService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getSystemLibrariesInfo() {
        if (this.libraries == null) {
            SystemInfoService systemInfoService = this;
            synchronized (systemInfoService) {
                this.libraries = new HashMap();
            }
        }
        return this.libraries;
    }

    public SystemInfo getSystemInfo() {
        Serializable serializable;
        SystemInfo systemInfo = new SystemInfo();
        systemInfo.trafficTokens = this.trafficTokens;
        systemInfo.javaHome = System.getProperty("java.home");
        systemInfo.javaVendor = System.getProperty("java.vendor");
        systemInfo.userHome = System.getProperty("user.home");
        systemInfo.osArch = System.getProperty("os.arch");
        systemInfo.availableProcessors = this.availableProcessors;
        systemInfo.maxMemory = this.maxMemory;
        systemInfo.totalMemory = this.totalMemory;
        systemInfo.osName = this.osName;
        systemInfo.osVersion = this.osVersion;
        systemInfo.started = this.started;
        systemInfo.userName = this.userName;
        systemInfo.userProfile = this.userProfile;
        systemInfo.userDir = System.getProperty("user.dir");
        systemInfo.userProfile = System.getProperty("user.profile");
        systemInfo.javaVersion = this.javaVersion;
        systemInfo.appVersion = this.appVersion;
        systemInfo.serverHost = this.serverHost;
        systemInfo.javaHome = System.getProperty("java.home");
        systemInfo.serverMode = this.serverMode;
        systemInfo.serverDataStorageMode = this.serverDataStorageMode;
        systemInfo.isVaultEnabled = this.isVaultEnabled;
        systemInfo.vaultUrl = this.vaultUrl;
        systemInfo.isVersionControl = this.isVersionControl;
        systemInfo.isEncryptEnabled = this.isEncryptEnabled;
        systemInfo.isEncryptionInitialized = this.isEncryptionInitialized;
        systemInfo.isStandby = this.isStandby;
        systemInfo.standbyUrl = this.standbyUrl;
        systemInfo.standbyPort = this.standbyPort;
        systemInfo.isHttps = this.serverSettings.isHTTPS() ? "yes" : "no";
        systemInfo.freeMemory = Runtime.getRuntime().freeMemory();
        systemInfo.redundancyLevel = this.serverSettings.getRedundancyLevel();
        if (this.serverSettings.getRedundancyLevel() == RedundancyLevel.RAID_6) {
            systemInfo.redundancyLevelDetail = "[data:" + String.valueOf(this.serverSettings.getRAID6DataDrives()) + ", parity:" + String.valueOf(this.serverSettings.getRAID6ParityDrives()) + "] ";
        }
        systemInfo.rootDirs = new ArrayList();
        this.virtualFileSystemService.getMapDrivesEnabled().forEach((string, drive) -> systemInfo.rootDirs.add(drive.getName() + ": " + drive.getRootDirPath()));
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        if (operatingSystemMXBean.getSystemLoadAverage() > 0.0) {
            systemInfo.cpuLoadAverage = operatingSystemMXBean.getSystemLoadAverage();
        }
        ArrayList arrayList = new ArrayList();
        if (this.serverSettings.getRedundancyLevel() == RedundancyLevel.RAID_0) {
            this.virtualFileSystemService.getMapDrivesEnabled().values().forEach(drive -> arrayList.add(drive.getAvailableSpace()));
            serializable = arrayList.stream().map(l -> l).reduce(arrayList.size() > 0 ? (Long)arrayList.get(0) : 0L, (l, l2) -> l < l2 ? l : l2);
            systemInfo.availableDisk = var4_5 = Long.valueOf((Long)serializable * (long)arrayList.size());
        } else if (this.serverSettings.getRedundancyLevel() == RedundancyLevel.RAID_1) {
            this.virtualFileSystemService.getMapDrivesEnabled().values().forEach(drive -> arrayList.add(drive.getAvailableSpace()));
            serializable = arrayList.stream().map(l -> l).reduce(arrayList.size() > 0 ? (Long)arrayList.get(0) : 0L, (l, l2) -> l < l2 ? l : l2);
            systemInfo.availableDisk = serializable;
        } else if (this.serverSettings.getRedundancyLevel() == RedundancyLevel.RAID_6) {
            systemInfo.availableDisk = var4_5 = Long.valueOf(0L);
        }
        serializable = new HashMap();
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        for (Path object2 : FileSystems.getDefault().getRootDirectories()) {
            try {
                FileStore iOException = Files.getFileStore(object2);
                serializable.put(object2.toFile().getAbsolutePath(), iOException.getTotalSpace());
                hashMap.put(object2.toFile().getAbsolutePath(), iOException.getUsableSpace());
            }
            catch (IOException iOException) {
                logger.warn((Throwable)iOException, "---- not thrown ----");
            }
        }
        systemInfo.totalStorage = serializable;
        systemInfo.serverStorage = hashMap;
        HashMap hashMap2 = new HashMap();
        HashMap<String, Long> hashMap3 = new HashMap<String, Long>();
        for (Drive drive2 : this.virtualFileSystemService.getMapDrivesEnabled().values()) {
            try {
                Path iOException = new File(drive2.getRootDirPath()).toPath();
                FileStore fileStore = Files.getFileStore(iOException);
                hashMap2.put(iOException.toFile().getName(), fileStore.getTotalSpace());
                hashMap3.put(iOException.toFile().getName(), fileStore.getUsableSpace());
            }
            catch (IOException iOException) {
                logger.warn((Throwable)iOException, "---- not thrown ----");
            }
        }
        return systemInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    private void onInitialize() {
        SystemInfoService systemInfoService = this;
        synchronized (systemInfoService) {
            this.setStatus(ServiceStatus.STARTING);
            try {
                this.trafficTokens = String.valueOf(this.serverSettings.getMaxTrafficTokens());
                this.availableProcessors = Runtime.getRuntime().availableProcessors();
                this.maxMemory = Runtime.getRuntime().maxMemory();
                this.totalMemory = Runtime.getRuntime().totalMemory();
                this.osName = System.getProperty("os.name");
                this.osVersion = System.getProperty("os.version");
                this.userName = System.getenv().get("USERNAME");
                this.userProfile = System.getenv().get("USERPROFILE");
                this.javaVersion = System.getProperty("java.specification.version");
                this.appVersion = "1.15";
                this.serverHost = this.getServerHost();
                this.serverMode = this.serverSettings.getServerMode();
                this.serverDataStorageMode = this.serverSettings.getDataStorage().getName();
                this.isVersionControl = this.serverSettings.isVersionControl() ? "true" : "false";
                this.isEncryptEnabled = this.serverSettings.isEncryptionEnabled() ? "true" : "false";
                String string = this.isVaultEnabled = this.serverSettings.isVaultEnabled() ? "true" : "false";
                if (this.serverSettings.isVaultEnabled()) {
                    this.vaultUrl = this.serverSettings.getVaultUrl().isPresent() ? (String)this.serverSettings.getVaultUrl().get() : "";
                }
                String string2 = this.isStandby = this.serverSettings.isStandByEnabled() ? "true" : "false";
                if (this.serverSettings.isStandByEnabled()) {
                    this.standbyUrl = this.serverSettings.getStandbyUrl();
                    this.standbyPort = String.valueOf(this.serverSettings.getStandbyPort());
                }
                if (this.virtualFileSystemService.getOdilonServerInfo() != null) {
                    this.isEncryptionInitialized = this.virtualFileSystemService.getOdilonServerInfo().isEncryptionIntialized() ? "true" : "false";
                }
            }
            catch (Exception exception) {
                logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
            }
            startuplogger.debug("Started -> " + SystemInfoService.class.getSimpleName());
            this.setStatus(ServiceStatus.RUNNING);
        }
    }

    private String getServerHost() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            if (SystemInfoService.isLinux()) {
                processBuilder.command("bash", "-c", "hostname");
            } else {
                processBuilder.command("cmd.exe", "/c", "hostname");
            }
            Process process = processBuilder.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
            }
            int n = process.waitFor();
        }
        catch (Exception exception) {
            return exception.getClass().getName();
        }
        return stringBuilder.toString();
    }

    private static boolean isLinux() {
        return System.getenv("OS") == null || !System.getenv("OS").toLowerCase().contains("windows");
    }
}

