/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.monitor;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.cache.FileCacheService;
import io.odilon.cache.ObjectMetadataCacheService;
import io.odilon.log.Logger;
import io.odilon.model.MetricsValues;
import io.odilon.model.RedundancyLevel;
import io.odilon.model.ServiceStatus;
import io.odilon.service.BaseService;
import io.odilon.service.ServerSettings;
import io.odilon.service.SystemService;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SystemMonitorService
extends BaseService
implements SystemService {
    private static Logger logger = Logger.getLogger((String)SystemMonitorService.class.getName());
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    @JsonIgnore
    private final MetricRegistry metrics = new MetricRegistry();
    @JsonIgnore
    private Meter allAPICallMeter;
    @JsonIgnore
    private Counter createObjectCounter;
    @JsonIgnore
    private Counter updateObjectCounter;
    @JsonIgnore
    private Counter deleteObjectCounter;
    @JsonIgnore
    private Counter deleteObjectVersionCounter;
    @JsonIgnore
    private Counter objectRestorePreviousVersionCounter;
    @JsonIgnore
    private Counter objectDeleteAllVersionsCounter;
    @JsonIgnore
    private Meter encrpytFileMeter;
    @JsonIgnore
    private Meter decryptFileMeter;
    @JsonIgnore
    private Meter encryptVaultMeter;
    @JsonIgnore
    private Meter decryptVaultMeter;
    @JsonIgnore
    private Counter replicaCreateObject;
    @JsonIgnore
    private Counter replicaUpdateObject;
    @JsonIgnore
    private Counter replicaDeleteObject;
    @JsonIgnore
    private Counter replicaRestoreObjectPreviousVersionCounter;
    @JsonIgnore
    private Counter replicaDeleteObjectAllVersionsCounter;
    @JsonIgnore
    private Meter putObjectMeter;
    @JsonIgnore
    private Meter getObjectMeter;
    @JsonIgnore
    private Counter cacheObjectHitCounter;
    @JsonIgnore
    private Counter cacheObjectMissCounter;
    @JsonIgnore
    private Counter cacheFileHitCounter;
    @JsonIgnore
    private Counter cacheFileMissCounter;
    @JsonIgnore
    @Autowired
    private final ServerSettings serverSettings;
    @JsonIgnore
    @Autowired
    private final ObjectMetadataCacheService objectCacheService;
    @JsonIgnore
    @Autowired
    private final FileCacheService fileCacheService;

    public SystemMonitorService(ServerSettings serverSettings, ObjectMetadataCacheService objectMetadataCacheService, FileCacheService fileCacheService) {
        this.objectCacheService = objectMetadataCacheService;
        this.serverSettings = serverSettings;
        this.fileCacheService = fileCacheService;
    }

    public Counter getObjectRestorePreviousVersionCounter() {
        return this.objectRestorePreviousVersionCounter;
    }

    public void setObjectRestorePreviousVersionCounter(Counter counter) {
        this.objectRestorePreviousVersionCounter = counter;
    }

    public Counter getObjectDeleteAllVersionsCounter() {
        return this.objectDeleteAllVersionsCounter;
    }

    public void setObjectDeleteAllVersionsCounter(Counter counter) {
        this.objectDeleteAllVersionsCounter = counter;
    }

    public Counter getReplicaRestoreObjectPreviousVersionCounter() {
        return this.replicaRestoreObjectPreviousVersionCounter;
    }

    public void setReplicaRestoreObjectPreviousVersionCounter(Counter counter) {
        this.replicaRestoreObjectPreviousVersionCounter = counter;
    }

    public Counter getReplicaDeleteObjectAllVersionsCounter() {
        return this.replicaDeleteObjectAllVersionsCounter;
    }

    public void setReplicaDeleteObjectAllVersionsCounter(Counter counter) {
        this.replicaDeleteObjectAllVersionsCounter = counter;
    }

    public FileCacheService getFileCacheService() {
        return this.fileCacheService;
    }

    public long getObjectCacheSize() {
        return this.objectCacheService.size();
    }

    public Counter getReplicationObjectCreateCounter() {
        return this.replicaCreateObject;
    }

    public Counter getReplicationObjectUpdateCounter() {
        return this.replicaUpdateObject;
    }

    public Counter getReplicationObjectDeleteCounter() {
        return this.replicaDeleteObject;
    }

    public Counter getCacheObjectHitCounter() {
        return this.cacheObjectHitCounter;
    }

    public Meter getMeterVaultEncrypt() {
        return this.encryptVaultMeter;
    }

    public Meter getMeterVaultDecrypt() {
        return this.decryptVaultMeter;
    }

    public Meter getAllAPICallMeter() {
        return this.allAPICallMeter;
    }

    public Meter getPutObjectMeter() {
        return this.putObjectMeter;
    }

    public Meter getGetObjectMeter() {
        return this.getObjectMeter;
    }

    public Meter getEncrpytFileMeter() {
        return this.encrpytFileMeter;
    }

    public Meter getDecryptFileMeter() {
        return this.decryptFileMeter;
    }

    public Counter getCreateObjectCounter() {
        return this.createObjectCounter;
    }

    public void setCreateObjectCounter(Counter counter) {
        this.createObjectCounter = counter;
    }

    public Counter getUpdateObjectCounter() {
        return this.updateObjectCounter;
    }

    public void setUpdateObjectCounter(Counter counter) {
        this.updateObjectCounter = counter;
    }

    public Counter getDeleteObjectCounter() {
        return this.deleteObjectCounter;
    }

    public void setDeleteObjectCounter(Counter counter) {
        this.deleteObjectCounter = counter;
    }

    public void setDeleteObjectVersionCounter(Counter counter) {
        this.deleteObjectVersionCounter = counter;
    }

    public Counter getDeleteObjectVersionCounter() {
        return this.deleteObjectVersionCounter;
    }

    public long getFileCacheSize() {
        return this.fileCacheService.size();
    }

    public long getFileCacheHadrDiskUsage() {
        return this.fileCacheService.hardDiskUsage();
    }

    public MetricsValues getMetricsValues() {
        MetricsValues metricsValues = new MetricsValues();
        this.set(metricsValues.getObjectMeter, this.getObjectMeter);
        this.set(metricsValues.putObjectMeter, this.putObjectMeter);
        metricsValues.createObjectCounter = this.createObjectCounter.getCount();
        metricsValues.updateObjectCounter = this.updateObjectCounter.getCount();
        metricsValues.deleteObjectCounter = this.deleteObjectCounter.getCount();
        metricsValues.deleteObjectVersionCounter = this.deleteObjectVersionCounter.getCount();
        metricsValues.objectRestorePreviousVersionCounter = this.objectRestorePreviousVersionCounter.getCount();
        metricsValues.objectDeleteAllVersionsCounter = this.objectDeleteAllVersionsCounter.getCount();
        metricsValues.replicaObjectCreate = this.replicaCreateObject.getCount();
        metricsValues.replicaObjectUpdate = this.replicaUpdateObject.getCount();
        metricsValues.replicaObjectDelete = this.replicaDeleteObject.getCount();
        metricsValues.replicaRestoreObjectPreviousVersionCounter = this.replicaRestoreObjectPreviousVersionCounter.getCount();
        metricsValues.replicaDeleteObjectAllVersionsCounter = this.replicaDeleteObjectAllVersionsCounter.getCount();
        metricsValues.cacheObjectHitCounter = this.cacheObjectHitCounter.getCount();
        metricsValues.cacheObjectMissCounter = this.cacheObjectMissCounter.getCount();
        metricsValues.cacheObjectSize = this.objectCacheService.size();
        metricsValues.cacheFileHitCounter = this.cacheFileHitCounter.getCount();
        metricsValues.cacheFileMissCounter = this.cacheFileMissCounter.getCount();
        metricsValues.cacheFileSize = this.fileCacheService.size();
        metricsValues.cacheFileHardDiskUsage = this.fileCacheService.hardDiskUsage();
        this.set(metricsValues.encrpytFileMeter, this.encrpytFileMeter);
        this.set(metricsValues.decryptFileMeter, this.decryptFileMeter);
        this.set(metricsValues.encryptVaultMeter, this.encryptVaultMeter);
        this.set(metricsValues.decryptVaultMeter, this.decryptVaultMeter);
        return metricsValues;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("apiAllMeter", this.getString(this.allAPICallMeter));
        hashMap.put("cacheObjectHitCounter", String.valueOf(this.cacheObjectHitCounter.getCount()));
        hashMap.put("cacheObjectMissCounter", String.valueOf(this.cacheObjectMissCounter.getCount()));
        hashMap.put("cacheObjectSize", String.valueOf(this.objectCacheService.size()));
        if (this.serverSettings.getRedundancyLevel() == RedundancyLevel.RAID_6) {
            hashMap.put("cacheFileHitCounter", String.valueOf(this.cacheFileHitCounter.getCount()));
            hashMap.put("cacheFileMissCounter", String.valueOf(this.cacheFileMissCounter.getCount()));
            hashMap.put("cacheFileSize", String.valueOf(this.fileCacheService.size()));
        }
        hashMap.put("fileCacheHardDiskUsage", String.valueOf(this.fileCacheService.hardDiskUsage()));
        hashMap.put("objectCreateCounter", String.valueOf(this.createObjectCounter.getCount()));
        hashMap.put("objectUpdateCounter", String.valueOf(this.updateObjectCounter.getCount()));
        hashMap.put("objectDeleteCounter", String.valueOf(this.deleteObjectCounter.getCount()));
        hashMap.put("objectDeleteVersionCounter", String.valueOf(this.deleteObjectVersionCounter.getCount()));
        hashMap.put("objectRestorePreviousVersionCounter", String.valueOf(this.objectRestorePreviousVersionCounter.getCount()));
        hashMap.put("objectDeleteAllVersionsCounter", String.valueOf(this.objectDeleteAllVersionsCounter.getCount()));
        hashMap.put("objectGetMeter", this.getString(this.getObjectMeter));
        hashMap.put("objectPutMeter", this.getString(this.putObjectMeter));
        hashMap.put("encrpytFileMeter", this.getString(this.encrpytFileMeter));
        hashMap.put("decryptFileMeter", this.getString(this.decryptFileMeter));
        hashMap.put("vaultEncryptMeter", this.getString(this.encryptVaultMeter));
        hashMap.put("vaultDecryptMeter", this.getString(this.decryptVaultMeter));
        if (this.serverSettings.isStandByEnabled()) {
            hashMap.put("replicaObjectCreate", String.valueOf(this.replicaCreateObject.getCount()));
            hashMap.put("replicaObjectUpdate", String.valueOf(this.replicaUpdateObject.getCount()));
            hashMap.put("replicaObjectDelete", String.valueOf(this.replicaDeleteObject.getCount()));
            hashMap.put("replicaRestoreObjectPreviousVersionCounter", String.valueOf(this.replicaRestoreObjectPreviousVersionCounter.getCount()));
            hashMap.put("replicaDeleteObjectAllVersionsCounter", String.valueOf(this.replicaDeleteObjectAllVersionsCounter.getCount()));
        }
        return hashMap;
    }

    public Counter getCacheObjectMissCounter() {
        return this.cacheObjectMissCounter;
    }

    public Counter getCacheFileHitCounter() {
        return this.cacheFileHitCounter;
    }

    public Counter getCacheFileMissCounter() {
        return this.cacheFileMissCounter;
    }

    public String getMetrics() {
        return this.toJSON();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    private void onInitialize() {
        SystemMonitorService systemMonitorService = this;
        synchronized (systemMonitorService) {
            this.setStatus(ServiceStatus.STARTING);
            this.createObjectCounter = this.metrics.counter("createObjectCounter");
            this.updateObjectCounter = this.metrics.counter("updateObjectCounter");
            this.deleteObjectCounter = this.metrics.counter("deleteObjectCounter");
            this.deleteObjectVersionCounter = this.metrics.counter("deleteObjectVersionCounter");
            this.cacheObjectHitCounter = this.metrics.counter("cacheObjectHitCounter");
            this.cacheObjectMissCounter = this.metrics.counter("cacheObjectMissCounter");
            this.cacheFileHitCounter = this.metrics.counter("cacheFileHitCounter");
            this.cacheFileMissCounter = this.metrics.counter("cacheFileMissCounter");
            this.objectRestorePreviousVersionCounter = this.metrics.counter("restoreObjectPreivousVersionCounter");
            this.objectDeleteAllVersionsCounter = this.metrics.counter("deleteObjectAllVersionsCounter");
            this.replicaCreateObject = this.metrics.counter("replicaObjectCreate");
            this.replicaUpdateObject = this.metrics.counter("replicaObjectUpdate");
            this.replicaDeleteObject = this.metrics.counter("replicaObjectDelete");
            this.replicaRestoreObjectPreviousVersionCounter = this.metrics.counter("replicaRestoreObjectPreivousVersionCounter");
            this.replicaDeleteObjectAllVersionsCounter = this.metrics.counter("replicaDeleteObjectAllVersionsCounter");
            this.allAPICallMeter = this.metrics.meter("allAPICallMeter");
            this.putObjectMeter = this.metrics.meter("putObjectMeter");
            this.getObjectMeter = this.metrics.meter("getObjectMeter");
            this.encrpytFileMeter = this.metrics.meter("encrpytFileMeter");
            this.decryptFileMeter = this.metrics.meter("decryptFileMeter");
            this.encryptVaultMeter = this.metrics.meter("encrpytVaultMeter");
            this.decryptVaultMeter = this.metrics.meter("decryptVaultMeter");
            startuplogger.debug("Started -> " + SystemMonitorService.class.getSimpleName());
            this.setStatus(ServiceStatus.RUNNING);
        }
    }

    private String getString(Meter meter) {
        return String.format("%10.4f", meter.getOneMinuteRate()).trim() + ", " + String.format("%10.4f", meter.getFiveMinuteRate()).trim() + ", " + String.format("%10.4f", meter.getFifteenMinuteRate()).trim();
    }

    private void set(double[] dArray, Meter meter) {
        dArray[0] = meter.getOneMinuteRate();
        dArray[1] = meter.getFiveMinuteRate();
        dArray[2] = meter.getFifteenMinuteRate();
    }
}

