/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.replication;

import io.odilon.client.error.ODClientException;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.model.list.DataList;
import io.odilon.model.list.Item;
import io.odilon.replication.ReplicationService;
import io.odilon.service.BaseService;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReplicationCheckService
extends BaseService {
    private static Logger logger = Logger.getLogger((String)ReplicationCheckService.class.getName());
    @Autowired
    private final ReplicationService replicationService;
    @Autowired
    private final VirtualFileSystemService virtualFileSystemService;

    public ReplicationCheckService(ReplicationService replicationService, VirtualFileSystemService virtualFileSystemService) {
        this.replicationService = replicationService;
        this.virtualFileSystemService = virtualFileSystemService;
    }

    public void check() {
        this.checkBuckets();
        for (ServerBucket serverBucket : this.getVirtualFileSystemService().listAllBuckets()) {
            this.checkBucket(serverBucket);
        }
    }

    public ReplicationService getReplicationService() {
        return this.replicationService;
    }

    protected void checkBuckets() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (ServerBucket serverBucket : this.getVirtualFileSystemService().listAllBuckets()) {
            try {
                if (this.getReplicationService().getClient().existsBucket(serverBucket.getName())) continue;
                arrayList.add(serverBucket.getName());
            }
            catch (ODClientException oDClientException) {
                logger.error((Throwable)oDClientException, new String[]{"---- not thrown ----"});
            }
        }
        try {
            for (ServerBucket serverBucket : this.getReplicationService().getClient().listBuckets()) {
                if (this.getVirtualFileSystemService().existsBucket(serverBucket.getName())) continue;
                arrayList2.add(serverBucket.getName());
            }
        }
        catch (ODClientException oDClientException) {
            logger.error((Throwable)oDClientException, new String[]{"---- not thrown ----"});
        }
        arrayList.forEach(string -> logger.error(new String[]{string}));
        arrayList2.forEach(string -> logger.error(new String[]{string}));
    }

    protected void checkBucket(ServerBucket serverBucket) {
        ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
        ArrayList<CallSite> arrayList2 = new ArrayList<CallSite>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        Integer n = 1000;
        Long l = 0L;
        String string2 = null;
        boolean bl = false;
        while (!bl) {
            DataList dataList = this.getVirtualFileSystemService().listObjects(serverBucket.getName(), Optional.of(l), Optional.ofNullable(n), Optional.empty(), Optional.ofNullable(string2));
            if (string2 == null) {
                string2 = dataList.getAgentId();
            }
            for (Item item : dataList.getList()) {
                if (!item.isOk()) continue;
                try {
                    if (this.getReplicationService().getClient().existsObject(((ObjectMetadata)item.getObject()).bucketName, ((ObjectMetadata)item.getObject()).objectName)) continue;
                    arrayList.add((CallSite)((Object)(((ObjectMetadata)item.getObject()).bucketId.toString() + " /" + ((ObjectMetadata)item.getObject()).objectName)));
                }
                catch (ODClientException | IOException throwable) {
                    arrayList3.add(throwable.getClass().getName());
                }
            }
            l = l + Long.valueOf(Integer.valueOf(dataList.getList().size()).longValue());
            bl = dataList.isEOD();
        }
        boolean bl2 = false;
        while (!bl2) {
            try {
                l = this.getReplicationService().getClient().listObjects(serverBucket.getName());
                while (l.hasNext()) {
                    string2 = (Item)l.next();
                    if (!((Item)l.next()).isOk()) continue;
                    try {
                        if (this.getVirtualFileSystemService().existsObject(((ObjectMetadata)string2.getObject()).bucketName, ((ObjectMetadata)string2.getObject()).objectName)) continue;
                        arrayList2.add((CallSite)((Object)(((ObjectMetadata)string2.getObject()).bucketName + " /" + ((ObjectMetadata)string2.getObject()).objectName)));
                    }
                    catch (Exception exception) {
                        arrayList3.add(exception.getClass().getName());
                    }
                }
            }
            catch (ODClientException oDClientException) {
                logger.error((Throwable)oDClientException, new String[]{"---- not thrown ----"});
            }
        }
        arrayList.forEach(string -> logger.error(new String[]{string}));
        arrayList2.forEach(string -> logger.error(new String[]{string}));
    }

    private VirtualFileSystemService getVirtualFileSystemService() {
        return this.virtualFileSystemService;
    }
}

