/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.replication;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.model.OdilonServerInfo;
import io.odilon.model.list.DataList;
import io.odilon.model.list.Item;
import io.odilon.replication.ReplicationService;
import io.odilon.virtualFileSystem.OdilonVirtualFileSystemOperation;
import io.odilon.virtualFileSystem.model.IODriver;
import io.odilon.virtualFileSystem.model.LockService;
import io.odilon.virtualFileSystem.model.OperationCode;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class StandByInitialSync
implements Runnable {
    private static Logger logger = Logger.getLogger((String)StandByInitialSync.class.getName());
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    private static Logger intialSynclogger = Logger.getLogger((String)"IntialSyncLogger");
    @JsonIgnore
    private long start_ms;
    @JsonIgnore
    private int maxProcessingThread = 1;
    @JsonIgnore
    private AtomicLong errors = new AtomicLong(0L);
    @JsonIgnore
    private AtomicBoolean done = new AtomicBoolean(false);
    @JsonIgnore
    private AtomicLong checkOk = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong counter = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong copied = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong totalBytes = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong cleaned = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong notAvailable = new AtomicLong(0L);
    @JsonIgnore
    private LockService vfsLockService;
    @JsonIgnore
    VirtualFileSystemService virtualFileSystemService;
    @JsonIgnore
    ReplicationService replicationService;
    @JsonIgnore
    private Thread thread;
    @JsonIgnore
    private IODriver driver;

    public StandByInitialSync(IODriver iODriver) {
        this.driver = iODriver;
        this.vfsLockService = this.driver.getLockService();
        this.virtualFileSystemService = this.driver.getVirtualFileSystemService();
        this.replicationService = this.virtualFileSystemService.getReplicationService();
        this.setMaxProcessingThread();
    }

    public void start() {
        this.thread = new Thread((Runnable)this);
        this.thread.setDaemon(true);
        this.thread.setName(this.getClass().getSimpleName());
        this.thread.start();
    }

    @Override
    public void run() {
        try {
            logger.debug("Starting -> " + this.getClass().getSimpleName());
            this.sync();
        }
        finally {
            this.done = new AtomicBoolean(true);
            this.getReplicationService().setInitialSync(new AtomicBoolean(false));
        }
    }

    public AtomicBoolean isDone() {
        return this.done;
    }

    protected IODriver getDriver() {
        return this.driver;
    }

    protected LockService getLockService() {
        return this.vfsLockService;
    }

    protected VirtualFileSystemService getVirtualFileSystemService() {
        return this.virtualFileSystemService;
    }

    protected ReplicationService getReplicationService() {
        return this.replicationService;
    }

    private void setMaxProcessingThread() {
        this.maxProcessingThread = Double.valueOf(Double.valueOf(Runtime.getRuntime().availableProcessors() - 1) / 2.0).intValue() + 1 - 2;
        if (this.maxProcessingThread < 1) {
            this.maxProcessingThread = 1;
        }
        if (this.getVirtualFileSystemService().getServerSettings().getStandbySyncThreads() > 0) {
            this.maxProcessingThread = this.getVirtualFileSystemService().getServerSettings().getStandbySyncThreads();
        }
    }

    private int getMaxProcessingThread() {
        return this.maxProcessingThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync() {
        block15: {
            this.start_ms = System.currentTimeMillis();
            OdilonServerInfo odilonServerInfo = this.getDriver().getVirtualFileSystemService().getOdilonServerInfo();
            if (odilonServerInfo == null) {
                return;
            }
            if (odilonServerInfo.getStandByStartDate() == null) {
                return;
            }
            if (odilonServerInfo.getCreationDate() == null) {
                return;
            }
            this.getReplicationService().setInitialSync(new AtomicBoolean(true));
            ExecutorService executorService = null;
            try {
                this.errors = new AtomicLong(0L);
                executorService = Executors.newFixedThreadPool(this.getMaxProcessingThread());
                List list = this.getVirtualFileSystemService().listAllBuckets();
                boolean bl = list.isEmpty();
                for (ServerBucket serverBucket : list) {
                    Integer n = 1000;
                    Long l = 0L;
                    String string = null;
                    boolean bl2 = false;
                    while (!bl2 && this.errors.get() <= 10L) {
                        DataList dataList = this.getVirtualFileSystemService().listObjects(serverBucket.getName(), Optional.of(l), Optional.ofNullable(n), Optional.empty(), Optional.ofNullable(string));
                        if (string == null) {
                            string = dataList.getAgentId();
                        }
                        ArrayList<Callable<Object>> arrayList = new ArrayList<Callable<Object>>(dataList.getList().size());
                        for (Item item : dataList.getList()) {
                            arrayList.add(() -> {
                                block18: {
                                    try {
                                        if (this.errors.get() > 10L) {
                                            return null;
                                        }
                                        this.counter.getAndIncrement();
                                        if ((this.counter.get() + 1L) % 10L == 1L) {
                                            logger.debug("synced so far -> " + String.valueOf(this.counter.get()));
                                        }
                                        if (item.isOk()) {
                                            ObjectMetadata objectMetadata;
                                            boolean bl = false;
                                            this.getLockService().getObjectLock(((ObjectMetadata)item.getObject()).getBucketId(), ((ObjectMetadata)item.getObject()).getObjectName()).readLock().lock();
                                            try {
                                                this.getLockService().getBucketLock(serverBucket).readLock().lock();
                                                try {
                                                    if (((ObjectMetadata)item.getObject()).dateSynced == null || ((ObjectMetadata)item.getObject()).dateSynced.isBefore(odilonServerInfo.getStandByStartDate())) {
                                                        logger.debug(((ObjectMetadata)item.getObject()).getBucketId().toString() + "-" + ((ObjectMetadata)item.getObject()).getObjectName());
                                                        objectMetadata = new OdilonVirtualFileSystemOperation(this.getDriver().getVirtualFileSystemService().getJournalService().newOperationId(), OperationCode.CREATE_OBJECT, Optional.of(((ObjectMetadata)item.getObject()).getBucketId()), Optional.of(((ObjectMetadata)item.getObject()).getBucketName()), Optional.of(((ObjectMetadata)item.getObject()).getObjectName()), Optional.of(((ObjectMetadata)item.getObject()).getVersion()), this.getDriver().getVirtualFileSystemService().getRedundancyLevel(), this.getDriver().getVirtualFileSystemService().getJournalService());
                                                        this.getReplicationService().replicate((VirtualFileSystemOperation)objectMetadata);
                                                        bl = true;
                                                        this.totalBytes.addAndGet(((ObjectMetadata)item.getObject()).length());
                                                        this.copied.getAndIncrement();
                                                    }
                                                }
                                                catch (Exception exception) {
                                                    logger.error((Throwable)exception, new String[]{"can not sync -> " + ((ObjectMetadata)item.getObject()).bucketId.toString() + "-" + ((ObjectMetadata)item.getObject()).objectName, "---- not thrown ----"});
                                                    intialSynclogger.error((Throwable)exception, new String[]{"can not sync -> " + ((ObjectMetadata)item.getObject()).bucketId.toString() + "-" + ((ObjectMetadata)item.getObject()).objectName});
                                                    this.errors.getAndIncrement();
                                                }
                                                finally {
                                                    this.getLockService().getBucketLock(((ObjectMetadata)item.getObject()).getBucketId()).readLock().unlock();
                                                }
                                            }
                                            finally {
                                                this.getLockService().getObjectLock(((ObjectMetadata)item.getObject()).getBucketId(), ((ObjectMetadata)item.getObject()).getObjectName()).readLock().unlock();
                                            }
                                            if (bl) {
                                                try {
                                                    objectMetadata = (ObjectMetadata)item.getObject();
                                                    objectMetadata.dateSynced = OffsetDateTime.now();
                                                    objectMetadata.lastModified = OffsetDateTime.now();
                                                    this.getDriver().putObjectMetadata(objectMetadata);
                                                }
                                                catch (Exception exception) {
                                                    logger.error(new String[]{"can not sync ObjectMetadata -> " + ((ObjectMetadata)item.getObject()).bucketId.toString() + "-" + ((ObjectMetadata)item.getObject()).objectName, "---- not thrown ----"});
                                                    intialSynclogger.error(new String[]{"can not sync ObjectMetadata -> " + ((ObjectMetadata)item.getObject()).bucketId.toString() + "-" + ((ObjectMetadata)item.getObject()).objectName});
                                                    intialSynclogger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                                                    this.errors.getAndIncrement();
                                                }
                                            }
                                            break block18;
                                        }
                                        this.notAvailable.getAndIncrement();
                                    }
                                    catch (Exception exception) {
                                        logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                                        intialSynclogger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                                        this.errors.getAndIncrement();
                                    }
                                }
                                return null;
                            });
                        }
                        try {
                            executorService.invokeAll(arrayList, 10L, TimeUnit.MINUTES);
                        }
                        catch (InterruptedException interruptedException) {
                            logger.error((Throwable)interruptedException, new String[]{"---- not thrown ----"});
                        }
                        l = l + Long.valueOf(Integer.valueOf(dataList.getList().size()).longValue());
                        bl2 = dataList.isEOD() || this.errors.get() > 0L || this.notAvailable.get() > 0L;
                        bl = bl2 && this.errors.get() == 0L && this.notAvailable.get() == 0L;
                    }
                }
                try {
                    executorService.shutdown();
                    executorService.awaitTermination(10L, TimeUnit.MINUTES);
                    if (bl) {
                        odilonServerInfo.setStandBySyncedDate(OffsetDateTime.now());
                        this.virtualFileSystemService.setOdilonServerInfo(odilonServerInfo);
                        logger.info("---------------------------------");
                        logger.info("Intial Sync completed");
                        intialSynclogger.info("Intial Sync completed");
                        startuplogger.info("Intial Sync completed");
                        break block15;
                    }
                    logger.info("---------------------------------");
                    logger.error(new String[]{"The intial Sync process can not be completed. Please correct the issues and restart the Odilon Server in order for the Sync process to execute again"});
                    intialSynclogger.error(new String[]{"Intial Sync can not be completed"});
                    startuplogger.error(new String[]{"Intial Sync can not be completed"});
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                this.logResults(startuplogger);
                this.logResults(intialSynclogger);
            }
        }
    }

    private void logResults(Logger logger) {
        logger.info("---------------------------------");
        logger.debug("Threads: " + String.valueOf(this.maxProcessingThread));
        logger.info("Total files scanned: " + String.valueOf(this.counter.get()));
        logger.info("Total files synced: " + String.valueOf(this.copied.get()));
        logger.info("Total size synced: " + String.format("%14.4f", Double.valueOf(this.totalBytes.get()) / 1.073741824E9).trim() + " GB");
        if (this.errors.get() > 0L) {
            logger.info("Error files: " + String.valueOf(this.errors.get()));
        }
        if (this.notAvailable.get() > 0L) {
            logger.info("Not Available files: " + String.valueOf(this.notAvailable.get()));
        }
        logger.info("Duration: " + String.valueOf(Double.valueOf(System.currentTimeMillis() - this.start_ms) / Double.valueOf(1000.0)) + " secs");
        logger.info("---------------------------------");
    }
}

