/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.scheduler;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.odilon.json.OdilonObjectMapper;
import io.odilon.log.Logger;
import io.odilon.scheduler.AfterDeleteObjectServiceRequest;
import io.odilon.scheduler.AfterUpdateObjectServiceRequest;
import io.odilon.scheduler.CronJobDataIntegrityCheckRequest;
import io.odilon.scheduler.CronJobWorkDirCleanUpRequest;
import io.odilon.scheduler.PingCronJobRequest;
import io.odilon.scheduler.ServiceRequest;
import io.odilon.scheduler.ServiceRequestStatus;
import io.odilon.scheduler.StandByReplicaServiceRequest;
import io.odilon.scheduler.TestServiceRequest;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=CronJobDataIntegrityCheckRequest.class, name="dataIntegrity"), @JsonSubTypes.Type(value=PingCronJobRequest.class, name="ping"), @JsonSubTypes.Type(value=CronJobWorkDirCleanUpRequest.class, name="workDirCleanUp"), @JsonSubTypes.Type(value=StandByReplicaServiceRequest.class, name="standByReplica"), @JsonSubTypes.Type(value=AfterUpdateObjectServiceRequest.class, name="afterUpdateObject"), @JsonSubTypes.Type(value=AfterDeleteObjectServiceRequest.class, name="afterDeleteObject"), @JsonSubTypes.Type(value=AfterDeleteObjectServiceRequest.class, name="deleteBucketObjectPreviousVersion"), @JsonSubTypes.Type(value=TestServiceRequest.class, name="test")})
public abstract class AbstractServiceRequest
implements ServiceRequest {
    private static Logger logger = Logger.getLogger((String)AbstractServiceRequest.class.getName());
    private static final long serialVersionUID = 1L;
    @JsonIgnore
    private static final ObjectMapper mapper = new OdilonObjectMapper();
    @JsonProperty(value="timezone")
    private String timezone;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="clazz")
    private String clazz = this.getClass().getName();
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="parameters")
    private Map<String, String> parameters;
    @JsonProperty(value="retries")
    private int retries = 0;
    @JsonIgnore
    private OffsetDateTime started;
    @JsonIgnore
    private OffsetDateTime ended;
    @JsonIgnore
    private OffsetDateTime executeAfter;
    @JsonIgnore
    private double progress = 0.0;
    @JsonIgnore
    private ServiceRequestStatus status;
    @JsonIgnore
    private volatile ApplicationContext applicationContext;

    public AbstractServiceRequest() {
        this.setName(this.getClass().getSimpleName());
    }

    public abstract void execute();

    public abstract void stop();

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof ServiceRequest) {
            if (!object.getClass().equals(this.getClass())) {
                return false;
            }
            return ((ServiceRequest)object).getId().equals(this.getId());
        }
        return false;
    }

    public void setStart(OffsetDateTime offsetDateTime) {
        this.started = offsetDateTime;
    }

    public void setEnd(OffsetDateTime offsetDateTime) {
        this.ended = offsetDateTime;
    }

    public double getProgress() {
        return this.progress;
    }

    public OffsetDateTime started() {
        return this.started;
    }

    public OffsetDateTime ended() {
        return this.ended;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setParameters(Map<String, String> map) {
        this.parameters = map;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setExecuteAfter(OffsetDateTime offsetDateTime) {
        this.executeAfter = offsetDateTime;
    }

    public OffsetDateTime getExecuteAfter() {
        return this.executeAfter;
    }

    public boolean isExecuting() {
        return this.getStatus() == ServiceRequestStatus.RUNNING;
    }

    public boolean isCronJob() {
        return false;
    }

    public Serializable getId() {
        return this.id;
    }

    public void setId(Serializable serializable) {
        this.id = (Long)serializable;
    }

    public ServiceRequestStatus getStatus() {
        return this.status;
    }

    public void setStatus(ServiceRequestStatus serviceRequestStatus) {
        this.status = serviceRequestStatus;
    }

    public ObjectMapper getObjectMapper() {
        return mapper;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(this.toJSON());
        return stringBuilder.toString();
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int n) {
        this.retries = n;
    }

    public String toJSON() {
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException jsonProcessingException) {
            logger.error((Throwable)jsonProcessingException, new String[]{"---- not thrown ----"});
            return "\"error\":\"" + ((Object)((Object)jsonProcessingException)).getClass().getName() + " | " + jsonProcessingException.getMessage() + "\"";
        }
    }

    public void setTimeZone(String string) {
        this.timezone = string;
    }

    public String getTimeZone() {
        return this.timezone;
    }
}

