/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.scheduler;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.scheduler.AbstractServiceRequest;
import io.odilon.scheduler.ServiceRequestStatus;
import io.odilon.scheduler.StandardServiceRequest;
import io.odilon.virtualFileSystem.model.OperationCode;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@JsonTypeName(value="afterDeleteObject")
public class AfterDeleteObjectServiceRequest
extends AbstractServiceRequest
implements StandardServiceRequest {
    private static Logger logger = Logger.getLogger((String)AfterDeleteObjectServiceRequest.class.getName());
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="meta")
    ObjectMetadata meta;
    @JsonProperty(value="headVersion")
    int headVersion = 0;
    @JsonProperty(value="operationCode")
    OperationCode operationCode;
    @JsonIgnore
    private boolean isSuccess = false;

    protected AfterDeleteObjectServiceRequest() {
    }

    public AfterDeleteObjectServiceRequest(OperationCode operationCode, ObjectMetadata objectMetadata, int n) {
        this.operationCode = operationCode;
        this.meta = objectMetadata;
        this.headVersion = n;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public void execute() {
        try {
            this.setStatus(ServiceRequestStatus.RUNNING);
            this.clean();
            this.isSuccess = true;
            this.setStatus(ServiceRequestStatus.COMPLETED);
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
            this.isSuccess = false;
            this.setStatus(ServiceRequestStatus.ERROR);
        }
    }

    public String getUUID() {
        if (this.meta == null) {
            return "null";
        }
        return (this.meta.bucketId != null ? this.meta.bucketId.toString() : "null") + ":" + (this.meta.objectName != null ? this.meta.objectName : "null");
    }

    public boolean isObjectOperation() {
        return true;
    }

    public void stop() {
        this.isSuccess = true;
    }

    public OperationCode getOperationCode() {
        return this.operationCode;
    }

    private void clean() {
        VirtualFileSystemService virtualFileSystemService = (VirtualFileSystemService)this.getApplicationContext().getBean(VirtualFileSystemService.class);
        if (this.getOperationCode() == null) {
            logger.error(new String[]{"Invalid " + OperationCode.class.getName() + " is null ", "---- not thrown ----"});
            return;
        }
        if (this.meta == null) {
            logger.error(new String[]{"Invalid " + ObjectMetadata.class.getName() + " is null ", "---- not thrown ----"});
            return;
        }
        if (this.getOperationCode() == OperationCode.DELETE_OBJECT) {
            virtualFileSystemService.createVFSIODriver().postObjectDeleteTransaction(this.meta, this.headVersion);
        } else if (this.getOperationCode() == OperationCode.DELETE_OBJECT_PREVIOUS_VERSIONS) {
            virtualFileSystemService.createVFSIODriver().postObjectPreviousVersionDeleteAllTransaction(this.meta, this.headVersion);
        } else {
            logger.error(new String[]{"Invalid " + OperationCode.class.getName() + " -> " + this.operationCode.getName(), "---- not thrown ----"});
        }
    }
}

