/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.scheduler;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.odilon.log.Logger;
import io.odilon.scheduler.CronJobRequest;
import io.odilon.scheduler.ServiceRequestStatus;
import io.odilon.virtualFileSystem.DataIntegrityChecker;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@JsonTypeName(value="dataIntegrity")
public class CronJobDataIntegrityCheckRequest
extends CronJobRequest {
    private static Logger logger = Logger.getLogger((String)CronJobDataIntegrityCheckRequest.class.getName());
    private static final long serialVersionUID = 1L;

    public CronJobDataIntegrityCheckRequest() {
    }

    public CronJobDataIntegrityCheckRequest(String string) {
        super(string);
    }

    public void execute() {
        try {
            this.setStatus(ServiceRequestStatus.RUNNING);
            boolean bl = false;
            DataIntegrityChecker dataIntegrityChecker = (DataIntegrityChecker)this.getApplicationContext().getBean(DataIntegrityChecker.class, new Object[]{bl});
            logger.debug("Started -> " + dataIntegrityChecker.toString());
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
        }
        finally {
            this.setStatus(ServiceRequestStatus.COMPLETED);
            logger.debug("done");
        }
    }

    public boolean isSuccess() {
        return true;
    }

    public String getUUID() {
        return "s" + this.getId().toString();
    }
}

