/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.scheduler;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.odilon.log.Logger;
import io.odilon.scheduler.CronJobRequest;
import io.odilon.scheduler.ServiceRequestStatus;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import java.io.File;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@JsonTypeName(value="workDirCleanUp")
public class CronJobWorkDirCleanUpRequest
extends CronJobRequest {
    private static Logger logger = Logger.getLogger((String)CronJobWorkDirCleanUpRequest.class.getName());
    private static final long serialVersionUID = 1L;
    private static final int LAPSE_HOURS = 3;
    @JsonIgnore
    private boolean isSuccess = false;
    @JsonIgnore
    private AtomicBoolean stop = new AtomicBoolean(false);

    protected CronJobWorkDirCleanUpRequest() {
    }

    public CronJobWorkDirCleanUpRequest(String string) {
        super(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        try {
            this.setStatus(ServiceRequestStatus.RUNNING);
            this.setSuccess(false);
            VirtualFileSystemService virtualFileSystemService = (VirtualFileSystemService)this.getApplicationContext().getBean(VirtualFileSystemService.class);
            OffsetDateTime offsetDateTime = OffsetDateTime.now();
            ArrayList<File> arrayList = new ArrayList<File>();
            for (Drive drive : virtualFileSystemService.getMapDrivesAll().values()) {
                for (ServerBucket serverBucket : virtualFileSystemService.listAllBuckets()) {
                    File[] fileArray;
                    File file2 = new File(drive.getBucketWorkDirPath(serverBucket));
                    if (!file2.exists()) continue;
                    for (File file3 : fileArray = file2.listFiles()) {
                        if (this.isStop()) {
                            return;
                        }
                        Instant instant = Instant.ofEpochMilli(file3.lastModified());
                        OffsetDateTime offsetDateTime2 = OffsetDateTime.ofInstant(instant, ZoneId.systemDefault());
                        if (!offsetDateTime2.plusHours(3L).isBefore(offsetDateTime)) continue;
                        arrayList.add(file3);
                    }
                }
            }
            if (this.isStop()) {
                return;
            }
            if (arrayList.size() > 0) {
                logger.debug("Removing from work dir -> " + String.valueOf(arrayList.size()));
                arrayList.forEach(file -> FileUtils.deleteQuietly((File)file));
            }
            this.setSuccess(true);
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
        }
        finally {
            this.setStatus(ServiceRequestStatus.COMPLETED);
        }
    }

    private void setSuccess(boolean bl) {
        this.isSuccess = bl;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public void stop() {
        this.stop.set(true);
    }

    public String getUUID() {
        return "s" + this.getId().toString();
    }

    private boolean isStop() {
        return this.stop.get();
    }
}

