/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.scheduler;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.model.list.DataList;
import io.odilon.model.list.Item;
import io.odilon.scheduler.AbstractServiceRequest;
import io.odilon.scheduler.ServiceRequestStatus;
import io.odilon.scheduler.StandardServiceRequest;
import io.odilon.service.ServerSettings;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@JsonTypeName(value="deleteBucketObjectPreviousVersion")
public class DeleteBucketObjectPreviousVersionServiceRequest
extends AbstractServiceRequest
implements StandardServiceRequest {
    private static Logger logger = Logger.getLogger((String)DeleteBucketObjectPreviousVersionServiceRequest.class.getName());
    private static final long serialVersionUID = 1L;
    static AtomicBoolean instanceRunning = new AtomicBoolean(false);
    static final int PAGESIZE = 1000;
    private String bucketName;
    private Long bucketId;
    @JsonIgnore
    private long start_ms = 0L;
    @JsonIgnore
    private boolean isSuccess = false;
    @JsonIgnore
    private AtomicLong checkOk = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong counter = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong totalBytes = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong errors = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong notAvailable = new AtomicLong(0L);
    @JsonIgnore
    private int maxProcessingThread = 1;
    @JsonIgnore
    private volatile ExecutorService executor;

    public DeleteBucketObjectPreviousVersionServiceRequest() {
    }

    public DeleteBucketObjectPreviousVersionServiceRequest(String string, Long l) {
        this.bucketName = string;
        this.bucketId = l;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public String getUUID() {
        return "s:" + this.getClass().getSimpleName();
    }

    public boolean isObjectOperation() {
        return true;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public Long getBucketId() {
        return this.bucketId;
    }

    public void execute() {
        try {
            this.setStatus(ServiceRequestStatus.RUNNING);
            if (instanceRunning.get()) {
                throw new IllegalStateException("There is an instance already running -> " + this.getClass().getSimpleName());
            }
            instanceRunning.set(true);
            this.start_ms = System.currentTimeMillis();
            this.counter = new AtomicLong(0L);
            this.errors = new AtomicLong(0L);
            this.notAvailable = new AtomicLong(0L);
            this.checkOk = new AtomicLong(0L);
            this.maxProcessingThread = this.getServerSettings().getIntegrityCheckThreads();
            this.executor = Executors.newFixedThreadPool(this.maxProcessingThread);
            if (this.getBucketName() != null) {
                this.processBucket(this.getBucketId());
            } else {
                for (ServerBucket serverBucket : this.getVirtualFileSystemService().listAllBuckets()) {
                    this.processBucket(serverBucket.getId());
                }
            }
            try {
                this.executor.shutdown();
                this.executor.awaitTermination(15L, TimeUnit.MINUTES);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.isSuccess = true;
            this.setStatus(ServiceRequestStatus.COMPLETED);
        }
        catch (Exception exception) {
            this.isSuccess = false;
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
        }
        finally {
            instanceRunning.set(false);
            this.logResults(logger);
        }
    }

    public void stop() {
        this.isSuccess = false;
    }

    private void processBucket(Long l) {
        Integer n = 1000;
        Long l2 = 0L;
        String string = null;
        boolean bl = false;
        while (!bl) {
            DataList dataList = this.getVirtualFileSystemService().listObjects(this.getBucketName(), Optional.of(l2), Optional.ofNullable(n), Optional.empty(), Optional.ofNullable(string));
            if (string == null) {
                string = dataList.getAgentId();
            }
            ArrayList<Callable<Object>> arrayList = new ArrayList<Callable<Object>>(dataList.getList().size());
            for (Item item : dataList.getList()) {
                arrayList.add(() -> {
                    try {
                        this.counter.getAndIncrement();
                        if (item.isOk()) {
                            this.process(item);
                        } else {
                            this.notAvailable.getAndIncrement();
                        }
                    }
                    catch (Exception exception) {
                        logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                    }
                    return null;
                });
            }
            try {
                this.executor.invokeAll(arrayList, 20L, TimeUnit.MINUTES);
            }
            catch (InterruptedException interruptedException) {
                logger.error((Throwable)interruptedException, new String[]{"---- not thrown ----"});
            }
            l2 = l2 + Long.valueOf(Integer.valueOf(dataList.getList().size()).longValue());
            bl = dataList.isEOD();
        }
    }

    private void logResults(Logger logger) {
        logger.debug("Threads: " + String.valueOf(this.maxProcessingThread));
        logger.debug("Total: " + String.valueOf(this.counter.get()));
        logger.debug("Checked OK: " + String.valueOf(this.checkOk.get()));
        logger.debug("Errors: " + String.valueOf(this.errors.get()));
        logger.debug("Not Available: " + String.valueOf(this.notAvailable.get()));
        logger.debug("Duration: " + String.valueOf(Double.valueOf(System.currentTimeMillis() - this.start_ms) / Double.valueOf(1000.0)) + " secs");
        logger.debug("---------");
    }

    private ServerSettings getServerSettings() {
        return (ServerSettings)this.getApplicationContext().getBean(ServerSettings.class);
    }

    private VirtualFileSystemService getVirtualFileSystemService() {
        return (VirtualFileSystemService)this.getApplicationContext().getBean(VirtualFileSystemService.class);
    }

    private void process(Item<ObjectMetadata> item) {
        try {
            this.getVirtualFileSystemService().deleteObjectAllPreviousVersions(((ObjectMetadata)item.getObject()).getBucketName(), ((ObjectMetadata)item.getObject()).getObjectName());
            this.checkOk.incrementAndGet();
        }
        catch (Exception exception) {
            this.errors.getAndIncrement();
            logger.error((Throwable)exception, new String[]{((ObjectMetadata)item.getObject()).getBucketName() + " - " + ((ObjectMetadata)item.getObject()).getObjectName() + " ---- not thrown ----"});
        }
    }
}

