/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.scheduler;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.odilon.log.Logger;
import io.odilon.monitor.PingService;
import io.odilon.scheduler.CronJobRequest;
import io.odilon.scheduler.ServiceRequestStatus;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@JsonTypeName(value="ping")
public class PingCronJobRequest
extends CronJobRequest {
    private static Logger logger = Logger.getLogger((String)PingCronJobRequest.class.getName());
    private static final long serialVersionUID = 1L;

    public PingCronJobRequest() {
    }

    public PingCronJobRequest(String string) {
        super(string);
    }

    public void execute() {
        try {
            this.setStatus(ServiceRequestStatus.RUNNING);
            String string = ((PingService)this.getApplicationContext().getBean(PingService.class)).pingString();
            logger.debug("ping -> " + string);
            this.setStatus(ServiceRequestStatus.COMPLETED);
        }
        catch (Throwable throwable) {
            this.setStatus(ServiceRequestStatus.ERROR);
            logger.error(throwable, new String[]{"---- not thrown ----"});
        }
    }

    public boolean isSuccess() {
        return true;
    }

    public String getUUID() {
        return "s" + this.getId().toString();
    }
}

