/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.scheduler;

import io.odilon.log.Logger;
import io.odilon.scheduler.SchedulerWorker;
import io.odilon.scheduler.ServiceRequest;
import io.odilon.scheduler.ServiceRequestStatus;
import java.time.OffsetDateTime;

public class ServiceRequestExecutor
implements Runnable {
    private static Logger logger = Logger.getLogger((String)ServiceRequestExecutor.class.getName());
    private ServiceRequest request;
    private SchedulerWorker schedulerWorker;
    private boolean success = false;

    public ServiceRequestExecutor(ServiceRequest serviceRequest, SchedulerWorker schedulerWorker) {
        this.request = serviceRequest;
        this.schedulerWorker = schedulerWorker;
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        block20: {
            this.request.setStart(OffsetDateTime.now());
            this.request.setStatus(ServiceRequestStatus.RUNNING);
            this.request.execute();
            this.success = this.request.isSuccess();
            try {
                this.request.setEnd(OffsetDateTime.now());
                if (this.success) {
                    this.schedulerWorker.close(this.request);
                    break block20;
                }
                this.schedulerWorker.fail(this.request);
            }
            catch (Throwable throwable) {
                logger.error(throwable, new String[]{"---- not thrown ----"});
                try {
                    this.request.setStatus(ServiceRequestStatus.ERROR);
                    this.schedulerWorker.fail(this.request);
                    break block20;
                }
                catch (Exception exception) {
                    logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                }
            }
            break block20;
            catch (Throwable throwable) {
                try {
                    logger.error(throwable, new String[]{"---- not thrown ----"});
                    this.request.setStatus(ServiceRequestStatus.ERROR);
                    this.success = false;
                }
                catch (Throwable throwable2) {
                    try {
                        this.request.setEnd(OffsetDateTime.now());
                        if (this.success) {
                            this.schedulerWorker.close(this.request);
                        } else {
                            this.schedulerWorker.fail(this.request);
                        }
                    }
                    catch (Throwable throwable3) {
                        logger.error(throwable3, new String[]{"---- not thrown ----"});
                        try {
                            this.request.setStatus(ServiceRequestStatus.ERROR);
                            this.schedulerWorker.fail(this.request);
                        }
                        catch (Exception exception) {
                            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                        }
                    }
                    throw throwable2;
                }
                try {
                    this.request.setEnd(OffsetDateTime.now());
                    if (this.success) {
                        this.schedulerWorker.close(this.request);
                    }
                    this.schedulerWorker.fail(this.request);
                }
                catch (Throwable throwable4) {
                    logger.error(throwable4, new String[]{"---- not thrown ----"});
                    try {
                        this.request.setStatus(ServiceRequestStatus.ERROR);
                        this.schedulerWorker.fail(this.request);
                    }
                    catch (Exception exception) {
                        logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                    }
                }
            }
        }
    }

    public void setSchedulerService(SchedulerWorker schedulerWorker) {
        this.schedulerWorker = schedulerWorker;
    }
}

