/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.scheduler;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.odilon.log.Logger;
import io.odilon.scheduler.AbstractServiceRequest;
import io.odilon.scheduler.ServiceRequestStatus;
import io.odilon.scheduler.StandardServiceRequest;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@JsonTypeName(value="test")
public class TestServiceRequest
extends AbstractServiceRequest
implements StandardServiceRequest {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)TestServiceRequest.class.getName());
    private boolean isSuccess = false;

    public void execute() {
        try {
            logger.debug("Testing " + this.getName());
        }
        catch (Exception exception) {
            this.isSuccess = false;
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
        }
        finally {
            this.isSuccess = true;
            this.setStatus(ServiceRequestStatus.COMPLETED);
        }
    }

    public void stop() {
        this.setStatus(ServiceRequestStatus.STOPPED);
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public boolean isObjectOperation() {
        return false;
    }

    public String getUUID() {
        return "t" + this.getId().toString();
    }
}

