/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.service;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.odilon.encryption.EncryptionService;
import io.odilon.error.OdilonInternalErrorException;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.model.OdilonServerInfo;
import io.odilon.model.ServiceStatus;
import io.odilon.model.SystemInfo;
import io.odilon.model.list.DataList;
import io.odilon.model.list.Item;
import io.odilon.monitor.SystemInfoService;
import io.odilon.service.BaseService;
import io.odilon.service.ObjectStorageService;
import io.odilon.service.ServerSettings;
import io.odilon.util.Check;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemObject;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import jakarta.annotation.PostConstruct;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class OdilonObjectStorageService
extends BaseService
implements ObjectStorageService,
ApplicationContextAware {
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    private static Logger logger = Logger.getLogger((String)OdilonObjectStorageService.class.getName());
    @JsonIgnore
    @Autowired
    private ServerSettings serverSettings;
    @JsonIgnore
    @Autowired
    private EncryptionService encrpytionService;
    @JsonIgnore
    @Autowired
    private VirtualFileSystemService virtualFileSystemService;
    @JsonIgnore
    private ApplicationContext applicationContext;
    @JsonIgnore
    SystemInfoService systemInfoService;
    @JsonProperty(value="port")
    private String port;
    @JsonProperty(value="accessKey")
    private String accessKey;
    @JsonProperty(value="secretKey")
    private String secretKey;
    @JsonIgnore
    private OdilonServerInfo odilonServer;

    public OdilonObjectStorageService(ServerSettings serverSettings, EncryptionService encryptionService, VirtualFileSystemService virtualFileSystemService, SystemInfoService systemInfoService) {
        this.systemInfoService = systemInfoService;
        this.serverSettings = serverSettings;
        this.encrpytionService = encryptionService;
        this.virtualFileSystemService = virtualFileSystemService;
    }

    public void wipeAllPreviousVersions() {
        Check.requireTrue((boolean)this.isVirtualFileSystemServiceEnabled(), (String)this.invalidStateMsg());
        this.getVirtualFileSystemService().wipeAllPreviousVersions();
    }

    public void deleteBucketAllPreviousVersions(String string) {
        Check.requireTrue((boolean)this.isVirtualFileSystemServiceEnabled(), (String)this.invalidStateMsg());
        this.getVirtualFileSystemService().deleteBucketAllPreviousVersions(string);
    }

    public List<ObjectMetadata> getObjectMetadataAllPreviousVersions(String string, String string2) {
        Check.requireTrue((boolean)this.isVirtualFileSystemServiceEnabled(), (String)this.invalidStateMsg());
        return this.getVirtualFileSystemService().getObjectMetadataAllVersions(string, string2);
    }

    public ObjectMetadata getObjectMetadataPreviousVersion(String string, String string2, int n) {
        Check.requireTrue((boolean)this.isVirtualFileSystemServiceEnabled(), (String)this.invalidStateMsg());
        return this.getVirtualFileSystemService().getObjectMetadataVersion(string, string2, n);
    }

    public ObjectMetadata getObjectMetadataPreviousVersion(String string, String string2) {
        Check.requireTrue((boolean)this.isVirtualFileSystemServiceEnabled(), (String)this.invalidStateMsg());
        return this.getVirtualFileSystemService().getObjectMetadataPreviousVersion(string, string2);
    }

    public InputStream getObjectPreviousVersionStream(String string, String string2, int n) {
        Check.requireTrue((boolean)this.isVirtualFileSystemServiceEnabled(), (String)this.invalidStateMsg());
        return this.getVirtualFileSystemService().getObjectVersion(string, string2, n);
    }

    public ObjectMetadata restorePreviousVersion(String string, String string2) {
        Check.requireTrue((boolean)this.isVirtualFileSystemServiceEnabled(), (String)this.invalidStateMsg());
        return this.getVirtualFileSystemService().restorePreviousVersion(string, string2);
    }

    public void deleteObjectAllPreviousVersions(String string, String string2) {
        Check.requireTrue((boolean)this.isVirtualFileSystemServiceEnabled(), (String)this.invalidStateMsg());
        this.getVirtualFileSystemService().deleteObjectAllPreviousVersions(string, string2);
    }

    public boolean hasVersions(String string, String string2) {
        Check.requireTrue((boolean)this.isVirtualFileSystemServiceEnabled(), (String)this.invalidStateMsg());
        return this.getVirtualFileSystemService().hasVersions(string, string2);
    }

    public boolean existsObject(String string, String string2) {
        Check.requireTrue((boolean)this.isVirtualFileSystemServiceEnabled(), (String)this.invalidStateMsg());
        return this.getVirtualFileSystemService().existsObject(string, string2);
    }

    public boolean isEmptyBucket(String string) {
        Check.requireTrue((boolean)this.isVirtualFileSystemServiceEnabled(), (String)this.invalidStateMsg());
        return this.getVirtualFileSystemService().isEmptyBucket(string);
    }

    public void deleteObject(String string, String string2) {
        Check.requireTrue((boolean)this.isVirtualFileSystemServiceEnabled(), (String)this.invalidStateMsg());
        if (this.getServerSettings().isReadOnly() || this.getServerSettings().isWORM()) {
            throw new IllegalStateException(this.dataStorageModeMsg(string, string2));
        }
        this.getVirtualFileSystemService().deleteObject(this.getVirtualFileSystemService().getBucketByName(string), string2);
    }

    public DataList<Item<ObjectMetadata>> listObjects(String string, Optional<Long> optional, Optional<Integer> optional2, Optional<String> optional3, Optional<String> optional4) {
        Check.requireTrue((boolean)this.isVirtualFileSystemServiceEnabled(), (String)this.invalidStateMsg());
        return this.getVirtualFileSystemService().listObjects(string, optional, optional2, optional3, optional4);
    }

    public void putObject(String string, String string2, File file) {
        Check.requireTrue((boolean)this.isVirtualFileSystemServiceEnabled(), (String)this.invalidStateMsg());
        Check.requireNonNullStringArgument((String)string, (String)"bucketName can not be null or empty");
        Check.requireNonNullStringArgument((String)string2, (String)("objectName can not be null or empty | b:" + string));
        Check.requireNonNullArgument((Object)file, (String)("file is null | b: " + string + " o: " + string2));
        if (this.getServerSettings().isReadOnly()) {
            throw new IllegalStateException(this.dataStorageModeMsg(string, string2));
        }
        if (this.getServerSettings().isWORM() && this.existsObject(string, string2)) {
            throw new IllegalStateException(this.dataStorageModeMsg(string, string2));
        }
        Path path = file.toPath();
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new IllegalArgumentException("'" + file.getName() + "': not a regular file");
        }
        String string3 = null;
        FileInputStream fileInputStream = null;
        try {
            string3 = Files.probeContentType(path);
            fileInputStream = new FileInputStream(file);
        }
        catch (IOException iOException) {
            throw new OdilonInternalErrorException((Exception)iOException);
        }
        this.putObject(string, string2, (InputStream)new BufferedInputStream(fileInputStream), file.getName(), string3);
    }

    public void putObject(String string, String string2, InputStream inputStream, String string3, String string4) {
        this.putObject(string, string2, inputStream, string3, string4, Optional.empty());
    }

    public void putObject(String string, String string2, InputStream inputStream, String string3, String string4, Optional<List<String>> optional) {
        Check.requireTrue((boolean)this.isVirtualFileSystemServiceEnabled(), (String)this.invalidStateMsg());
        Check.requireNonNullStringArgument((String)string, (String)"bucketName can not be null or empty");
        Check.requireNonNullStringArgument((String)string2, (String)("objectName can not be null or empty | b:" + string));
        Check.requireNonNullStringArgument((String)string3, (String)("file is null | b: " + string + " o:" + string2));
        Check.requireNonNullArgument((Object)inputStream, (String)("InpuStream can not null -> b:" + string + " | o:" + string2));
        if (this.getServerSettings().isReadOnly()) {
            throw new IllegalStateException(this.dataStorageModeMsg(string, string2));
        }
        if (this.getServerSettings().isWORM() && this.existsObject(string, string2)) {
            throw new IllegalStateException(this.dataStorageModeMsg(string, string2));
        }
        if (string2.length() < 1 || string2.length() > 2048) {
            throw new IllegalArgumentException("objectName must be >0 and <" + String.valueOf(2048) + ", and Name must match the java regex ->  ^[^*\\?<>|/]+$ | o:" + string2);
        }
        if (!string2.matches("^[^*\\?<>|/]+$")) {
            throw new IllegalArgumentException("objectName must be >0 and <" + String.valueOf(2048) + ", and Name must match the java regex ->  ^[^*\\?<>|/]+$ | o:" + string2);
        }
        try {
            this.getVirtualFileSystemService().putObject(string, string2, inputStream, string3, string4, optional);
        }
        catch (Exception exception) {
            throw new OdilonInternalErrorException(exception);
        }
    }

    public InputStream getObjectStream(String string, String string2) {
        Check.requireTrue((boolean)this.isVirtualFileSystemServiceEnabled(), (String)this.invalidStateMsg());
        InputStream inputStream = null;
        try {
            inputStream = this.getVirtualFileSystemService().getObjectStream(string, string2);
            return inputStream;
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    logger.error((Throwable)iOException, new String[]{"---- not thrown ----"});
                }
            }
            throw new InternalCriticalException(exception);
        }
    }

    public VirtualFileSystemObject getObject(String string, String string2) {
        Check.requireTrue((boolean)this.isVirtualFileSystemServiceEnabled(), (String)this.invalidStateMsg());
        return this.getVirtualFileSystemService().getObject(string, string2);
    }

    public ObjectMetadata getObjectMetadata(String string, String string2) {
        Check.requireTrue((boolean)this.isVirtualFileSystemServiceEnabled(), (String)this.invalidStateMsg());
        return this.getVirtualFileSystemService().getObjectMetadata(this.getVirtualFileSystemService().getBucketByName(string), string2);
    }

    public boolean existsBucket(String string) {
        Check.requireTrue((boolean)this.isVirtualFileSystemServiceEnabled(), (String)this.invalidStateMsg());
        return this.getVirtualFileSystemService().existsBucket(string);
    }

    public ServerBucket findBucketName(String string) {
        Check.requireTrue((boolean)this.isVirtualFileSystemServiceEnabled(), (String)this.invalidStateMsg());
        return this.getVirtualFileSystemService().getBucketByName(string);
    }

    public ServerBucket createBucket(String string) {
        Check.requireTrue((boolean)this.isVirtualFileSystemServiceEnabled(), (String)this.invalidStateMsg());
        Check.requireNonNullStringArgument((String)string, (String)"bucketName can not be null or empty");
        if (this.getServerSettings().isReadOnly()) {
            throw new IllegalStateException(this.dataStorageModeMsg(string));
        }
        if (this.getServerSettings().isWORM() && this.existsBucket(string)) {
            throw new IllegalStateException(this.dataStorageModeMsg(string));
        }
        if (string.length() < 1 || string.length() > 2048) {
            throw new IllegalArgumentException("bucketName must be >0 and <" + String.valueOf(2048) + " and must contain just lowercase letters and numbers, java regex = '[A-Za-z0-9\\-_]+' | b:" + string);
        }
        if (!string.matches("[A-Za-z0-9\\-_]+")) {
            throw new IllegalArgumentException("bucketName must be >0 and <" + String.valueOf(2048) + " and must contain just lowercase letters and numbers, java regex = '[A-Za-z0-9\\-_]+' | b:" + string);
        }
        try {
            return this.getVirtualFileSystemService().createBucket(string);
        }
        catch (Exception exception) {
            throw new OdilonInternalErrorException(exception);
        }
    }

    public ServerBucket updateBucketName(ServerBucket serverBucket, String string) {
        Check.requireTrue((boolean)this.isVirtualFileSystemServiceEnabled(), (String)this.invalidStateMsg());
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket can not be null or empty");
        Check.requireNonNullStringArgument((String)string, (String)"newbucketName can not be null or empty");
        if (this.getServerSettings().isReadOnly()) {
            throw new IllegalStateException(this.dataStorageModeMsg(serverBucket.getName()));
        }
        if (this.getServerSettings().isWORM()) {
            throw new IllegalStateException(this.dataStorageModeMsg(serverBucket.getName()));
        }
        if (string.length() < 1 || string.length() > 2048) {
            throw new IllegalArgumentException("bucketName must be >0 and <" + String.valueOf(2048) + " and must contain just lowercase letters and numbers, java regex = '[A-Za-z0-9\\-_]+' | b:" + string);
        }
        if (!string.matches("[A-Za-z0-9\\-_]+")) {
            throw new IllegalArgumentException("bucketName must be >0 and <" + String.valueOf(2048) + " and must contain just lowercase letters and numbers, java regex = '[A-Za-z0-9\\-_]+' | b:" + string);
        }
        if (this.existsBucket(string)) {
            throw new IllegalArgumentException("bucketName already used " + string);
        }
        try {
            return this.getVirtualFileSystemService().renameBucketName(serverBucket.getName(), string);
        }
        catch (Exception exception) {
            throw new OdilonInternalErrorException(exception);
        }
    }

    public void deleteBucketByName(String string) {
        Check.requireTrue((boolean)this.isVirtualFileSystemServiceEnabled(), (String)this.invalidStateMsg());
        if (this.getServerSettings().isReadOnly()) {
            throw new IllegalStateException(this.dataStorageModeMsg(string));
        }
        if (this.getServerSettings().isWORM()) {
            if (this.existsBucket(string)) {
                throw new IllegalStateException(this.dataStorageModeMsg(string));
            }
            return;
        }
        this.getVirtualFileSystemService().removeBucket(string);
    }

    public void forceDeleteBucket(String string) {
        Check.requireTrue((boolean)this.isVirtualFileSystemServiceEnabled(), (String)this.invalidStateMsg());
        if (this.getServerSettings().isReadOnly()) {
            throw new IllegalStateException(this.dataStorageModeMsg(string));
        }
        if (this.getServerSettings().isWORM()) {
            if (this.existsBucket(string)) {
                throw new IllegalStateException(this.dataStorageModeMsg(string));
            }
            return;
        }
        this.getVirtualFileSystemService().forceRemoveBucket(string);
    }

    public List<ServerBucket> findAllBuckets() {
        Check.requireTrue((boolean)this.isVirtualFileSystemServiceEnabled(), (String)this.invalidStateMsg());
        return this.getVirtualFileSystemService().listAllBuckets();
    }

    public String ping() {
        if (!this.isVirtualFileSystemServiceEnabled()) {
            return VirtualFileSystemService.class.getSimpleName() + " not enabled -> " + this.getVirtualFileSystemService().getStatus().toString();
        }
        return this.getVirtualFileSystemService().ping();
    }

    public SystemInfo getSystemInfo() {
        return this.systemInfoService.getSystemInfo();
    }

    public ServerSettings getServerSettings() {
        return this.serverSettings;
    }

    public EncryptionService getEncryptionService() {
        return this.encrpytionService;
    }

    public boolean isEncrypt() {
        return this.getServerSettings().isEncryptionEnabled();
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public VirtualFileSystemService getVirtualFileSystemService() {
        return this.virtualFileSystemService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    protected void onInitialize() {
        OdilonObjectStorageService odilonObjectStorageService = this;
        synchronized (odilonObjectStorageService) {
            try {
                this.setStatus(ServiceStatus.STARTING);
                this.port = String.valueOf(this.getServerSettings().getPort());
                this.accessKey = this.getServerSettings().getAccessKey();
                this.secretKey = this.getServerSettings().getSecretKey();
                startuplogger.debug("Started -> " + ObjectStorageService.class.getSimpleName());
                this.setStatus(ServiceStatus.RUNNING);
            }
            catch (Exception exception) {
                this.setStatus(ServiceStatus.STOPPED);
                throw exception;
            }
        }
    }

    private boolean isVirtualFileSystemServiceEnabled() {
        return this.getVirtualFileSystemService().getStatus() == ServiceStatus.RUNNING;
    }

    private String invalidStateMsg() {
        return VirtualFileSystemService.class.getSimpleName() + " invalid state -> " + this.getVirtualFileSystemService().getStatus().toString();
    }

    private String dataStorageModeMsg(String string) {
        return "Illegal operation for Data Storage Mode -> " + this.getServerSettings().getDataStorage().getName() + " | b: " + string;
    }

    private String dataStorageModeMsg(String string, String string2) {
        return "Illegal operation for Data Storage Mode -> " + this.getServerSettings().getDataStorage().getName() + " | b: " + string + " o: " + string2;
    }

    public Map<String, String> getSystemLibrariesInfo() {
        return this.systemInfoService.getSystemLibrariesInfo();
    }
}

