/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem;

import io.odilon.virtualFileSystem.Context;
import io.odilon.virtualFileSystem.PathBuilder;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.ServerBucket;
import java.nio.file.Path;
import java.nio.file.Paths;

public class BucketPath
extends PathBuilder {
    static final String BUCKET_METADATA = "bucketmetadata-";
    private final Drive drive;
    private final ServerBucket bucket;

    public BucketPath(Drive drive, ServerBucket serverBucket) {
        this.drive = drive;
        this.bucket = serverBucket;
    }

    public Path cacheDirPath() {
        return null;
    }

    public Path workDirPath() {
        return Paths.get(this.getDrive().getBucketWorkDirPath(this.getBucket()), new String[0]);
    }

    public Path bucketMetadata(Context context) {
        if (context == Context.BACKUP) {
            return this.workDirPath().resolve(BUCKET_METADATA + this.getBucket().getId().toString() + ".json");
        }
        throw new RuntimeException("not done");
    }

    private Drive getDrive() {
        return this.drive;
    }

    private ServerBucket getBucket() {
        return this.bucket;
    }

    public Path dataDirPath() {
        return null;
    }

    public Path metadataDirPath() {
        return null;
    }
}

