/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.model.ServiceStatus;
import io.odilon.model.list.DataList;
import io.odilon.model.list.Item;
import io.odilon.service.ServerSettings;
import io.odilon.util.Check;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class DataIntegrityChecker
implements Runnable,
ApplicationContextAware {
    private static Logger logger = Logger.getLogger((String)DataIntegrityChecker.class.getName());
    private static Logger checkerLogger = Logger.getLogger((String)"dataIntegrityCheck");
    private boolean forceCheckAll = false;
    private int maxProcessingThread = 1;
    @JsonIgnore
    long start_ms = 0L;
    @JsonIgnore
    private Thread thread;
    @JsonIgnore
    private ApplicationContext applicationContext;
    @JsonIgnore
    @Autowired
    VirtualFileSystemService vfs;
    @JsonIgnore
    @Autowired
    ServerSettings settings;
    @JsonIgnore
    private AtomicLong checkOk = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong counter = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong totalBytes = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong errors = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong notAvailable = new AtomicLong(0L);

    public DataIntegrityChecker() {
    }

    public DataIntegrityChecker(VirtualFileSystemService virtualFileSystemService, ServerSettings serverSettings) {
        this.vfs = virtualFileSystemService;
        this.settings = serverSettings;
    }

    public DataIntegrityChecker(boolean bl) {
        this.forceCheckAll = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        checkerLogger.info("Starting -> " + this.getClass().getSimpleName());
        if (this.getVirtualFileSystemService().getStatus() != ServiceStatus.RUNNING) {
            throw new IllegalStateException(this.getVirtualFileSystemService().getClass().getSimpleName() + " is not in status " + ServiceStatus.RUNNING.getName());
        }
        if (this.getVirtualFileSystemService().getReplicationService().isInitialSync().get()) {
            checkerLogger.info("Can not run integrity checker while there is a Master - StandBy sync in process");
            return;
        }
        this.counter = new AtomicLong(0L);
        this.errors = new AtomicLong(0L);
        this.notAvailable = new AtomicLong(0L);
        this.checkOk = new AtomicLong(0L);
        this.maxProcessingThread = this.getServerSettings().getIntegrityCheckThreads();
        this.start_ms = System.currentTimeMillis();
        ExecutorService executorService = null;
        try {
            executorService = Executors.newFixedThreadPool(this.getMaxProcessingThread());
            for (ServerBucket serverBucket : this.getVirtualFileSystemService().listAllBuckets()) {
                Integer n = 1000;
                Long l = 0L;
                String string = null;
                boolean bl = false;
                while (!bl) {
                    DataList dataList = this.getVirtualFileSystemService().listObjects(serverBucket.getName(), Optional.of(l), Optional.ofNullable(n), Optional.empty(), Optional.ofNullable(string));
                    if (string == null) {
                        string = dataList.getAgentId();
                    }
                    ArrayList<Callable<Object>> arrayList = new ArrayList<Callable<Object>>(dataList.getList().size());
                    for (Item item : dataList.getList()) {
                        arrayList.add(() -> {
                            try {
                                this.counter.getAndIncrement();
                                if (item.isOk()) {
                                    this.check(item);
                                } else {
                                    this.notAvailable.getAndIncrement();
                                }
                            }
                            catch (Exception exception) {
                                logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                                checkerLogger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                            }
                            return null;
                        });
                    }
                    try {
                        executorService.invokeAll(arrayList, 20L, TimeUnit.MINUTES);
                    }
                    catch (InterruptedException interruptedException) {
                        logger.error((Throwable)interruptedException, new String[]{"---- not thrown ----"});
                        checkerLogger.error((Throwable)interruptedException, new String[]{"---- not thrown ----"});
                    }
                    l = l + Long.valueOf(Integer.valueOf(dataList.getList().size()).longValue());
                    bl = dataList.isEOD();
                }
            }
            try {
                executorService.shutdown();
                executorService.awaitTermination(15L, TimeUnit.MINUTES);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        finally {
            this.logResults(checkerLogger);
            this.logResults(logger);
        }
    }

    @PostConstruct
    public void onInitialize() {
        this.thread = new Thread((Runnable)this);
        this.thread.setDaemon(true);
        this.thread.setName(this.getClass().getSimpleName());
        this.thread.start();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName() + "{");
        stringBuilder.append(this.toJSON());
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public String toJSON() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\"name\":" + (Optional.ofNullable(this.thread).isPresent() ? this.thread.getName() : "null"));
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
            return "\"error\":\"" + exception.getClass().getName() + " | " + exception.getMessage() + "\"";
        }
    }

    public VirtualFileSystemService getVirtualFileSystemService() {
        return this.vfs;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public int getMaxProcessingThread() {
        return this.maxProcessingThread;
    }

    public void setMaxProcessingThread(int n) {
        this.maxProcessingThread = n;
    }

    private void check(Item<ObjectMetadata> item) {
        try {
            Check.requireNonNullArgument(item, (String)"item is null");
            boolean bl = this.getVirtualFileSystemService().checkIntegrity(((ObjectMetadata)item.getObject()).bucketName, ((ObjectMetadata)item.getObject()).objectName, this.forceCheckAll);
            this.totalBytes.addAndGet(((ObjectMetadata)item.getObject()).length);
            if (!bl) {
                this.errors.getAndIncrement();
                logger.error(new String[]{"Could not fix -> " + ((ObjectMetadata)item.getObject()).bucketName + " - " + ((ObjectMetadata)item.getObject()).objectName});
                checkerLogger.error(new String[]{"Could not fix -> " + ((ObjectMetadata)item.getObject()).bucketName + " - " + ((ObjectMetadata)item.getObject()).objectName});
            } else {
                this.checkOk.getAndIncrement();
            }
        }
        catch (Exception exception) {
            checkerLogger.error((Throwable)exception, new String[]{"---- not thrown ----"});
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
        }
    }

    private void logResults(Logger logger) {
        logger.info("Threads: " + String.valueOf(this.getMaxProcessingThread()));
        logger.info("Total: " + String.valueOf(this.counter.get()));
        logger.info("Total Size: " + String.format("%14.4f", Double.valueOf(this.totalBytes.get()) / 1.073741824E9).trim() + " GB");
        logger.info("Checked OK: " + String.valueOf(this.checkOk.get()));
        logger.info("Errors: " + String.valueOf(this.errors.get()));
        logger.info("Not Available: " + String.valueOf(this.notAvailable.get()));
        logger.info("Duration: " + String.valueOf(Double.valueOf(System.currentTimeMillis() - this.start_ms) / Double.valueOf(1000.0)) + " secs");
        logger.info("---------");
    }

    private ServerSettings getServerSettings() {
        return this.settings;
    }
}

