/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem;

import com.google.common.io.Files;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.BaseObject;
import io.odilon.model.OdilonServerInfo;
import io.odilon.service.util.ByteToString;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.IODriver;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import java.io.File;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.springframework.context.ConfigurableApplicationContext;

public class EncryptionInitializer
extends BaseObject {
    private static Logger logger = Logger.getLogger((String)EncryptionInitializer.class.getName());
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    private Optional<String> providedMasterKey;
    private VirtualFileSystemService vfs;

    public EncryptionInitializer(VirtualFileSystemService virtualFileSystemService, Optional<String> optional) {
        this.vfs = virtualFileSystemService;
        this.providedMasterKey = optional;
    }

    public VirtualFileSystemService getVirtualFileSystemService() {
        return this.vfs;
    }

    public void execute() {
        if (this.getProvidedMasterKey().isPresent()) {
            this.rekey();
        } else {
            this.initializeEnc();
        }
    }

    public void notInitializedError() {
        startuplogger.info("");
        startuplogger.info("The server is configured to use encryption (ie. 'encryption.enabled=true' in file 'odilon.properties')");
        startuplogger.info("but the encryption service has not been initialized yet.");
        startuplogger.info("");
        startuplogger.info("You have to either:");
        startuplogger.info("a. Disable encryption in 'odilon.properties' by changing the variable to 'encryption.enabled=false' or");
        startuplogger.info("");
        startuplogger.info("b. Initialize the encryption service by executing '" + this.getEnableEncryptionScriptName() + "'");
        startuplogger.info("");
        startuplogger.info("If you execute '" + this.getEnableEncryptionScriptName() + "' Odilon will generate the encryption keys");
        startuplogger.info("The server will shutdown now.");
        startuplogger.info("");
        startuplogger.info("---------------------------------");
        try {
            Thread.sleep(6000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ((ConfigurableApplicationContext)this.getVirtualFileSystemService().getApplicationContext()).close();
        System.exit(1);
    }

    private synchronized void initializeEnc() {
        byte[] byArray;
        startuplogger.info("Initializing Encryption Service");
        startuplogger.info("");
        IODriver iODriver = this.getVirtualFileSystemService().createVFSIODriver();
        OdilonServerInfo odilonServerInfo = iODriver.getServerInfo();
        if (odilonServerInfo == null) {
            odilonServerInfo = this.getVirtualFileSystemService().getServerSettings().getDefaultOdilonServerInfo();
        }
        if (odilonServerInfo.isEncryptionIntialized()) {
            startuplogger.info("Encryption Service has already been initialized on -> " + odilonServerInfo.getEncryptionIntializedDate().toString());
            startuplogger.info("The server will shutdown now.");
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ((ConfigurableApplicationContext)this.getVirtualFileSystemService().getApplicationContext()).close();
            System.exit(1);
        }
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray2 = new byte[16];
        byte[] byArray3 = new byte[12];
        byte[] byArray4 = new byte[16];
        byte[] byArray5 = new byte[64];
        secureRandom.nextBytes(byArray2);
        secureRandom.nextBytes(byArray3);
        secureRandom.nextBytes(byArray4);
        secureRandom.nextBytes(byArray5);
        byte[] byArray6 = new byte[byArray2.length + byArray3.length];
        System.arraycopy(byArray2, 0, byArray6, 0, byArray2.length);
        System.arraycopy(byArray3, 0, byArray6, byArray2.length, byArray3.length);
        try {
            byArray = this.getVirtualFileSystemService().HMAC(byArray6, byArray2);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
            throw new InternalCriticalException((Exception)generalSecurityException);
        }
        this.getVirtualFileSystemService().getMasterKeyEncryptorService().setKeyToEncryptMasterKey(byArray2, byArray3);
        iODriver.saveServerMasterKey(byArray4, byArray, byArray3, byArray5);
        odilonServerInfo.setEncryptionIntialized(true);
        OffsetDateTime offsetDateTime = OffsetDateTime.now();
        odilonServerInfo.setEncryptionIntializedDate(offsetDateTime);
        odilonServerInfo.setEncryptionLastModifiedDate(offsetDateTime);
        iODriver.setServerInfo(odilonServerInfo);
        startuplogger.info("ENCRYPTION KEY");
        startuplogger.info("--------------");
        startuplogger.info("encryption.key = " + ByteToString.byteToHexString((byte[])byArray6));
        startuplogger.info("The encrytion key must be added to the 'odilon.properties' file in variable 'encryption.key' as printed above.");
        startuplogger.info("");
        startuplogger.info("MASTER KEY");
        startuplogger.info("----------");
        startuplogger.info("Master Key -> " + ByteToString.byteToHexString((byte[])byArray4));
        startuplogger.info("");
        startuplogger.info("The master key is used internally and it is secret, it is NOT required in 'odilon.properties' or anywhere else.");
        startuplogger.info("However it may be required to restore the system in case some critical system files are");
        startuplogger.info("accidental or intentionally deleted in the future.");
        startuplogger.info("It is recommended that you store it securely.");
        startuplogger.info("");
        startuplogger.info("process completed.");
        try {
            File file = ((Drive)iODriver.getDrivesEnabled().get(0)).getSysFile("key.enc");
            File file2 = new File(System.getProperty("user.dir") + File.separator + "config" + File.separator + file.getName());
            Files.copy((File)file, (File)file2);
            startuplogger.info("");
            startuplogger.info("Odilon made a backup of the encrypted key to -> " + System.getProperty("user.dir") + File.separator + "config" + File.separator + file.getName());
            startuplogger.info("");
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"Backup encrypted key to -> " + System.getProperty("user.dir") + File.separator + "config"});
        }
        this.shutDown(0);
    }

    private synchronized void rekey() {
        byte[] byArray;
        String string;
        String string2;
        startuplogger.info("NEW ENCRYPTION KEY");
        startuplogger.info("------------------");
        IODriver iODriver = this.getVirtualFileSystemService().createVFSIODriver();
        OdilonServerInfo odilonServerInfo = iODriver.getServerInfo();
        if (odilonServerInfo == null) {
            odilonServerInfo = this.getVirtualFileSystemService().getServerSettings().getDefaultOdilonServerInfo();
        }
        if (!odilonServerInfo.isEncryptionIntialized()) {
            this.rekeyNotIntializedError();
            return;
        }
        boolean bl = false;
        byte[] byArray2 = iODriver.getServerMasterKey();
        if (byArray2 == null) {
            startuplogger.info("Server's master key is null");
            this.shutDown(1);
        }
        if (!(bl = (string2 = ByteToString.byteToHexString((byte[])byArray2)).equals(string = (String)this.providedMasterKey.get()))) {
            this.rekeyMasterKeyNotCorrectError();
            return;
        }
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray3 = new byte[16];
        byte[] byArray4 = new byte[12];
        byte[] byArray5 = new byte[64];
        secureRandom.nextBytes(byArray3);
        secureRandom.nextBytes(byArray4);
        secureRandom.nextBytes(byArray5);
        byte[] byArray6 = new byte[byArray3.length + byArray4.length];
        System.arraycopy(byArray3, 0, byArray6, 0, byArray3.length);
        System.arraycopy(byArray4, 0, byArray6, byArray3.length, byArray4.length);
        try {
            byArray = this.getVirtualFileSystemService().HMAC(byArray6, byArray3);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
            throw new InternalCriticalException((Exception)generalSecurityException);
        }
        this.getVirtualFileSystemService().getMasterKeyEncryptorService().setKeyToEncryptMasterKey(byArray3, byArray4);
        iODriver.saveServerMasterKey(byArray2, byArray, byArray4, byArray5);
        odilonServerInfo.setEncryptionIntialized(true);
        odilonServerInfo.setEncryptionLastModifiedDate(OffsetDateTime.now());
        iODriver.setServerInfo(odilonServerInfo);
        startuplogger.info("encryption.key = " + ByteToString.byteToHexString((byte[])byArray6));
        startuplogger.info("The encrytion key must replice the previous value of encryption.key in 'odilon.properties'.");
        startuplogger.info("");
        startuplogger.info("");
        startuplogger.info("process completed.");
        try {
            File file = ((Drive)iODriver.getDrivesEnabled().get(0)).getSysFile("key.enc");
            File file2 = new File(System.getProperty("user.dir") + File.separator + "config" + File.separator + file.getName());
            Files.copy((File)file, (File)file2);
            startuplogger.info("");
            startuplogger.info("Odilon made a backup of the encrypted key to -> " + System.getProperty("user.dir") + File.separator + "config" + File.separator + file.getName());
            startuplogger.info("");
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"Backup encrypted key to -> " + System.getProperty("user.dir") + File.separator + "config"});
        }
        this.shutDown(0);
    }

    private void rekeyMasterKeyNotCorrectError() {
        startuplogger.info("");
        startuplogger.info("The Master key provided -> " + (String)this.providedMasterKey.get());
        startuplogger.info("is incorrect");
        startuplogger.info("The server will shutdown now.");
        startuplogger.info("---------------------------------");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ((ConfigurableApplicationContext)this.getVirtualFileSystemService().getApplicationContext()).close();
        System.exit(1);
    }

    private void rekeyNotIntializedError() {
        startuplogger.info("The Encryption Service has not been initialized.");
        startuplogger.info("You have to initialize the Encryption Service by executing '" + this.getEnableEncryptionScriptName() + "', Odilon will generate the encryption keys");
        startuplogger.info("");
        startuplogger.info("The server will shutdown now.");
        startuplogger.info("---------------------------------");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ((ConfigurableApplicationContext)this.getVirtualFileSystemService().getApplicationContext()).close();
        System.exit(1);
    }

    private String getEnableEncryptionScriptName() {
        return this.isLinux() ? "enable-encryption.sh" : "enable-encryption.bat";
    }

    private boolean isLinux() {
        return System.getenv("OS") == null || !System.getenv("OS").toLowerCase().contains("windows");
    }

    private Optional<String> getProvidedMasterKey() {
        return this.providedMasterKey;
    }

    private void shutDown(int n) {
        startuplogger.info("The server will shutdown now.");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ((ConfigurableApplicationContext)this.getVirtualFileSystemService().getApplicationContext()).close();
        System.exit(n);
    }
}

