/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.virtualFileSystem.Context;
import io.odilon.virtualFileSystem.PathBuilder;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.ServerBucket;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ObjectPath
extends PathBuilder {
    private static Logger logger = Logger.getLogger((String)ObjectPath.class.getName());
    @JsonProperty(value="drive")
    private final Drive drive;
    @JsonProperty(value="objectName")
    private final String objectName;
    @JsonProperty(value="bucketId")
    private final Long bucketId;

    public ObjectPath(Drive drive, ServerBucket serverBucket, String string) {
        this.drive = drive;
        this.objectName = string;
        this.bucketId = serverBucket.getId();
    }

    public ObjectPath(Drive drive, Long l, String string) {
        this.drive = drive;
        this.objectName = string;
        this.bucketId = l;
    }

    public ObjectPath(Drive drive, ObjectMetadata objectMetadata) {
        this.drive = drive;
        this.objectName = objectMetadata.getObjectName();
        this.bucketId = objectMetadata.getBucketId();
    }

    public Path metadataDirPath() {
        return this.metadataDirPath(Context.STORAGE);
    }

    public Path metadataDirPath(Context context) {
        if (context == Context.STORAGE) {
            return Paths.get(this.getBucketsDirPath(), new String[0]).resolve(this.getBucketId().toString() + File.separator + this.getObjectName());
        }
        throw new RuntimeException("not done");
    }

    public Path metadataFilePath() {
        return this.metadataFilePath(Context.STORAGE);
    }

    public Path metadataFilePath(Context context) {
        return this.metadataDirPath(context).resolve(this.getObjectName() + ".json");
    }

    public Path metadataFileVersionPath(int n) {
        return this.metadataDirPath(Context.STORAGE).resolve(this.getObjectName() + ".v" + String.valueOf(n) + ".json");
    }

    public Path metadataFileVersionPath(Context context) {
        return this.metadataDirPath(context).resolve(this.getObjectName() + ".json");
    }

    public Path metadataBackupDirPath() {
        return Paths.get(this.getBucketWorkDirPath(), this.getObjectName());
    }

    public String getBucketsDirPath() {
        return this.getDrive().getBucketsDirPath();
    }

    private String getBucketWorkDirPath() {
        return this.getDrive().getWorkDirPath() + File.separator + this.getBucketId().toString();
    }

    public Path dataFilePath() {
        return this.dataFilePath(Context.STORAGE);
    }

    public Path dataFilePath(Context context) {
        if (context == Context.STORAGE) {
            return Paths.get(this.getDrive().getRootDirPath(), this.getBucketId().toString() + File.separator + this.getObjectName());
        }
        throw new RuntimeException("not done");
    }

    public Path metadataWorkFilePath() {
        return Paths.get(this.getBucketWorkDirPath(), this.getObjectName());
    }

    public Path dataFileVersionPath(int n) {
        return this.dataFileVersionPath(Context.STORAGE, n);
    }

    public Path dataFileVersionPath(Context context, int n) {
        if (context == Context.STORAGE) {
            return Paths.get(this.getDrive().getRootDirPath() + File.separator + this.getBucketId().toString() + File.separator + "version", this.getObjectName() + ".v" + String.valueOf(n));
        }
        throw new RuntimeException("not done");
    }

    private Long getBucketId() {
        return this.bucketId;
    }

    private String getObjectName() {
        return this.objectName;
    }

    private Drive getDrive() {
        return this.drive;
    }
}

